/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import oracle.ons.Message;
import oracle.ons.MessageReader;
import oracle.ons.NodeAddress;
import oracle.ons.Notification;
import oracle.ons.NotificationManager;
import oracle.ons.NotificationNetwork;
import oracle.ons.ONSConfiguration;
import oracle.ons.ONSException;
import oracle.ons.ServerError;
import oracle.ons.SubscriptionProxy;
import oracle.ons.spi.ONSSocket;
import oracle.ons.spi.SocketCallback;

class Node
implements SocketCallback {
    static long PING_TIMEOUT = 20000L;
    private final NodeAddress address;
    private final NotificationManager master;
    private final ONSConfiguration conf;
    private ONSSocket socket;
    private volatile long lastMessageTime = 0L;
    private volatile long pingTime = 0L;
    private int protocolVersion = 0;
    private final AtomicBoolean pinged = new AtomicBoolean(false);
    private final AtomicBoolean waitersAreWaiting = new AtomicBoolean(false);
    private final List<BlockingQueue<Node>> waiters = new ArrayList<BlockingQueue<Node>>();
    private static AtomicInteger globalId = new AtomicInteger(1);
    private final MessageReader messageReader = new MessageReader();
    private final Map<String, ServerSubscriptionProxy> subscriberIndex = new ConcurrentHashMap<String, ServerSubscriptionProxy>();
    private final Map<String, ServerSubscriptionProxy> subscriptionToProxy = new HashMap<String, ServerSubscriptionProxy>();
    private static final int STATE_NOT_CONNECTED = 0;
    private static final int STATE_NOT_INITIALIZED = 1;
    private static final int STATE_INITIALIZED = 2;
    private static final int STATE_SHUTDOWN = 3;
    private AtomicInteger state = new AtomicInteger(0);
    private Set<NotificationNetwork> userSet = new HashSet<NotificationNetwork>();

    public NodeAddress getAddress() {
        return this.address;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    private void sendPingMessage(long l2) {
        if (this.pinged.compareAndSet(false, true)) {
            this.master.logger.finest(this.address.toString() + " : Pinging");
            if (this.protocolVersion >= 5) {
                this.send(new Message("echo"));
            } else {
                this.send(new Message("subscribe").put("Subscription", "[").put("SubscriberID", "99"));
            }
            this.pingTime = System.currentTimeMillis();
        } else if (l2 - this.pingTime > this.conf.getSocketTimeout()) {
            this.master.logger.warning(this.address.toString() + " : Not answered to the ping request");
            this.close(true);
        }
    }

    void checkConnection(long l2) {
        if (l2 - this.lastMessageTime <= PING_TIMEOUT) {
            this.pinged.set(false);
            return;
        }
        this.sendPingMessage(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ping(BlockingQueue<Node> blockingQueue) {
        if (blockingQueue != null) {
            List<BlockingQueue<Node>> list = this.waiters;
            synchronized (list) {
                this.waiters.add(blockingQueue);
                this.waitersAreWaiting.set(true);
            }
        }
    }

    Node(NotificationManager notificationManager, NodeAddress nodeAddress, ONSConfiguration oNSConfiguration) throws ONSException {
        this.master = notificationManager;
        this.conf = oNSConfiguration;
        this.address = nodeAddress;
    }

    private boolean connect() throws ONSException {
        if (this.state.compareAndSet(0, 1)) {
            this.master.logger.log(Level.FINE, "Creating connection to node " + this.address.toString());
            this.master.getWorkloadManager().schedule(new NodeConnectAction());
            return true;
        }
        return this.state.get() != 3;
    }

    private void close(boolean bl2) {
        if (this.state.compareAndSet(2, 3) || this.state.compareAndSet(1, 3)) {
            if (!bl2) {
                this.onNodeDown();
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    this.master.logger.fine(this.address.toString() + iOException.toString());
                }
            }
            if (bl2) {
                this.onNodeDown();
            }
        }
        this.state.set(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean register(NotificationNetwork notificationNetwork) {
        boolean bl2 = false;
        Node node = this;
        synchronized (node) {
            if (this.state.get() == 3) {
                return false;
            }
            this.master.logger.finest(String.format("Network %s is registering at node %s", notificationNetwork.toString(), this.toString()));
            if (this.userSet.add(notificationNetwork)) {
                if (this.isConnected()) {
                    bl2 = true;
                } else {
                    return this.connect();
                }
            }
        }
        if (bl2) {
            try {
                notificationNetwork.onNodeUp(this);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(NotificationNetwork notificationNetwork) {
        boolean bl2;
        Node node = this;
        synchronized (node) {
            this.userSet.remove(notificationNetwork);
            bl2 = this.userSet.isEmpty();
        }
        if (bl2) {
            this.close(false);
        }
    }

    public boolean isConnected() {
        return this.state.get() == 2;
    }

    public boolean isGarbage() {
        return this.state.get() == 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(Message message) throws ONSException {
        try {
            Node node = this;
            synchronized (node) {
                message.ready().send(this.socket.getOutputStream()).flush();
            }
        }
        catch (IOException iOException) {
            this.close(true);
            throw new ServerError(iOException.getLocalizedMessage(), message.dump());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void processMessage(Notification notification) {
        String[] stringArray;
        boolean bl2;
        boolean bl3 = notification.verb.equals("status");
        if (bl3) {
            if (notification.hasProperty("SubscriberID") && notification.get("SubscriberID").equals("99")) {
                this.master.logger.finest("Answer to ping from " + this.address.toString());
                return;
            }
        } else if (notification.verb.equals("echoresponse")) {
            this.master.logger.finest("Answer to ping from " + this.address.toString());
            return;
        }
        this.master.logger.finer("Notification message on node " + this.address.toString() + " of type " + notification.verb);
        this.master.logger.finest("Message : " + notification.toString());
        if (bl3) {
            this.master.logger.fine(String.format("Status message : %s", notification.get("Message")));
        }
        boolean bl4 = bl2 = bl3 && notification.getResult() == 1;
        if (bl3 && this.state.get() == 1) {
            stringArray = this;
            // MONITORENTER : this
            if (bl2) {
                this.conf.setInstanceId(notification.get("instanceId"));
                try {
                    this.protocolVersion = Integer.parseInt(notification.get("Version"));
                    if (this.protocolVersion < 3) {
                        this.master.logger.warning("Server " + this.toString() + " version " + String.valueOf(this.protocolVersion) + " is not supported");
                        super.close(true);
                        // MONITOREXIT : stringArray
                        return;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.protocolVersion = 0;
                }
                if (this.state.compareAndSet(1, 2)) {
                    super.onNodeUp();
                }
            } else {
                this.state.compareAndSet(1, 3);
            }
            // MONITOREXIT : stringArray
        }
        if (this.state.get() != 2) {
            this.close(true);
            return;
        }
        if (!notification.hasProperty("SubscriberID")) return;
        stringArray = notification.getSubscribers();
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string = stringArray[n3];
            ServerSubscriptionProxy serverSubscriptionProxy = this.subscriberIndex.get(string);
            if (serverSubscriptionProxy == null) {
                this.master.logger.log(Level.WARNING, String.format("Unknown subscriber ID : %s", string));
            } else {
                if (bl3 && notification.getResult() == 1) {
                    serverSubscriptionProxy.setStatus(notification);
                }
                try {
                    serverSubscriptionProxy.populate(notification);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            ++n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDataAvailable(byte[] byArray, int n2, int n3) {
        try {
            this.messageReader.feedBuffer(byArray, n2, n3);
        }
        catch (Exception exception) {
            throw new ServerError(exception.getLocalizedMessage());
        }
        this.lastMessageTime = System.currentTimeMillis();
        if (this.waitersAreWaiting.get()) {
            List<BlockingQueue<Node>> list = this.waiters;
            synchronized (list) {
                while (!this.waiters.isEmpty()) {
                    this.waiters.remove(this.waiters.size() - 1).add(this);
                }
                this.waitersAreWaiting.set(false);
            }
        }
        while (this.messageReader.available() && this.state.get() != 3) {
            this.processMessage(this.messageReader.remove());
        }
    }

    private synchronized void onNodeUp() {
        this.master.onNodeUp(this);
        for (NotificationNetwork notificationNetwork : this.userSet) {
            notificationNetwork.onNodeUp(this);
        }
    }

    private synchronized void onNodeDown() {
        this.master.onNodeDown(this);
        for (NotificationNetwork notificationNetwork : this.userSet) {
            notificationNetwork.onNodeDown(this);
        }
    }

    void publish(Message message) throws ONSException {
        this.send(message);
    }

    public synchronized void addSubscriber(SubscriptionProxy subscriptionProxy) {
        String string = subscriptionProxy.getSubscriptionKey();
        ServerSubscriptionProxy serverSubscriptionProxy = this.subscriptionToProxy.get(string);
        if (serverSubscriptionProxy == null) {
            serverSubscriptionProxy = new ServerSubscriptionProxy(subscriptionProxy);
            this.master.logger.log(Level.FINEST, "new proxy: fakeId=" + serverSubscriptionProxy.fakeId);
            this.subscriptionToProxy.put(string, serverSubscriptionProxy);
            this.subscriberIndex.put(serverSubscriptionProxy.fakeId, serverSubscriptionProxy);
            serverSubscriptionProxy.register();
        } else {
            this.master.logger.log(Level.FINEST, "adding subscriber to proxy");
            serverSubscriptionProxy.addSubscriber(subscriptionProxy);
        }
    }

    public synchronized void removeSubscriber(SubscriptionProxy subscriptionProxy) {
        String string = subscriptionProxy.getSubscriptionKey();
        ServerSubscriptionProxy serverSubscriptionProxy = this.subscriptionToProxy.get(string);
        if (serverSubscriptionProxy != null) {
            serverSubscriptionProxy.proxies.remove(subscriptionProxy);
            if (serverSubscriptionProxy.proxies.isEmpty()) {
                if (serverSubscriptionProxy.registered) {
                    this.send(new Message("unsubscribe").put("SubscriberID", serverSubscriptionProxy.fakeId));
                }
                this.subscriptionToProxy.remove(string);
                this.subscriberIndex.remove(serverSubscriptionProxy.fakeId);
            }
        }
    }

    public String toString() {
        return "{address: " + this.address.toString() + "}";
    }

    @Override
    public void hasException(Throwable throwable) {
        this.master.logger.warning(throwable.getClass().getName() + " : " + throwable.getLocalizedMessage());
        this.close(true);
    }

    private class NodeConnectAction
    implements Runnable {
        private NodeConnectAction() {
        }

        @Override
        public void run() {
            try {
                if (Node.this.conf.hasSecureConnection()) {
                    ((Node)Node.this).master.logger.log(Level.FINE, "Creating SSL connection");
                    Node.this.socket = Node.this.master.getSocketManager().createSocket(((Node)Node.this).address.hostname, ((Node)Node.this).address.port, (int)Node.this.conf.getSocketTimeout(), Node.this, Node.this.conf.getSSLSocketFactory());
                } else {
                    Node.this.socket = Node.this.master.getSocketManager().createSocket(((Node)Node.this).address.hostname, ((Node)Node.this).address.port, (int)Node.this.conf.getSocketTimeout(), Node.this);
                }
                if (Node.this.state.get() != 1) {
                    Node.this.socket.close();
                    throw new ONSException(String.format("Race condition with node %s: already initialized", Node.this.address.toString()));
                }
                Message message = new Message("connect");
                message.put("Version", Integer.toString(Node.this.conf.getProtocolVersion())).put("FormFactor", Node.this.conf.getFormFactor()).put("SelfId", "java; Home=" + Node.this.conf.getOracleHome()).ready();
                Node.this.send(message);
            }
            catch (Exception exception) {
                ((Node)Node.this).master.logger.warning(Node.this.address.toString() + " : " + exception.getLocalizedMessage());
                Node.this.close(true);
            }
        }
    }

    private class ServerSubscriptionProxy {
        private final Collection<SubscriptionProxy> proxies = new ConcurrentLinkedQueue<SubscriptionProxy>();
        private final String fakeId;
        private final Message subscriptionMessage;
        private Notification statusNotification = null;
        private volatile boolean registered = false;

        public ServerSubscriptionProxy(SubscriptionProxy subscriptionProxy) {
            String string;
            while ((string = Integer.toString(globalId.getAndIncrement())).equals("99")) {
            }
            this.fakeId = string;
            ((Node)Node.this).master.logger.log(Level.FINEST, "creating proxy: fakeId=" + this.fakeId);
            this.proxies.add(subscriptionProxy);
            this.subscriptionMessage = new Message(subscriptionProxy.subscriptionMessage);
            this.subscriptionMessage.put("SubscriberID", this.fakeId).ready();
        }

        void populate(Notification notification) throws InterruptedException {
            for (SubscriptionProxy subscriptionProxy : this.proxies) {
                subscriptionProxy.populate(notification);
            }
        }

        private void notifySubscriber(SubscriptionProxy subscriptionProxy) {
            if (this.statusNotification != null) {
                subscriptionProxy.setRegistrationNotification(this.statusNotification);
                subscriptionProxy.setServerSubscriberInfo(Node.this, this.fakeId);
            }
        }

        void addSubscriber(SubscriptionProxy subscriptionProxy) {
            this.proxies.add(subscriptionProxy);
            this.notifySubscriber(subscriptionProxy);
        }

        void setStatus(Notification notification) {
            this.registered = true;
            this.statusNotification = notification;
            for (SubscriptionProxy subscriptionProxy : this.proxies) {
                this.notifySubscriber(subscriptionProxy);
            }
        }

        void register() {
            Node.this.send(this.subscriptionMessage);
        }
    }
}

