/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.ons.Message;
import oracle.ons.NotificationProperty;
import oracle.ons.ONS;
import oracle.ons.ONSConfiguration;
import oracle.ons.Publisher;

public class Notification {
    protected Map<String, String> properties = new HashMap<String, String>(4);
    protected byte[] body = new byte[0];
    protected String method;
    protected String verb;
    private String[] subscribers = null;
    protected long creationTime = -1L;
    protected long deliveryTime = -1L;
    private boolean systemEventFlag = false;
    private Throwable exception = null;
    protected int readHelperContentLength = 0;
    private NotificationKey key = null;
    protected final String[] internalProperties = new String[internalPropertyList.length];
    public static final int RESULT_SUCCESS = 1;
    private static final String[] EMPTY_ARRAY = new String[0];
    private static final Map<String, Integer> internalPropertyMap;
    protected static final int INTPROP_RESULT = 0;
    protected static final int INTPROP_MESSAGE = 1;
    protected static final int INTPROP_ORIGIN = 2;
    protected static final int INTPROP_STAMP = 3;
    protected static final int INTPROP_VERSION = 4;
    protected static final int INTPROP_TYPE = 5;
    protected static final int INTPROP_AFFECTED_COMPONENTS = 6;
    protected static final int INTPROP_AFFECTED_NODES = 7;
    protected static final int INTPROP_GENERATING_COMPONENT = 8;
    protected static final int INTPROP_GENERATING_PROCESS = 9;
    protected static final int INTPROP_GENERATING_NODE = 10;
    protected static final int INTPROP_EVENT_ID = 11;
    protected static final int INTPROP_CTIME = 12;
    protected static final int INTPROP_CLUSTER_ID = 13;
    protected static final int INTPROP_CLUSTER_NAME = 14;
    protected static final int INTPROP_INSTANCE_ID = 15;
    protected static final int INTPROP_INSTANCE_NAME = 16;
    protected static final int INTPROP_LOCAL_ONLY = 17;
    protected static final int INTPROP_NUMBER_OF_PROPERTIES = 18;
    protected static final int INTPROP_CONTENT_LENGTH = 19;
    protected static final int INTPROP_SUBSCRIBER = 20;
    protected static final String[] internalPropertyList;
    private static UUID onsSessionId;
    private static AtomicInteger messageIdGenerator;

    private String getInternalNonNull(int n2) {
        return this.internalProperties[n2] != null ? this.internalProperties[n2] : "";
    }

    public String getVersion() {
        return this.getInternalNonNull(4);
    }

    public String affectedComponents() {
        return this.internalProperties[6];
    }

    public String affectedNodes() {
        return this.internalProperties[7];
    }

    public String generatingComponent() {
        return this.internalProperties[8];
    }

    public String generatingNode() {
        String string = this.internalProperties[10];
        if (string == null) {
            string = this.generatingNodeFromEventId();
        }
        return string;
    }

    public String generatingProcess() {
        return this.internalProperties[9];
    }

    public String clusterId() {
        return this.internalProperties[13];
    }

    public String clusterName() {
        return this.internalProperties[14];
    }

    public String instanceId() {
        return this.internalProperties[15];
    }

    public String instanceName() {
        return this.internalProperties[16];
    }

    public boolean isSystemNotification() {
        return this.systemEventFlag;
    }

    public Throwable getException() {
        return this.exception;
    }

    @Deprecated
    public Notification(String string, String string2, String string3, byte[] byArray, ONS oNS) {
        this("event");
        this.internalProperties[5] = string;
        this.internalProperties[6] = string2;
        this.internalProperties[7] = string3;
        if (null != byArray) {
            this.body = byArray;
        }
    }

    public Notification(String string, String string2, String string3, byte[] byArray) {
        this("event");
        this.internalProperties[5] = string;
        this.internalProperties[6] = string2;
        this.internalProperties[7] = string3;
        if (null != byArray) {
            this.body = byArray;
        }
    }

    public Notification put(String string, String string2) {
        Integer n2 = internalPropertyMap.get(string.toLowerCase());
        if (n2 != null) {
            this.internalProperties[n2.intValue()] = string2;
            if (n2 == 19) {
                this.readHelperContentLength = Integer.parseInt(string2);
            }
        } else {
            this.properties.put(string, string2);
        }
        return this;
    }

    public void putInternalProperty(String string, String string2) {
        this.properties.put(string, string2);
    }

    public boolean hasProperty(String string) {
        Integer n2 = internalPropertyMap.get(string.toLowerCase());
        return n2 != null && this.internalProperties[n2] != null || this.properties.containsKey(string);
    }

    public String get(String string) {
        Integer n2 = internalPropertyMap.get(string.toLowerCase());
        return n2 != null ? this.internalProperties[n2] : this.properties.get(string);
    }

    public String getNonNull(String string, String string2) {
        Integer n2 = internalPropertyMap.get(string.toLowerCase());
        String string3 = n2 != null ? this.internalProperties[n2] : this.properties.get(string);
        return string3 != null ? string3 : string2;
    }

    @Deprecated
    public void setProperty(String string, String string2) {
        this.put(string, string2);
    }

    @Deprecated
    public String getProperty(String string) {
        return this.get(string);
    }

    private static String nvl(String string, String string2) {
        return string != null ? string : string2;
    }

    public NotificationKey getKey() {
        if (this.key == null) {
            if (this.internalProperties[3] == null || this.internalProperties[3].equals("00000000.00000000")) {
                return null;
            }
            this.key = new NotificationKey();
        }
        return this.key;
    }

    Notification(Throwable throwable, String string, Notification notification) {
        this.creationTime = System.currentTimeMillis();
        this.systemEventFlag = true;
        this.exception = throwable;
        this.verb = string;
        if (notification != null) {
            System.arraycopy(notification.internalProperties, 0, this.internalProperties, 0, internalPropertyList.length);
            this.properties.putAll(notification.properties);
        }
    }

    public Notification() {
        this.creationTime = System.currentTimeMillis();
    }

    public Notification(String string) {
        this.creationTime = System.currentTimeMillis();
        this.verb = string;
    }

    public String toNiceString() {
        StringBuilder stringBuilder = new StringBuilder("[[ ").append(this.verb).append("\n");
        for (int i2 = 0; i2 < internalPropertyList.length; ++i2) {
            if (this.internalProperties[i2] == null) continue;
            stringBuilder.append("  ").append(internalPropertyList[i2]).append(':').append(this.internalProperties[i2]).append("\n");
        }
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            stringBuilder.append("  ").append(entry.getKey()).append(':').append(entry.getValue()).append("\n");
        }
        return stringBuilder.append("]]\n").toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("(");
        stringBuilder.append(this.verb).append(" ");
        for (int i2 = 0; i2 < internalPropertyList.length; ++i2) {
            if (this.internalProperties[i2] == null) continue;
            stringBuilder.append(internalPropertyList[i2]).append(':').append(this.internalProperties[i2]).append(";");
        }
        stringBuilder.append(this.properties.toString());
        return stringBuilder.append(")").toString();
    }

    public String[] getSubscribers() {
        if (this.subscribers == null) {
            this.subscribers = this.internalProperties[20] == null ? EMPTY_ARRAY : this.internalProperties[20].split(";\\s*");
        }
        return this.subscribers;
    }

    public String getEventType() {
        return this.internalProperties[5];
    }

    public int getResult() {
        return this.internalProperties[0] != null && this.internalProperties[0].equals("success") ? 1 : 0;
    }

    public String getMessage(String string) {
        return this.internalProperties[1] != null ? this.internalProperties[1] : string;
    }

    public byte[] getBody() {
        return this.body;
    }

    @Deprecated
    public void print() {
        System.out.println(this.toString());
    }

    public String type() {
        return this.getEventType();
    }

    public byte[] body() {
        return this.getBody();
    }

    private String generatingNodeFromEventId() {
        int n2;
        int n3;
        String string = null;
        String string2 = this.internalProperties[11];
        if (string2 != null && (n3 = string2.indexOf(64)) != -1 && (n2 = string2.indexOf(58, ++n3)) != -1) {
            string = string2.substring(n3, n2);
        }
        return string;
    }

    protected synchronized Message toMessageVersion4(Publisher publisher) throws IOException {
        Message message = new Message(this.verb);
        String string = null;
        this.internalProperties[18] = Integer.toString(this.properties.size());
        this.internalProperties[12] = Long.toString(this.creationTime);
        this.internalProperties[11] = Integer.toString(messageIdGenerator.getAndIncrement()) + '@' + ONSConfiguration.getHostname() + ':' + onsSessionId.toString();
        if (this.internalProperties[17] == null) {
            this.internalProperties[17] = "false";
        }
        if (publisher.componentName != null) {
            string = this.internalProperties[8];
            this.internalProperties[8] = publisher.componentName;
        }
        message.put(internalPropertyList[4], "4");
        for (int i2 = 5; i2 <= 18; ++i2) {
            message.put(internalPropertyList[i2], this.getInternalNonNull(i2));
        }
        if (publisher.componentName != null) {
            this.internalProperties[8] = string;
        }
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            message.put(entry.getKey(), entry.getValue());
        }
        message.getBodyOutputStream().write(this.body);
        return message.ready();
    }

    protected synchronized Message toMessage(Publisher publisher) throws IOException {
        Message message = new Message(this.verb);
        String string = null;
        message.put(internalPropertyList[4], "5");
        this.internalProperties[11] = Integer.toString(messageIdGenerator.getAndIncrement()) + '@' + ONSConfiguration.getHostname() + ':' + onsSessionId.toString();
        if (publisher.componentName != null) {
            string = this.internalProperties[8];
            this.internalProperties[8] = publisher.componentName;
        }
        for (int i2 = 0; i2 < internalPropertyList.length; ++i2) {
            if (i2 == 19 || this.internalProperties[i2] == null || this.internalProperties[i2].isEmpty()) continue;
            message.put(internalPropertyList[i2], this.internalProperties[i2]);
        }
        if (publisher.componentName != null) {
            this.internalProperties[8] = string;
        }
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            message.put(entry.getKey(), entry.getValue());
        }
        message.getBodyOutputStream().write(this.body);
        return message;
    }

    public long creationTime() {
        return this.creationTime;
    }

    public long deliveryTime() {
        return this.deliveryTime;
    }

    public String id() {
        return this.internalProperties[11];
    }

    @Deprecated
    public NotificationProperty[] getAllProperties() {
        int n2 = 0;
        int n3 = 0;
        for (String string : this.internalProperties) {
            if (string == null) continue;
            ++n2;
        }
        Object[] objectArray = new NotificationProperty[n2 + this.properties.size()];
        for (int i2 = 0; i2 < internalPropertyList.length; ++i2) {
            if (this.internalProperties[n3] == null) continue;
            objectArray[n3++] = new NotificationProperty(internalPropertyList[i2], this.internalProperties[n3]);
        }
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            objectArray[n3++] = new NotificationProperty(entry.getKey(), entry.getValue());
        }
        return objectArray;
    }

    public void setLocalOnly() {
        this.internalProperties[17] = "true";
    }

    public boolean getLocalOnly() {
        String string = this.internalProperties[17];
        return string != null && string.toLowerCase().equals("true");
    }

    public String getVerb() {
        return this.verb;
    }

    public String dump() {
        try {
            return new String(this.toMessage(null).dump());
        }
        catch (IOException iOException) {
            return "Error!";
        }
    }

    @Deprecated
    public void print(ONS oNS) {
        this.print();
    }

    static {
        internalPropertyList = new String[]{"Result", "Message", "origin", "stamp", "Version", "eventType", "affectedComponents", "affectedNodes", "generatingComponent", "generatingProcess", "generatingNode", "eventId", "creationTime", "clusterId", "clusterName", "instanceId", "instanceName", "LocalOnly", "numberOfProperties", "Content-Length", "SubscriberID"};
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (int i2 = 0; i2 < internalPropertyList.length; ++i2) {
            hashMap.put(internalPropertyList[i2].toLowerCase(), i2);
        }
        internalPropertyMap = Collections.unmodifiableMap(hashMap);
        onsSessionId = UUID.randomUUID();
        messageIdGenerator = new AtomicInteger(0);
    }

    class NotificationKey {
        String stamp;

        public NotificationKey() {
            this.stamp = Notification.nvl(Notification.this.internalProperties[3], "~") + "@" + Notification.nvl(Notification.this.internalProperties[2], "[]");
        }

        public boolean expired(long l2) {
            return Notification.this.creationTime < l2;
        }

        public void touch() {
            Notification.this.creationTime = System.currentTimeMillis();
        }

        public boolean equals(Object object) {
            return object != null && this.getClass() == object.getClass() && this.stamp.equals(((NotificationKey)object).stamp);
        }

        public int hashCode() {
            return this.stamp.hashCode();
        }
    }
}

