/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import oracle.ons.ConfigurationException;
import oracle.ons.DefaultSocketManager;
import oracle.ons.Node;
import oracle.ons.NodeAddress;
import oracle.ons.NotificationNetwork;
import oracle.ons.ONS;
import oracle.ons.ONSConfiguration;
import oracle.ons.ONSException;
import oracle.ons.ThreadPoolWorkloadManager;
import oracle.ons.spi.SocketManager;
import oracle.ons.spi.WorkloadManager;

public class NotificationManager {
    private WorkloadManager wm;
    private SocketManager sm;
    private final AtomicInteger activeNetworks = new AtomicInteger(0);
    Logger logger = Logger.getLogger(ONS.class.getCanonicalName());
    private final ConcurrentHashMap<Object, WeakReference<NotificationNetwork>> networks = new ConcurrentHashMap();
    private final ConcurrentHashMap<NodeAddress, Node> nodes = new ConcurrentHashMap();
    private final ConcurrentHashMap<NodeAddress, Long> nodeDownHistory = new ConcurrentHashMap();
    private static volatile NotificationManager instance = null;
    private volatile MaintenanceTask maintenanceTask = null;

    private NotificationManager(WorkloadManager workloadManager, SocketManager socketManager) {
        String string = System.getProperty("oracle.ons.debug", "none");
        this.logger.setUseParentHandlers(false);
        if (string.equalsIgnoreCase("true")) {
            this.logger.setLevel(Level.ALL);
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setLevel(Level.ALL);
            consoleHandler.setFormatter(new SimpleFormatter());
            this.logger.addHandler(consoleHandler);
        }
        this.wm = workloadManager;
        this.sm = socketManager;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(WorkloadManager workloadManager, SocketManager socketManager) throws ONSException {
        Class<NotificationManager> clazz = NotificationManager.class;
        synchronized (NotificationManager.class) {
            if (instance != null) {
                throw new ConfigurationException("Only one implicit ONS Manager is allowed per JVM");
            }
            instance = new NotificationManager(workloadManager != null ? workloadManager : new ThreadPoolWorkloadManager(), socketManager != null ? socketManager : new DefaultSocketManager());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static void initialize() throws ONSException {
        NotificationManager.initialize(null, null);
    }

    public static NotificationManager getNotificationManager() {
        if (instance == null) {
            try {
                NotificationManager.initialize();
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        }
        return instance;
    }

    protected WorkloadManager getWorkloadManager() {
        return this.wm;
    }

    protected SocketManager getSocketManager() {
        return this.sm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NotificationNetwork getNetwork(ONSConfiguration oNSConfiguration) throws ONSException {
        ConcurrentHashMap<Object, WeakReference<NotificationNetwork>> concurrentHashMap = this.networks;
        synchronized (concurrentHashMap) {
            NotificationNetwork notificationNetwork;
            WeakReference<NotificationNetwork> weakReference = this.networks.get(oNSConfiguration.getFingerprint());
            NotificationNetwork notificationNetwork2 = notificationNetwork = weakReference == null ? null : (NotificationNetwork)weakReference.get();
            if (notificationNetwork == null) {
                this.logger.log(Level.FINE, "Creating notification network (implicit) : " + oNSConfiguration.toString());
                notificationNetwork = new NotificationNetwork(oNSConfiguration);
                this.networks.put(oNSConfiguration.getFingerprint(), new WeakReference<NotificationNetwork>(notificationNetwork));
            }
            return notificationNetwork;
        }
    }

    protected void onNodeUp(Node node) {
        this.logger.fine("ONS node up : " + node.toString());
        this.nodeDownHistory.remove(node.getAddress());
    }

    protected void onNodeDown(Node node) {
        this.logger.fine("ONS node down : " + node.toString());
        this.nodes.remove(node.getAddress());
        this.nodeDownHistory.put(node.getAddress(), System.currentTimeMillis());
    }

    void connect(Collection<NodeAddress> collection, Collection<NodeAddress> collection2, int n2, NotificationNetwork notificationNetwork) {
        int n3 = 0;
        ArrayList<NodeAddress> arrayList = new ArrayList<NodeAddress>();
        n2 = Math.min(n2, collection.size());
        arrayList.addAll(collection);
        arrayList.addAll(collection2);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Node object = this.nodes.get(iterator.next());
            if (object == null) continue;
            this.logger.finest("Node found : " + object.getAddress().toString());
            if (!object.register(notificationNetwork)) continue;
            ++n3;
            iterator.remove();
        }
        Collections.sort(arrayList, new Comparator<NodeAddress>(){

            @Override
            public int compare(NodeAddress nodeAddress, NodeAddress nodeAddress2) {
                Long l2 = (Long)NotificationManager.this.nodeDownHistory.get(nodeAddress);
                Long l3 = (Long)NotificationManager.this.nodeDownHistory.get(nodeAddress2);
                if (l2 != null && l3 != null) {
                    return l3.compareTo(l2);
                }
                if (l2 != null) {
                    return 1;
                }
                if (l3 != null) {
                    return -1;
                }
                return 0;
            }
        });
        for (NodeAddress nodeAddress : arrayList) {
            if (n3 >= n2) break;
            Node node = new Node(this, nodeAddress, notificationNetwork.config);
            Node node2 = this.nodes.putIfAbsent(nodeAddress, node);
            if (node2 == null) {
                node2 = node;
                this.logger.finest("Trying node : " + node2.getAddress().toString());
            }
            if (!node2.register(notificationNetwork)) continue;
            ++n3;
        }
    }

    protected void onNetworkUp(NotificationNetwork notificationNetwork) {
        if (this.maintenanceTask == null) {
            this.maintenanceTask = new MaintenanceTask();
            this.wm.scheduleDelayed(this.maintenanceTask, Node.PING_TIMEOUT / 2L);
        }
        this.activeNetworks.incrementAndGet();
    }

    protected void onNetworkDown(NotificationNetwork notificationNetwork) {
        this.networks.remove(notificationNetwork.config.getFingerprint());
        this.activeNetworks.decrementAndGet();
    }

    private class MaintenanceTask
    implements Runnable {
        private MaintenanceTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList arrayList = new ArrayList();
            ArrayList<NotificationNetwork> arrayList2 = new ArrayList<NotificationNetwork>();
            long l2 = System.currentTimeMillis();
            int n2 = 0;
            Iterator iterator = NotificationManager.this.networks;
            synchronized (iterator) {
                for (WeakReference weakReference : NotificationManager.this.networks.values()) {
                    NotificationNetwork notificationNetwork = (NotificationNetwork)weakReference.get();
                    if (notificationNetwork == null) continue;
                    arrayList2.add(notificationNetwork);
                }
            }
            for (NotificationNetwork notificationNetwork : arrayList2) {
                notificationNetwork.releaseIfUnused();
            }
            arrayList.addAll(NotificationManager.this.nodes.values());
            for (Node node : arrayList) {
                if (node.isConnected()) {
                    node.checkConnection(l2);
                }
                if (node.isGarbage()) continue;
                ++n2;
            }
            if (n2 == 0) {
                NotificationManager.this.maintenanceTask = null;
            } else if (NotificationManager.this.maintenanceTask == this) {
                NotificationManager.this.wm.scheduleDelayed(NotificationManager.this.maintenanceTask, Node.PING_TIMEOUT / 2L);
            }
        }
    }
}

