/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ons.CreatePermission;
import oracle.ons.Message;
import oracle.ons.NoServersAvailable;
import oracle.ons.Node;
import oracle.ons.NodeAddress;
import oracle.ons.Notification;
import oracle.ons.NotificationException;
import oracle.ons.NotificationManager;
import oracle.ons.ONSConfiguration;
import oracle.ons.ONSException;
import oracle.ons.PublishPermission;
import oracle.ons.Publisher;
import oracle.ons.Subscriber;
import oracle.ons.SubscriptionProxy;

public class NotificationNetwork {
    protected ONSConfiguration config;
    protected NotificationManager master;
    protected volatile int messageReceived = 0;
    protected volatile int messagePublished = 0;
    protected volatile int messageDropped = 0;
    private static final int STATE_NETWORK_DOWN = 0;
    private static final int STATE_STARTING_UP = 1;
    private static final int STATE_NETWORK_UP = 2;
    private static final long FAILOVER_COOLDOWN = 3000L;
    private AtomicInteger state = new AtomicInteger(0);
    private final AtomicInteger usageCount = new AtomicInteger(0);
    protected Logger logger;
    private final Semaphore networkStatusLock = new Semaphore(0, false);
    private final List<ONSConfiguration.NodeList> nodeLists = new ArrayList<ONSConfiguration.NodeList>();
    private final Set<Node> nodes = new HashSet<Node>();
    private RefreshConnectionsTask localRefreshTask = new RefreshConnectionsTask();
    private final Map<String, SubscriptionProxy> networkSubscriptions = new HashMap<String, SubscriptionProxy>();

    Iterable<? extends Node> getNodes() {
        return this.nodes;
    }

    NotificationNetwork(ONSConfiguration oNSConfiguration) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new CreatePermission("ONSUser"));
        }
        this.master = NotificationManager.getNotificationManager();
        this.config = oNSConfiguration;
        this.logger = this.master.logger;
        this.nodeLists.addAll(oNSConfiguration.getTopologies());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilOnline(long l2, boolean bl2) throws ONSException, InterruptedException {
        if (this.networkStatusLock.availablePermits() > 0) {
            NotificationNetwork notificationNetwork = this;
            synchronized (notificationNetwork) {
                return !this.nodes.isEmpty();
            }
        }
        if (this.networkStatusLock.tryAcquire(l2, TimeUnit.MILLISECONDS)) {
            this.networkStatusLock.release();
        } else {
            this.state.compareAndSet(1, 0);
            if (bl2) {
                throw new NoServersAvailable("Subscription time out");
            }
        }
        NotificationNetwork notificationNetwork = this;
        synchronized (notificationNetwork) {
            return !this.nodes.isEmpty();
        }
    }

    public boolean waitUntilOnline() throws ONSException, InterruptedException {
        return this.waitUntilOnline(this.config.getSocketTimeout(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ping() {
        NotificationNetwork notificationNetwork = this;
        synchronized (notificationNetwork) {
            for (Node node : this.nodes) {
                node.ping(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ping(long l2) throws InterruptedException {
        LinkedBlockingQueue<Node> linkedBlockingQueue = new LinkedBlockingQueue<Node>();
        this.lazyDemand();
        if (!this.waitUntilOnline(l2, false)) {
            return false;
        }
        HashSet<Node> hashSet = new HashSet<Node>();
        Object object = this;
        synchronized (object) {
            for (Node node : this.nodes) {
                if (!hashSet.add(node)) continue;
                node.ping(linkedBlockingQueue);
            }
        }
        while (!hashSet.isEmpty()) {
            object = (Node)linkedBlockingQueue.poll(l2, TimeUnit.MILLISECONDS);
            if (object == null) {
                return false;
            }
            hashSet.remove(object);
        }
        return true;
    }

    protected void checkPublisherPerimission() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PublishPermission("ONSUser"));
        }
    }

    public synchronized boolean publish(Message message) {
        this.checkPublisherPerimission();
        if (this.nodes.isEmpty()) {
            throw new NotificationException("Network is down");
        }
        Iterator<Node> iterator = this.nodes.iterator();
        if (iterator.hasNext()) {
            Node node = iterator.next();
            node.publish(message);
            return true;
        }
        return false;
    }

    public synchronized boolean publishNotification(Notification notification, Publisher publisher) {
        this.checkPublisherPerimission();
        if (this.nodes.isEmpty()) {
            throw new NotificationException("Network is down");
        }
        Message message = null;
        Message message2 = null;
        Iterator<Node> iterator = this.nodes.iterator();
        if (iterator.hasNext()) {
            Node node = iterator.next();
            try {
                if (node.getProtocolVersion() >= 5) {
                    node.publish(message2 != null ? message2 : (message2 = notification.toMessage(publisher)));
                } else {
                    node.publish(message != null ? message : (message = notification.toMessageVersion4(publisher)));
                }
                return true;
            }
            catch (IOException iOException) {
                throw new ONSException("Notification publish failed for client internal error");
            }
        }
        return false;
    }

    protected void scanExpandNodeList(Collection<NodeAddress> collection, Collection<NodeAddress> collection2) {
        if (this.config.ignoreScan) {
            collection2.addAll(collection);
        } else {
            for (NodeAddress nodeAddress : collection) {
                try {
                    for (InetAddress inetAddress : InetAddress.getAllByName(nodeAddress.hostname)) {
                        NodeAddress nodeAddress2 = new NodeAddress(inetAddress.getHostAddress(), nodeAddress.port);
                        this.logger.finest(String.format("%s resolves to %s", nodeAddress.toString(), nodeAddress2.toString()));
                        collection2.add(nodeAddress2);
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    NotificationManager.getNotificationManager().logger.warning(String.format("ONS failed to resolve host : %s", nodeAddress.toString()));
                }
            }
        }
    }

    synchronized void onNodeUp(Node node) {
        if (node.isConnected()) {
            for (SubscriptionProxy subscriptionProxy : this.networkSubscriptions.values()) {
                this.master.getWorkloadManager().schedule(new RegisterSubscriptionTask(node, subscriptionProxy));
            }
            this.nodes.add(node);
            this.state.set(2);
            this.networkStatusLock.release();
        }
    }

    synchronized void onNodeDown(Node node) {
        if (this.nodes.contains(node)) {
            this.nodes.remove(node);
            if (this.nodes.isEmpty()) {
                this.state.compareAndSet(2, 1);
            }
            if (!this.networkStatusLock.tryAcquire()) {
                this.logger.severe("Node consistency broken");
            }
        }
        if (this.state.get() != 0) {
            this.master.getWorkloadManager().schedule(this.localRefreshTask);
        }
    }

    private synchronized void shutdown() {
        this.logger.log(Level.FINE, "ONS network real shutdown");
        for (Node node : this.nodes) {
            node.unregister(this);
            this.networkStatusLock.tryAcquire();
        }
        this.nodes.clear();
        this.state.set(0);
    }

    void release() {
        if (this.usageCount.decrementAndGet() == 0) {
            this.shutdown();
            this.master.onNetworkDown(this);
        }
        this.logger.log(Level.FINE, "ONS network down request : " + this.usageCount.toString());
    }

    NotificationNetwork demand() {
        this.logger.log(Level.FINE, "ONS network up request : " + this.usageCount.toString());
        if (this.usageCount.getAndIncrement() == 0) {
            this.startup();
        }
        return this;
    }

    public NotificationNetwork lazyDemand() {
        this.startup();
        return this;
    }

    public void releaseIfUnused() {
        if (this.usageCount.get() == 0) {
            this.shutdown();
            this.master.onNetworkDown(this);
        }
    }

    private void startup() {
        if (this.state.compareAndSet(0, 1)) {
            this.master.onNetworkUp(this);
            this.master.getWorkloadManager().schedule(this.localRefreshTask);
        }
    }

    synchronized void registerSubscriber(Subscriber subscriber) {
        String string = subscriber.getSubscriptionKey();
        SubscriptionProxy subscriptionProxy = this.networkSubscriptions.get(string);
        if (subscriptionProxy == null) {
            subscriptionProxy = new SubscriptionProxy(this, subscriber);
            this.networkSubscriptions.put(string, subscriptionProxy);
            for (Node node : this.getNodes()) {
                this.master.getWorkloadManager().schedule(new RegisterSubscriptionTask(node, subscriptionProxy));
            }
        } else {
            subscriptionProxy.add(subscriber);
        }
    }

    synchronized void unregisterSubscriber(Subscriber subscriber) {
        String string = subscriber.getSubscriptionKey();
        SubscriptionProxy subscriptionProxy = this.networkSubscriptions.get(string);
        subscriptionProxy.remove(subscriber);
        if (subscriptionProxy.isEmpty()) {
            this.networkSubscriptions.remove(string);
            for (Node node : this.getNodes()) {
                this.master.getWorkloadManager().schedule(new RemoveSubscriptionTask(node, subscriptionProxy));
            }
        }
    }

    private class RemoveSubscriptionTask
    implements Runnable {
        Node node;
        SubscriptionProxy proxy;

        private RemoveSubscriptionTask(Node node, SubscriptionProxy subscriptionProxy) {
            this.node = node;
            this.proxy = subscriptionProxy;
        }

        @Override
        public void run() {
            try {
                this.node.removeSubscriber(this.proxy);
            }
            catch (Exception exception) {
                NotificationNetwork.this.master.logger.finest(exception.getLocalizedMessage());
            }
        }
    }

    private class RegisterSubscriptionTask
    implements Runnable {
        Node node;
        SubscriptionProxy proxy;

        private RegisterSubscriptionTask(Node node, SubscriptionProxy subscriptionProxy) {
            this.node = node;
            this.proxy = subscriptionProxy;
        }

        @Override
        public void run() {
            try {
                this.node.addSubscriber(this.proxy);
            }
            catch (Exception exception) {
                NotificationNetwork.this.master.logger.warning(exception.getLocalizedMessage());
            }
        }
    }

    private class RefreshConnectionsTask
    implements Runnable {
        private volatile long lastRun = 0L;
        private volatile boolean scheduled = false;

        private RefreshConnectionsTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RefreshConnectionsTask refreshConnectionsTask = this;
            synchronized (refreshConnectionsTask) {
                long l2 = System.currentTimeMillis();
                long l3 = l2 - this.lastRun;
                if (3000L > l3) {
                    if (!this.scheduled) {
                        NotificationNetwork.this.master.getWorkloadManager().scheduleDelayed(this, 3000L - l3);
                        this.scheduled = true;
                    }
                    return;
                }
                this.scheduled = false;
                HashSet<NodeAddress> hashSet = new HashSet<NodeAddress>();
                for (ONSConfiguration.NodeList nodeList : NotificationNetwork.this.nodeLists) {
                    if (nodeList.active) continue;
                    NotificationNetwork.this.scanExpandNodeList(nodeList.nodeList, hashSet);
                }
                for (ONSConfiguration.NodeList nodeList : NotificationNetwork.this.nodeLists) {
                    if (!nodeList.active) continue;
                    HashSet<NodeAddress> hashSet2 = new HashSet<NodeAddress>();
                    NotificationNetwork.this.scanExpandNodeList(nodeList.nodeList, hashSet2);
                    NotificationNetwork.this.master.connect(hashSet2, hashSet, nodeList.maxConnections, NotificationNetwork.this);
                }
                this.lastRun = System.currentTimeMillis();
            }
        }
    }
}

