/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import oracle.ons.CallBackMode;
import oracle.ons.Closable;
import oracle.ons.ConfigurationException;
import oracle.ons.NotificationManager;
import oracle.ons.NotificationNetwork;
import oracle.ons.ONSConfiguration;
import oracle.ons.ONSException;
import oracle.ons.Publisher;
import oracle.ons.Subscriber;
import oracle.ons.rpc.RpcServer;
import oracle.ons.rpc.impl.RpcServerImpl;

public class ONS
implements Closable {
    public static final String ONS_PERM_STRING = "ONSUser";
    public static final int ONS_ORACLE_HOME = 1;
    public static final int ONS_CONFIG_FILE = 2;
    public static final int ONS_ORACLE_INSTANCE = 3;
    public static final int ONS_PROTOCOL_VERSION = 5;
    public final ONSConfiguration config;
    private boolean adoptObjects = true;
    private List<WeakReference<Closable>> children = new ArrayList<WeakReference<Closable>>(2);
    private StreamHandler errorStreamHandler = null;
    private StreamHandler outStreamHandler = null;
    private static volatile ONS someONS = null;
    public PrintStream errstream;
    private PrintStream outstream;
    @Deprecated
    public boolean debug;

    public void setAdoptObjects(boolean bl2) {
        this.adoptObjects = bl2;
    }

    protected synchronized void addChildObject(Closable closable) {
        if (this.adoptObjects) {
            this.children.add(new WeakReference<Closable>(closable));
        }
    }

    public ONSConfiguration getConfiguration() {
        return this.config;
    }

    public NotificationNetwork getNetwork() {
        return this.config.getNetwork();
    }

    public void connectionDownReceived() {
        this.config.getNetwork().ping();
    }

    private void init() throws ONSException {
        NotificationNetwork notificationNetwork = this.config.getNetwork();
        try {
            notificationNetwork.lazyDemand().waitUntilOnline(this.config.getSocketTimeout(), true);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public ONS(int n2, String string) throws ONSException {
        switch (n2) {
            case 2: {
                this.config = ONSConfiguration.getLocalConfigFromFile(null, new File(string), null);
                break;
            }
            case 3: {
                this.config = ONSConfiguration.getConfigFromOPMN(string);
                break;
            }
            case 1: {
                this.config = ONSConfiguration.getLocalConfigFromFile(string, null, null);
                break;
            }
            default: {
                throw new ConfigurationException("Unknown parameter for ONS initialization");
            }
        }
        this.init();
    }

    public ONS(ONSConfiguration oNSConfiguration) {
        this.config = oNSConfiguration;
        someONS = this;
    }

    public ONS() {
        this.config = ONSConfiguration.initDefaultConfig();
        someONS = this;
    }

    public ONS(String string) throws ONSException {
        this.config = ONSConfiguration.getRemoteConfigFromString(string);
        this.init();
        someONS = this;
    }

    public synchronized void shutdown() {
        if (someONS == this) {
            someONS = null;
        }
        for (WeakReference<Closable> weakReference : this.children) {
            Closable closable = (Closable)weakReference.get();
            if (closable == null) continue;
            closable.close();
        }
    }

    @Override
    public void close() {
        this.shutdown();
    }

    @Deprecated
    public static ONS getRunningONS() {
        return someONS;
    }

    @Deprecated
    public void shutdown(long l2) {
        this.shutdown();
    }

    public Subscriber createNewSubscriber(String string, String string2) {
        return new Subscriber(this, string, string2, this.config.getSocketTimeout());
    }

    public Subscriber createNewSubscriber(String string, String string2, long l2) {
        return new Subscriber(this, string, string2, l2);
    }

    public Publisher createNewPublisher(String string) {
        return new Publisher(this, string);
    }

    public int readLocalPort(String string) throws ONSException {
        return this.config.getLocalPort();
    }

    public int readRemotePort(String string) throws ONSException {
        return this.config.getRemotePort();
    }

    public int readRequestPort(String string) throws ONSException {
        return this.config.getRequestPort();
    }

    public static String readFormFactor(String string) throws ONSException {
        try {
            return ONSConfiguration.getFormFactor(string);
        }
        catch (IOException iOException) {
            throw new ConfigurationException("Error reading form factor file");
        }
    }

    public Object getNodeLists() {
        return null;
    }

    public Object getConnections() {
        return null;
    }

    public static void error(String string) {
        NotificationManager.getNotificationManager().logger.fine(string);
    }

    public static void debug(String string) {
        NotificationManager.getNotificationManager().logger.info(string);
    }

    public static void debugRaw(String string) {
        NotificationManager.getNotificationManager().logger.info(string);
    }

    public void printLists() {
    }

    public static Logger getLogger() {
        return NotificationManager.getNotificationManager().logger;
    }

    public RpcServer createRpcServer(String string, String string2, Map<String, String> map, CallBackMode callBackMode) {
        return new RpcServerImpl(this, string, string2, map, callBackMode);
    }

    @Deprecated
    public void setLogStream(PrintStream printStream, PrintStream printStream2) {
    }

    static ONS getONS() throws ConfigurationException {
        return new ONS(ONSConfiguration.initDefaultConfig());
    }
}

