/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import oracle.ons.ConfigurationException;
import oracle.ons.Node;
import oracle.ons.NodeAddress;
import oracle.ons.NotificationManager;
import oracle.ons.NotificationNetwork;
import oracle.ons.ONSException;
import oracle.security.pki.OracleWallet;
import org.w3c.dom.Document;

public class ONSConfiguration {
    static final long NODE_RETRY_DELAY = 60000L;
    static final long DEFAULT_TIMEOUT = 5000L;
    static final int DEFAULT_REMOTE_TIMEOUT = 30000;
    static final Charset ONS_CHARSET = Charset.forName("ASCII");
    static final String ONS_HP_SEPARATOR = ",";
    static final int BASIC_BUFFER_SIZE = 4096;
    static final int MAX_HEADER_SIZE = 4096;
    static final int DEFAULT_SERVER_VERSION = 5;
    private static final int ONS_SECURITY_NONE = 0;
    private static final int ONS_SECURITY_ORACLE_WALLET = 1;
    private static final int ONS_SECURITY_KEYFILE = 2;
    private static final int ONS_SECURITY_LOCAL = 3;
    private int protocolVersion = 5;
    private String oracleHome = "undefined";
    private String instanceId = null;
    private static String cachedHostname = null;
    private int remoteTimeout = 30000;
    private String fingerprint = null;
    private String component = "";
    private String formFactor = "";
    private String keyFile = null;
    private char[] keyFilePassword = null;
    private int securityScheme = 0;
    boolean ignoreScan = false;
    private int localPort = 0;
    private int remotePort = 0;
    private int requestPort = 0;
    private int defaultMaxConnections = 3;
    private static final String CONFIG_FILE_PATH = "opmn" + File.separator + "conf";
    private static final String CONFIG_FILE_NAME = "ons.config";
    private static final String FORMFACTOR_FILE_NAME = ".formfactor";
    private static final String SYS_ENV_ORACLE_HOME = "ORACLE_HOME";
    private static final String SYS_ENV_ORACLE_BASE_HOME = "ORACLE_BASE_HOME";
    private static final String SYS_ENV_ORACLE_CONFIG_HOME = "ORACLE_CONFIG_HOME";
    private static final Object defaultConfigLock = new Object();
    private static ONSConfiguration defaultConfig = null;
    private final Map<String, NodeList> nodes = new HashMap<String, NodeList>();
    private static final Map<String, String> configStringTranslator;
    private static final Pattern commentMatcher;
    private static final String SYSPROP_ORACLEHOME = "oracle.ons.oraclehome";
    private static final String SYSPROP_ORACLEBASEHOME = "oracle.ons.oraclebasehome";
    private static final String SYSPROP_ORACLECONFIGHOME = "oracle.ons.oracleconfighome";
    private static final String SYSPROP_ORACLEINSTANCE = "oracle.instance";
    private static final String SYSPROP_MAXCONNECTIONS = "oracle.ons.maxconnections";
    private static final String SYSPROP_ACTIVELIST = "oracle.ons.active";
    private static final String SYSPROP_SHUTDOWNTIMEOUT = "oracle.ons.shutdowntimeout";
    private static final String SYSPROP_IGNORESCANVIP = "oracle.ons.ignorescanvip";
    private static final String SYSPROP_NODES = "oracle.ons.nodes";
    private static final String SYSPROP_REMOTETIMEOUT = "oracle.ons.remotetimeout";
    private static final String SYSPROP_WALLETFILE = "oracle.ons.walletfile";
    private static final String SYSPROP_WALLETPASSWORD = "oracle.ons.walletpassword";
    private static final String SYSPROP_KEYSTOREFILE = "oracle.ons.keystore.location";
    private static final String SYSPROP_KEYSTOREPASSWORD = "oracle.ons.keystore.password";
    private static final String SYSPROP_DEBUG = "oracle.ons.debug";
    private static final String SYSPROP_PING = "oracle.ons.pingtimeout";
    protected static final String ONS_SSL_CONTEXT_PROTOCOL = "SSL";
    protected static final String ONS_SSL_KEY_MANAGEMENT = "SunX509";
    private SSLSocketFactory sslSocketFactoryCached = null;
    private String key = null;

    private void configure(Properties properties) {
        this.setProperties(System.getProperties());
        this.setProperties(properties);
        this.populateTopologies(properties);
        this.updateSSLSocketFactory();
    }

    public static ONSConfiguration getRemoteConfigFromString(String string) throws ONSException {
        Properties properties = new Properties();
        ONSConfiguration oNSConfiguration = new ONSConfiguration();
        try {
            properties.load(new StringReader(string));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        oNSConfiguration.configure(ONSConfiguration.translate(properties));
        return oNSConfiguration;
    }

    public ONSConfiguration(String string) throws ONSException {
        Properties properties = new Properties();
        try {
            properties.load(new StringReader(string));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.configure(ONSConfiguration.translate(properties));
    }

    private static String getFileContent(File file) throws IOException {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string);
        }
        bufferedReader.close();
        return stringBuilder.toString();
    }

    private static String getFormFactor(File file) {
        try {
            return ONSConfiguration.getFormFactor(file.getAbsolutePath());
        }
        catch (IOException iOException) {
            NotificationManager.getNotificationManager().logger.log(Level.WARNING, "Could not read the form factor", iOException);
            return "";
        }
    }

    static String getFormFactor(String string) throws IOException {
        String string2 = ONSConfiguration.getHostname();
        File file = new File(string, ".formfactor." + string2);
        if (!file.isFile()) {
            file = new File(string, FORMFACTOR_FILE_NAME);
        }
        if (!file.isFile()) {
            return "";
        }
        return ONSConfiguration.getFileContent(file).trim();
    }

    static File checkConfigDirectory(String string) {
        File file = new File(string + File.separator + CONFIG_FILE_NAME);
        if (!file.isFile()) {
            file = null;
        }
        return file;
    }

    public static String getUncachedHostname() {
        String string = System.getenv("HOSTNAME");
        if (string == null || string.isEmpty()) {
            string = System.getenv("COMPUTERNAME");
        }
        if (string == null || string.isEmpty()) {
            try {
                string = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                NotificationManager.getNotificationManager().logger.log(Level.WARNING, "Could not get the hostname", unknownHostException);
                string = "";
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHostname() {
        if (cachedHostname == null) {
            String string = ONSConfiguration.getUncachedHostname();
            Object object = defaultConfigLock;
            synchronized (object) {
                if (cachedHostname == null) {
                    cachedHostname = string;
                }
            }
        }
        return cachedHostname;
    }

    public static ONSConfiguration getLocalConfigFromFile(String string, File file, String string2) throws ONSException {
        Object object;
        Properties properties = new Properties();
        ONSConfiguration oNSConfiguration = new ONSConfiguration();
        File file2 = null;
        if (string == null && file == null) {
            throw new ConfigurationException("Oracle home or config file must be provided");
        }
        if (string == null) {
            file2 = file.getParentFile();
            string = file2.getParentFile().getParentFile().getAbsolutePath();
        }
        if (file2 == null) {
            file2 = new File(string + File.separator + CONFIG_FILE_PATH);
        }
        if (string2 == null) {
            string2 = ONSConfiguration.getFormFactor(file2);
        }
        if (file == null) {
            object = ONSConfiguration.getHostname();
            file = new File(file2, "ons.config." + (String)object);
            if (!file.isFile()) {
                file = new File(file2, CONFIG_FILE_NAME);
            }
        }
        oNSConfiguration.setOracleHome(string);
        oNSConfiguration.setFormFactor(string2);
        try {
            object = new BufferedReader(new FileReader(file));
            properties.load((Reader)object);
            ((Reader)object).close();
        }
        catch (IOException iOException) {
            throw new ConfigurationException(String.format("ONS configuration file not found or unavailable, file : %s", file.getAbsolutePath()));
        }
        oNSConfiguration.localPort = Integer.parseInt(ONSConfiguration.cleanupComment(properties.getProperty("localport", "0")));
        oNSConfiguration.remotePort = Integer.parseInt(ONSConfiguration.cleanupComment(properties.getProperty("remoteport", "0")));
        if (oNSConfiguration.localPort != 0) {
            oNSConfiguration.securityScheme = 3;
        }
        properties = ONSConfiguration.translate(properties);
        oNSConfiguration.setProperties(System.getProperties());
        oNSConfiguration.setProperties(properties);
        oNSConfiguration.updateSSLSocketFactory();
        object = new NodeList("local");
        ((NodeList)object).active = true;
        ((NodeList)object).nodeList.add(new NodeAddress("localhost", oNSConfiguration.localPort));
        ((NodeList)object).maxConnections = 1;
        oNSConfiguration.nodes.put(((NodeList)object).publicId, (NodeList)object);
        return oNSConfiguration;
    }

    private static String stringCoalesce(String string, String string2) {
        return string != null ? string : string2;
    }

    public static ONSConfiguration getConfigFromOPMN(String string) throws ONSException {
        Object object;
        File file = new File(string + File.separator + "config" + File.separator + "OPMN" + File.separator + "opmn");
        File file2 = new File(file, "opmn.xml");
        ONSConfiguration oNSConfiguration = new ONSConfiguration();
        String string2 = ONSConfiguration.getFormFactor(file);
        oNSConfiguration.setOracleHome(string);
        oNSConfiguration.setFormFactor(string2);
        try {
            oNSConfiguration.setProperties(System.getProperties());
            object = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object).setNamespaceAware(true);
            Document document = ((DocumentBuilderFactory)object).newDocumentBuilder().parse(file2);
            XPath xPath = XPathFactory.newInstance().newXPath();
            String string3 = "//*[local-name()='notification-server']/*[local-name() = 'port']/@local";
            oNSConfiguration.localPort = Integer.parseInt(ONSConfiguration.stringCoalesce(xPath.evaluate(string3, document), "0"));
            oNSConfiguration.securityScheme = 3;
        }
        catch (Exception exception) {
            throw new ConfigurationException("Unable to open or parse OPMN config file " + file2 + " : " + exception.getMessage());
        }
        object = new NodeList("local");
        ((NodeList)object).active = true;
        ((NodeList)object).nodeList.add(new NodeAddress("localhost", oNSConfiguration.localPort));
        ((NodeList)object).maxConnections = 1;
        oNSConfiguration.nodes.put(((NodeList)object).publicId, (NodeList)object);
        return oNSConfiguration;
    }

    public static ONSConfiguration getRemoteConfigFromHome(String string) throws ONSException {
        File file = ONSConfiguration.checkConfigDirectory(string);
        if (file == null) {
            throw new ConfigurationException("ONS configuration file not found");
        }
        ONSConfiguration oNSConfiguration = ONSConfiguration.getRemoteConfigFromFile(file.toString());
        oNSConfiguration.setOracleHome(string);
        return oNSConfiguration;
    }

    public static ONSConfiguration getRemoteConfigFromFile(String string) throws ONSException {
        Properties properties = new Properties();
        ONSConfiguration oNSConfiguration = new ONSConfiguration();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            properties.load(bufferedReader);
            ((Reader)bufferedReader).close();
        }
        catch (IOException iOException) {
            throw new ConfigurationException("Failed to read configuration file");
        }
        oNSConfiguration.configure(properties);
        return oNSConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ONSConfiguration getDefaultConfig() throws ONSException {
        if (defaultConfig == null) {
            Object object = defaultConfigLock;
            synchronized (object) {
                if (defaultConfig == null) {
                    return ONSConfiguration.initDefaultConfig();
                }
            }
        }
        return defaultConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultConfig(ONSConfiguration oNSConfiguration) {
        Object object = defaultConfigLock;
        synchronized (object) {
            defaultConfig = oNSConfiguration;
        }
    }

    static ONSConfiguration initDefaultConfig() throws ONSException {
        boolean bl2;
        Properties properties = System.getProperties();
        String string = null;
        string = properties.getProperty(SYSPROP_ORACLEINSTANCE);
        boolean bl3 = bl2 = string != null;
        if (string == null && (string = properties.getProperty(SYSPROP_ORACLECONFIGHOME)) == null && (string = properties.getProperty(SYSPROP_ORACLEBASEHOME)) == null && (string = properties.getProperty(SYSPROP_ORACLEHOME)) == null && (string = System.getenv(SYS_ENV_ORACLE_CONFIG_HOME)) == null && (string = System.getenv(SYS_ENV_ORACLE_BASE_HOME)) == null && (string = System.getenv(SYS_ENV_ORACLE_HOME)) == null) {
            throw new ConfigurationException(String.format("Default ONS client initialization: Oracle home is not set (looking in %s)", "oracle.instance, oracle.ons.oracleconfighome, oracle.ons.oraclebasehome, oracle.ons.oraclehome"));
        }
        return bl2 ? ONSConfiguration.getConfigFromOPMN(string) : ONSConfiguration.getLocalConfigFromFile(string, null, null);
    }

    ONSConfiguration() {
    }

    public NotificationNetwork getNetwork() {
        return NotificationManager.getNotificationManager().getNetwork(this);
    }

    public long getNotificationWindow() {
        return 5000L;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public int getRequestPort() {
        return this.requestPort;
    }

    public Collection<NodeList> getTopologies() {
        return this.nodes.values();
    }

    private static String cleanupComment(String string) {
        return commentMatcher.matcher(string).replaceFirst("");
    }

    private static Properties translate(Properties properties) {
        Properties properties2 = new Properties();
        for (String string : properties.stringPropertyNames()) {
            String string2 = ONSConfiguration.cleanupComment(properties.getProperty(string));
            properties2.put("oracle.ons." + (configStringTranslator.containsKey(string) ? configStringTranslator.get(string) : string), string2);
        }
        return properties2;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public String getFormFactor() {
        return this.formFactor;
    }

    public void setFormFactor(String string) {
        this.formFactor = string;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String string) {
        this.instanceId = string;
    }

    public String getOracleHome() {
        return this.oracleHome;
    }

    private void setOracleHome(String string) {
        this.oracleHome = string;
    }

    public Object getFingerprint() {
        if (this.fingerprint == null) {
            this.fingerprint = this.toString();
        }
        return this.fingerprint;
    }

    private void setProperties(Properties properties) {
        if (properties.containsKey(SYSPROP_PING)) {
            Node.PING_TIMEOUT = Integer.parseInt(ONSConfiguration.cleanupComment(properties.getProperty(SYSPROP_PING)));
        }
        if (properties.containsKey(SYSPROP_IGNORESCANVIP)) {
            this.ignoreScan = Boolean.parseBoolean(ONSConfiguration.cleanupComment(properties.getProperty(SYSPROP_IGNORESCANVIP)));
        }
        if (properties.containsKey(SYSPROP_REMOTETIMEOUT)) {
            this.remoteTimeout = Integer.parseInt(ONSConfiguration.cleanupComment(properties.getProperty(SYSPROP_REMOTETIMEOUT)));
        }
        if (properties.containsKey(SYSPROP_MAXCONNECTIONS)) {
            this.defaultMaxConnections = Integer.parseInt(ONSConfiguration.cleanupComment(properties.getProperty(SYSPROP_MAXCONNECTIONS)));
        }
        if (this.securityScheme != 3) {
            if (properties.containsKey(SYSPROP_WALLETFILE)) {
                this.securityScheme = 1;
                this.keyFile = ONSConfiguration.cleanupComment(properties.getProperty(SYSPROP_WALLETFILE));
                if (properties.containsKey(SYSPROP_WALLETPASSWORD)) {
                    this.keyFilePassword = ONSConfiguration.cleanupComment(properties.getProperty(SYSPROP_WALLETPASSWORD)).toCharArray();
                }
            } else if (properties.containsKey(SYSPROP_KEYSTOREFILE)) {
                this.securityScheme = 2;
                this.keyFile = ONSConfiguration.cleanupComment(properties.getProperty(SYSPROP_KEYSTOREFILE));
                if (properties.containsKey(SYSPROP_KEYSTOREPASSWORD)) {
                    this.keyFilePassword = ONSConfiguration.cleanupComment(properties.getProperty(SYSPROP_KEYSTOREPASSWORD)).toCharArray();
                }
            }
        }
    }

    private void populateTopologies(Properties properties) {
        Object object;
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string : properties.stringPropertyNames()) {
            if (!string.startsWith(SYSPROP_NODES) || treeSet.add((String)(object = string.substring(SYSPROP_NODES.length())))) continue;
            throw new ConfigurationException(String.format("Duplicate node list id in configuration : %s", object));
        }
        if (treeSet.isEmpty() && properties.containsKey(SYSPROP_NODES)) {
            treeSet.add("");
        }
        for (String string : treeSet) {
            object = new NodeList(string.isEmpty() ? "" : string.substring(1));
            if (properties.containsKey(SYSPROP_ACTIVELIST + string)) {
                ((NodeList)object).active = Boolean.parseBoolean(ONSConfiguration.cleanupComment(properties.getProperty(SYSPROP_ACTIVELIST + string)));
            }
            ((NodeList)object).maxConnections = properties.containsKey(SYSPROP_MAXCONNECTIONS + string) ? Integer.parseInt(ONSConfiguration.cleanupComment(properties.getProperty(SYSPROP_MAXCONNECTIONS + string))) : this.defaultMaxConnections;
            String string2 = ONSConfiguration.cleanupComment(properties.getProperty(SYSPROP_NODES + string));
            for (String string3 : string2.split(ONS_HP_SEPARATOR)) {
                try {
                    NodeAddress nodeAddress = new NodeAddress(string3.trim());
                    ((NodeList)object).nodeList.add(nodeAddress);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ConfigurationException(String.format("Bad node syntax : %s", string3));
                }
            }
            this.nodes.put(((NodeList)object).publicId, (NodeList)object);
        }
    }

    public long getSocketTimeout() {
        return this.remoteTimeout;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String string) {
        this.component = string;
    }

    public boolean hasSecureConnection() {
        return this.securityScheme != 0 && this.securityScheme != 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateSSLSocketFactory() {
        block24: {
            if (!this.hasSecureConnection()) {
                return;
            }
            try {
                KeyStore keyStore;
                Object object;
                KeyManagerFactory keyManagerFactory = null;
                TrustManagerFactory trustManagerFactory = null;
                boolean bl2 = this.securityScheme != 1;
                while (true) {
                    try {
                        String string;
                        String string2;
                        if (bl2) {
                            string2 = KeyManagerFactory.getDefaultAlgorithm();
                            string = TrustManagerFactory.getDefaultAlgorithm();
                        } else {
                            string2 = ONS_SSL_KEY_MANAGEMENT;
                            string = ONS_SSL_KEY_MANAGEMENT;
                        }
                        keyManagerFactory = KeyManagerFactory.getInstance(string2);
                        trustManagerFactory = TrustManagerFactory.getInstance(string);
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        if (bl2) {
                            throw noSuchAlgorithmException;
                        }
                        keyManagerFactory = null;
                        bl2 = true;
                        if (keyManagerFactory == null) continue;
                    }
                    break;
                }
                if (this.securityScheme == 1) {
                    object = new OracleWallet();
                    ((OracleWallet)object).open(this.keyFile, this.keyFilePassword);
                    keyStore = ((OracleWallet)object).getKeyStore();
                } else {
                    if (this.keyFilePassword == null) {
                        throw new ConfigurationException("No password provided");
                    }
                    keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    object = new FileInputStream(this.keyFile);
                    try {
                        keyStore.load((InputStream)object, this.keyFilePassword);
                    }
                    finally {
                        ((FileInputStream)object).close();
                    }
                }
                keyManagerFactory.init(keyStore, this.keyFilePassword);
                trustManagerFactory.init(keyStore);
                object = SSLContext.getInstance(ONS_SSL_CONTEXT_PROTOCOL);
                ((SSLContext)object).init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
                this.sslSocketFactoryCached = ((SSLContext)object).getSocketFactory();
                if (this.sslSocketFactoryCached != null) {
                    NotificationManager.getNotificationManager().logger.fine("SSL factory created");
                } else {
                    NotificationManager.getNotificationManager().logger.warning("Failed to create SSL factory");
                }
                if (this.keyFilePassword == null) break block24;
            }
            catch (GeneralSecurityException generalSecurityException) {
                try {
                    throw new ConfigurationException(generalSecurityException.getLocalizedMessage());
                    catch (IOException iOException) {
                        throw new ConfigurationException(iOException.getLocalizedMessage());
                    }
                }
                catch (Throwable throwable) {
                    if (this.keyFilePassword != null) {
                        for (int i2 = 0; i2 < this.keyFilePassword.length; ++i2) {
                            this.keyFilePassword[i2] = '\u0000';
                        }
                    }
                    throw throwable;
                }
            }
            for (int i3 = 0; i3 < this.keyFilePassword.length; ++i3) {
                this.keyFilePassword[i3] = '\u0000';
            }
        }
    }

    public SSLSocketFactory getSSLSocketFactory() {
        if (this.securityScheme == 0 || this.securityScheme == 3) {
            return null;
        }
        if (this.sslSocketFactoryCached == null) {
            try {
                this.updateSSLSocketFactory();
            }
            catch (ONSException oNSException) {
                NotificationManager.getNotificationManager().logger.warning(oNSException.getLocalizedMessage());
            }
        }
        return this.sslSocketFactoryCached;
    }

    public String toString() {
        if (this.key == null) {
            StringBuilder stringBuilder = new StringBuilder("{");
            stringBuilder.append("ss:").append(this.securityScheme).append(";");
            stringBuilder.append("ff:").append(this.formFactor).append(";conf:[");
            for (NodeList nodeList : this.nodes.values()) {
                stringBuilder.append(nodeList.toString()).append(ONS_HP_SEPARATOR);
            }
            this.key = stringBuilder.append("]}").toString();
        }
        return this.key;
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("keystorelocation", "keystore.location");
        hashMap.put("keystorepassword", "keystore.password");
        configStringTranslator = Collections.unmodifiableMap(hashMap);
        commentMatcher = Pattern.compile("\\s+#.*");
    }

    static class NodeList {
        public String publicId;
        public final Set<NodeAddress> nodeList = new HashSet<NodeAddress>();
        public boolean active = true;
        public int maxConnections = 3;

        public NodeList(String string) {
            this.publicId = string;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(String.format("{max:%d;a:%b;n:[", this.maxConnections, this.active));
            for (NodeAddress nodeAddress : this.nodeList) {
                stringBuilder.append("\"").append(nodeAddress.toString()).append("\";");
            }
            stringBuilder.append("]}");
            return stringBuilder.toString();
        }
    }
}

