/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import oracle.ons.BodyBlock;
import oracle.ons.ComponentCallBack;
import oracle.ons.HeaderBlock;
import oracle.ons.Notification;
import oracle.ons.ONS;
import oracle.ons.Publisher;

public class OpmnNotifier
implements Runnable {
    private final String ONS_READY_EVENT = "IAS/PM/PROC_READY";
    private final String ONS_FIRST_EVENT = "OPMFirst";
    private final String OPMN_ID = "OPMN_UID";
    private final String UMP_UID = "-1";
    private String onsComponentName;
    private String opmnId;
    private int pingInterval = 10000;
    private boolean localOnly = false;
    private ComponentCallBack compCb = null;
    private Object notifCbData = null;
    private boolean threadShutdown = false;
    private Thread notifThread = null;
    private boolean firstTime = false;
    private ONS ons = ONS.getONS();

    public OpmnNotifier(String string, String string2) {
        this(string, string2, 10, false, null, null);
    }

    public OpmnNotifier(String string, String string2, int n2, boolean bl2, ComponentCallBack componentCallBack, Object object) {
        this.onsComponentName = string;
        this.opmnId = string2;
        this.compCb = componentCallBack;
        this.notifCbData = object;
        this.localOnly = bl2;
        if (n2 > 0) {
            this.pingInterval = n2 * 1000;
        }
    }

    public String getComponentName() {
        return this.onsComponentName;
    }

    public void startup() throws IllegalThreadStateException {
        if (this.notifThread != null) {
            return;
        }
        this.notifThread = new Thread((Runnable)this, "OpmnNotifier");
        this.notifThread.setDaemon(true);
        this.notifThread.start();
    }

    @Override
    public void run() {
        this.firstTime = true;
        if (this.onsComponentName == null || this.opmnId == null) {
            ONS.error("ComponentName or OPMNID is NULL");
            return;
        }
        Publisher publisher = new Publisher(this.ons, this.onsComponentName);
        while (!this.threadShutdown) {
            BodyBlock bodyBlock = new BodyBlock();
            HeaderBlock headerBlock = new HeaderBlock();
            if (this.compCb != null) {
                this.compCb.OpmnCallback(bodyBlock, headerBlock, this.notifCbData);
            }
            byte[] byArray = bodyBlock.generateBody();
            Notification notification = new Notification("IAS/PM/PROC_READY", "", "", byArray);
            headerBlock.setHeader(notification);
            String string = this.ons.config.getInstanceId();
            if (string != null) {
                notification.put("instanceId", string);
            }
            if (!this.opmnId.equals("-1")) {
                notification.put("OPMN_UID", this.opmnId);
            }
            if (this.firstTime) {
                this.firstTime = false;
                notification.put("OPMFirst", "true");
            } else {
                notification.put("OPMFirst", "false");
            }
            if (this.localOnly) {
                notification.setLocalOnly();
            }
            publisher.publish(notification);
            if (this.threadShutdown) continue;
            try {
                Thread.sleep(this.pingInterval);
            }
            catch (Exception exception) {}
        }
        publisher.close();
        this.notifThread = null;
    }

    public void shutdown() {
        try {
            this.threadShutdown = true;
            this.notifThread.interrupt();
        }
        catch (Exception exception) {
            ONS.error("Exception while shutting down receiver thread");
            exception.printStackTrace(this.ons.errstream);
        }
    }

    public void setFirstNotificationFlag() {
        this.firstTime = true;
    }
}

