/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import oracle.ons.Message;
import oracle.ons.Node;
import oracle.ons.Notification;
import oracle.ons.NotificationNetwork;
import oracle.ons.SubscribePermission;
import oracle.ons.Subscriber;

class SubscriptionProxy {
    private final Map<Integer, WeakReference<Subscriber>> frontendSubscribers = new ConcurrentHashMap<Integer, WeakReference<Subscriber>>();
    private final NotificationNetwork network;
    private final Map<Notification.NotificationKey, Notification.NotificationKey> notificationHistory = new ConcurrentHashMap<Notification.NotificationKey, Notification.NotificationKey>();
    private final Queue<Notification.NotificationKey> notificationHistoryTimeouts = new LinkedList<Notification.NotificationKey>();
    private final String subscriptionKey;
    protected final Message subscriptionMessage;
    private volatile Notification registrationNotification = null;

    public SubscriptionProxy(NotificationNetwork notificationNetwork, Subscriber subscriber) {
        this.add(subscriber);
        this.subscriptionKey = subscriber.getSubscriptionKey();
        this.subscriptionMessage = subscriber.getSubscriptionMessage();
        this.network = notificationNetwork;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populate(Notification notification) throws InterruptedException {
        Object object;
        ++this.network.messageReceived;
        if (notification.getKey() != null) {
            long l2 = System.currentTimeMillis() - this.network.config.getNotificationWindow();
            object = this.notificationHistory.get(notification.getKey());
            if (object != null) {
                ++this.network.messageDropped;
                return;
            }
            SubscriptionProxy subscriptionProxy = this;
            synchronized (subscriptionProxy) {
                while (!this.notificationHistoryTimeouts.isEmpty() && this.notificationHistoryTimeouts.peek().expired(l2)) {
                    this.notificationHistory.remove(this.notificationHistoryTimeouts.remove());
                }
                this.notificationHistoryTimeouts.add(notification.getKey());
            }
            this.notificationHistory.put(notification.getKey(), notification.getKey());
        }
        for (WeakReference<Subscriber> weakReference : this.frontendSubscribers.values()) {
            object = (Subscriber)weakReference.get();
            if (object == null) continue;
            ((Subscriber)object).put(notification);
        }
    }

    public void add(Subscriber subscriber) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SubscribePermission("ONSUser"));
        }
        this.frontendSubscribers.put(subscriber.id, new WeakReference<Subscriber>(subscriber));
        if (this.registrationNotification != null) {
            try {
                subscriber.put(this.registrationNotification);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    synchronized void setRegistrationNotification(Notification notification) {
        this.registrationNotification = notification;
    }

    public void remove(Subscriber subscriber) {
        this.frontendSubscribers.remove(subscriber.id);
    }

    public String getSubscriptionKey() {
        return this.subscriptionKey;
    }

    public boolean isEmpty() {
        return this.frontendSubscribers.isEmpty();
    }

    protected void setServerSubscriberInfo(Node node, String string) {
        for (WeakReference<Subscriber> weakReference : this.frontendSubscribers.values()) {
            Subscriber subscriber = (Subscriber)weakReference.get();
            if (subscriber == null) continue;
            subscriber.setServerSubscriberInfo(node, string);
        }
    }
}

