/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.ons.spi.WorkloadManager;

public class ThreadPoolWorkloadManager
implements WorkloadManager {
    public static final int DEFAULT_POOL_SIZE = 12;
    public static final int POOL_TIMEOUT = 2000;
    private final int maxPoolSize;
    private final AtomicInteger poolSize = new AtomicInteger(0);
    private final AtomicInteger freePool = new AtomicInteger(0);
    private final DelayQueue<SimpleDelayedTask> queue = new DelayQueue();

    private void createWorker() {
        int n2 = this.poolSize.incrementAndGet();
        if (n2 > this.maxPoolSize) {
            this.poolSize.decrementAndGet();
        } else {
            new ExecutorThread().start();
        }
    }

    public ThreadPoolWorkloadManager() {
        this.maxPoolSize = 12;
    }

    @Override
    public void scheduleDelayed(Runnable runnable, long l2) {
        SimpleDelayedTask simpleDelayedTask = new SimpleDelayedTask(runnable, l2);
        this.queue.offer(simpleDelayedTask);
        if (this.poolSize.get() < this.maxPoolSize && (this.freePool.get() == 0 || l2 == 0L || this.poolSize.get() == 0)) {
            this.createWorker();
        }
    }

    @Override
    public void schedule(Runnable runnable) {
        this.scheduleDelayed(runnable, 0L);
    }

    private class ExecutorThread
    extends Thread {
        public ExecutorThread() {
            this.setDaemon(true);
            this.setName(String.format("ONS-task-thread-%d", this.getId()));
        }

        @Override
        public void run() {
            SimpleDelayedTask simpleDelayedTask = null;
            long l2 = 2000L;
            try {
                boolean bl2;
                do {
                    ThreadPoolWorkloadManager.this.freePool.incrementAndGet();
                    bl2 = true;
                    while (null != (simpleDelayedTask = (SimpleDelayedTask)ThreadPoolWorkloadManager.this.queue.poll(l2, TimeUnit.MILLISECONDS))) {
                        SimpleDelayedTask simpleDelayedTask2;
                        if (ThreadPoolWorkloadManager.this.poolSize.get() < ThreadPoolWorkloadManager.this.maxPoolSize && (simpleDelayedTask2 = (SimpleDelayedTask)ThreadPoolWorkloadManager.this.queue.peek()) != null && simpleDelayedTask2.getDelay(TimeUnit.MILLISECONDS) <= 0L) {
                            ThreadPoolWorkloadManager.this.createWorker();
                        }
                        ThreadPoolWorkloadManager.this.freePool.decrementAndGet();
                        simpleDelayedTask.action.run();
                        l2 = 2000L;
                    }
                    if (ThreadPoolWorkloadManager.this.poolSize.decrementAndGet() != 0 || (simpleDelayedTask = (SimpleDelayedTask)ThreadPoolWorkloadManager.this.queue.peek()) == null) continue;
                    l2 = simpleDelayedTask.getDelay(TimeUnit.MILLISECONDS);
                    if (ThreadPoolWorkloadManager.this.poolSize.incrementAndGet() <= ThreadPoolWorkloadManager.this.maxPoolSize) {
                        bl2 = false;
                        continue;
                    }
                    ThreadPoolWorkloadManager.this.poolSize.decrementAndGet();
                } while (!bl2);
            }
            catch (InterruptedException interruptedException) {
                this.interrupt();
            }
        }
    }

    private static class SimpleDelayedTask
    implements Delayed {
        long runAt;
        Runnable action;

        SimpleDelayedTask(Runnable runnable, long l2) {
            this.action = runnable;
            this.runAt = System.currentTimeMillis() + l2;
        }

        @Override
        public long getDelay(TimeUnit timeUnit) {
            return timeUnit.convert(this.runAt - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed delayed) {
            return (int)(this.runAt - ((SimpleDelayedTask)delayed).runAt);
        }
    }
}

