/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons.rpc.impl;

import oracle.ons.Notification;
import oracle.ons.Publisher;
import oracle.ons.rpc.RpcRequest;

final class RpcRequestImpl
implements RpcRequest {
    private String broadcastId;
    private String directSource;
    private String traceRoute;
    private String logicalAddress;
    private byte[] argsBytes;
    private Publisher publisher;
    private boolean finalResponseSent;

    RpcRequestImpl(String string, String string2, String string3, String string4, byte[] byArray, Publisher publisher) {
        this.broadcastId = string;
        this.directSource = string2;
        this.traceRoute = string3;
        this.logicalAddress = string4;
        this.argsBytes = byArray;
        this.publisher = publisher;
        this.finalResponseSent = false;
    }

    @Override
    public byte[] getArgBytes() {
        return this.argsBytes;
    }

    @Override
    public void sendResult(byte[] byArray, boolean bl2) {
        boolean bl3 = true;
        this.sendResponse(byArray, bl3, bl2);
    }

    private void sendResponse(byte[] byArray, boolean bl2, boolean bl3) {
        if (this.finalResponseSent) {
            throw new IllegalStateException("Responding to an RPC request that has already completed.  Either the result (final message) has already been sent or the callback to RpcRequestListener.onRequest() has returned.");
        }
        Notification notification = new Notification("ONS_RPC_RESPONSE", "", "", byArray);
        notification.put("ONSbroadcastID", this.broadcastId);
        notification.put("DirectRoute", this.directSource);
        notification.put("BackRoute", this.traceRoute);
        notification.putInternalProperty("Result", bl3 ? "success" : "failure");
        notification.put("DirectSource", this.logicalAddress);
        this.publisher.publish(notification);
        if (bl2) {
            this.finalResponseSent = true;
        }
    }

    boolean isDone() {
        return this.finalResponseSent;
    }
}

