/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons.rpc.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import oracle.ons.CallBack;
import oracle.ons.CallBackMode;
import oracle.ons.CallBackSubscriber;
import oracle.ons.Notification;
import oracle.ons.ONS;
import oracle.ons.Publisher;
import oracle.ons.rpc.RpcRequestListener;
import oracle.ons.rpc.RpcServer;
import oracle.ons.rpc.RpcServerException;
import oracle.ons.rpc.impl.RpcRequestImpl;

public final class RpcServerImpl
implements CallBack,
RpcServer {
    private CallBackSubscriber cbsubscriber;
    private String component;
    private ONS myons;
    private String rpcServerName;
    private CallBackMode callBackMode;
    private Map<String, RpcRequestListener> rpcRequestListeners;
    private Map<String, String> addrProperties;
    private boolean isRunning;
    private Publisher publisher;
    private static AtomicInteger globalId = new AtomicInteger(1);
    private Logger logger;

    public RpcServerImpl(ONS oNS, String string, String string2, Map<String, String> map, CallBackMode callBackMode) {
        this.myons = oNS;
        RpcServerImpl rpcServerImpl = this;
        this.logger = rpcServerImpl.myons.getLogger();
        this.component = string2;
        this.rpcServerName = string;
        this.callBackMode = callBackMode;
        this.cbsubscriber = null;
        this.rpcRequestListeners = new HashMap<String, RpcRequestListener>();
        this.isRunning = false;
        this.addrProperties = map;
        this.logger.info("create (" + string + ", " + string2 + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void launch() throws RpcServerException {
        Object object = this;
        synchronized (object) {
            if (this.isRunning) {
                return;
            }
            this.isRunning = true;
        }
        this.logger.info("launch (" + this.rpcServerName + ")");
        object = "\"eventType=_XNOP" + Integer.toString(globalId.getAndIncrement()) + "\"";
        this.cbsubscriber = new CallBackSubscriber(this.rpcServerName, this.myons, (String)object, this.component, this, this.callBackMode, this.addrProperties);
        this.publisher = new Publisher(this.rpcServerName);
        this.cbsubscriber.waitForRpcServerRegistrationReply();
        this.logger.info("launch (" + this.rpcServerName + ") complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        RpcServerImpl rpcServerImpl = this;
        synchronized (rpcServerImpl) {
            if (!this.isRunning) {
                return;
            }
            this.isRunning = false;
        }
        this.logger.info("shutdown (" + this.rpcServerName + ")");
        if (this.cbsubscriber != null) {
            this.cbsubscriber.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRequestListener(String string, RpcRequestListener rpcRequestListener) {
        RpcServerImpl rpcServerImpl = this;
        synchronized (rpcServerImpl) {
            if (string == null) {
                throw new IllegalArgumentException("Cannot add an RPC handler with a null RPC name");
            }
            if (this.rpcRequestListeners.containsKey(string)) {
                throw new IllegalArgumentException("RPC " + string + " is already added to this RPC Server");
            }
            this.rpcRequestListeners.put(string, rpcRequestListener);
        }
    }

    @Override
    public void notification_callback(Notification notification) {
        byte[] byArray;
        String string = notification.get("DirectSource");
        String string2 = notification.get("ONSbroadcastID");
        String string3 = notification.get("TraceRoute");
        String string4 = notification.get("ONSrpcRequest");
        byte[] byArray2 = notification.body();
        if (byArray2 != null) {
            int n2;
            int n3 = 0;
            for (n2 = 0; n2 < byArray2.length; ++n2) {
                if (byArray2[n2] != 0) continue;
                n3 = n2;
                break;
            }
            byArray = new byte[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                byArray[n2] = byArray2[n2];
            }
        } else {
            byArray = null;
        }
        RpcRequestListener rpcRequestListener = this.rpcRequestListeners.get(string4);
        RpcRequestImpl rpcRequestImpl = new RpcRequestImpl(string2, string, string3, this.cbsubscriber.getLogicalAddress(), byArray, this.publisher);
        if (rpcRequestListener == null) {
            rpcRequestImpl.sendResult("RpcRequestListener is null".getBytes(), false);
            return;
        }
        try {
            rpcRequestListener.onRequest(rpcRequestImpl);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            rpcRequestImpl.sendResult(throwable.toString().getBytes(), false);
        }
        if (!rpcRequestImpl.isDone()) {
            rpcRequestImpl.sendResult(null, true);
        }
    }
}

