/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.asn1;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.Date;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Header;
import oracle.security.crypto.asn1.ASN1TaggedObject;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.UnsyncByteArrayOutputStream;
import oracle.security.crypto.util.Utils;

public class ASN1Date
implements ASN1TaggedObject {
    private ASN1Header a;
    private Date b;
    private boolean c;

    public ASN1Date() {
        this(new Date());
    }

    public ASN1Date(Date date) {
        this(date, false);
    }

    public ASN1Date(Date date, boolean bl2) {
        this.a(date, bl2);
    }

    public ASN1Date(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    private void a(Date date, boolean bl2) {
        this.b = date;
        this.c = bl2;
        this.a = new ASN1Header(bl2 ? 24 : 23, 0, 0, bl2 ? 15 : 13);
    }

    @Override
    public ASN1Header getHeader() {
        return this.a;
    }

    public Date getValue() {
        return this.b;
    }

    public void setUseGeneralizedTime(boolean bl2) {
        this.c = bl2;
    }

    public boolean getUseGeneralizedTime() {
        return this.c;
    }

    public String toString() {
        return (this.c ? "GeneralizedTime " : "UTCTime ") + this.b.toString();
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = inputStream instanceof PushbackInputStream ? (PushbackInputStream)inputStream : new PushbackInputStream(inputStream);
        int n2 = Utils.inputByte(pushbackInputStream) & 0xFF;
        pushbackInputStream.unread(n2);
        int n3 = ASN1Utils.getTag(n2);
        this.a(ASN1Date.inputValue(pushbackInputStream), n3 == 24);
    }

    public static Date inputValue(InputStream inputStream) throws IOException {
        ASN1Header aSN1Header = new ASN1Header(inputStream);
        aSN1Header.checkTagClass(0);
        int n2 = aSN1Header.getTag();
        if (n2 != 23 && n2 != 24) {
            throw new ASN1FormatException("Got tag " + n2 + " instead of " + 23 + " or " + 24 + ".");
        }
        return Utils.parseDate(Utils.fromUTF8(ASN1Date.a(inputStream, aSN1Header, 0)), n2 == 24);
    }

    private static byte[] a(InputStream inputStream, ASN1Header aSN1Header, int n2) throws IOException {
        if (aSN1Header == null) {
            aSN1Header = new ASN1Header(inputStream);
            aSN1Header.checkTagClass(0);
            aSN1Header.checkTag(n2);
        }
        if (aSN1Header.getEncodingMethod() == 0) {
            return aSN1Header.readBody(inputStream);
        }
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        ASN1ConstructedInputStream aSN1ConstructedInputStream = new ASN1ConstructedInputStream(inputStream, aSN1Header);
        while (aSN1ConstructedInputStream.hasMoreData()) {
            unsyncByteArrayOutputStream.write(ASN1Date.a(aSN1ConstructedInputStream, null, n2));
        }
        aSN1ConstructedInputStream.terminate();
        return unsyncByteArrayOutputStream.toByteArray();
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.a.output(outputStream);
        ASN1Date.a(outputStream, this.b, this.c);
    }

    @Override
    public int length() {
        return this.a.totalLength();
    }

    public static void outputValue(OutputStream outputStream, Date date) throws IOException {
        ASN1Date.outputValue(outputStream, date, false);
    }

    public static void outputValue(OutputStream outputStream, Date date, boolean bl2) throws IOException {
        ASN1Date.a(outputStream, date, bl2, bl2 ? 24 : 23, 0);
    }

    public static void outputValueWithTag(OutputStream outputStream, Date date, int n2) throws IOException {
        ASN1Date.outputValueWithTag(outputStream, date, false, n2);
    }

    public static void outputValueWithTag(OutputStream outputStream, Date date, boolean bl2, int n2) throws IOException {
        ASN1Date.a(outputStream, date, bl2, n2, 128);
    }

    private static void a(OutputStream outputStream, Date date, boolean bl2, int n2, int n3) throws IOException {
        outputStream.write(n3 + n2);
        outputStream.write(bl2 ? 15 : 13);
        ASN1Date.a(outputStream, date, bl2);
    }

    private static void a(OutputStream outputStream, Date date, boolean bl2) throws IOException {
        outputStream.write(Utils.toUTF8(Utils.formatDate(date, bl2)));
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

