/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.asn1;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.SequenceInputStream;
import oracle.security.crypto.asn1.ASN1BitString;
import oracle.security.crypto.asn1.ASN1Boolean;
import oracle.security.crypto.asn1.ASN1Date;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1GenericPrimitive;
import oracle.security.crypto.asn1.ASN1Header;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Null;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1Set;
import oracle.security.crypto.asn1.ASN1String;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class ASN1Utils {
    public static final int[] rsaID = new int[]{1, 2, 840, 113549};
    public static final int[] netscapeID = new int[]{2, 16, 840, 1, 113730};
    public static final int[] entrustID = new int[]{1, 2, 840, 113533, 7};
    public static final int[] phaosID = new int[]{1, 3, 6, 1, 4, 1, 2518};
    public static final int[] pkcsID = new int[]{1, 2, 840, 113549, 1};
    public static final int[] attrTypeID = new int[]{2, 5, 4};
    public static final int[] oiwAlgID = new int[]{1, 3, 14, 3, 2};
    public static final int[] xcmID = new int[]{1, 2, 840, 10040, 4};
    public static final int[] xkaID = new int[]{1, 2, 840, 10046};
    public static final int[] xecdsaID = new int[]{1, 2, 840, 10045};
    public static final int[] iana = new int[]{1, 3, 6, 1, 5, 5, 8};
    public static final int[] nistAlgorithms = new int[]{2, 16, 840, 1, 101, 3, 4};
    public static final int[] dds = new int[]{1, 3, 6, 1, 4, 1, 3029};

    private ASN1Utils() {
    }

    public static ASN1Object inputASN1Object(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream);
        byte by2 = Utils.inputByte(pushbackInputStream);
        pushbackInputStream.unread(by2);
        if ((by2 & 0xC0) == 0) {
            switch (by2 & 0x1F) {
                case 0: {
                    throw new ASN1FormatException("Unexpected end-of-contents octet.");
                }
                case 1: {
                    return new ASN1Boolean(pushbackInputStream);
                }
                case 2: {
                    return new ASN1Integer(pushbackInputStream);
                }
                case 3: {
                    return new ASN1BitString(pushbackInputStream);
                }
                case 4: {
                    return new ASN1OctetString(pushbackInputStream);
                }
                case 5: {
                    return new ASN1Null(pushbackInputStream);
                }
                case 6: {
                    return new ASN1ObjectID(pushbackInputStream);
                }
                case 16: {
                    return new ASN1Sequence(pushbackInputStream);
                }
                case 17: {
                    return new ASN1Set(pushbackInputStream);
                }
                case 12: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 30: {
                    return new ASN1String(pushbackInputStream);
                }
                case 23: 
                case 24: {
                    return new ASN1Date(pushbackInputStream);
                }
            }
        }
        if ((by2 & 0x20) == 0) {
            return new ASN1GenericPrimitive(pushbackInputStream);
        }
        return new ASN1GenericConstructed(pushbackInputStream);
    }

    public static ASN1Object inputASN1Object(byte[] byArray) throws IOException {
        return ASN1Utils.inputASN1Object(new UnsyncByteArrayInputStream(byArray));
    }

    public static void outputLengthBytes(OutputStream outputStream, int n2) throws IOException {
        if (n2 < 128) {
            outputStream.write(n2);
        } else {
            int n3 = n2 >= 0x1000000 ? 4 : (n2 >= 65536 ? 3 : (n2 >= 256 ? 2 : 1));
            outputStream.write(0x80 | n3);
            --n3;
            while (n3 >= 0) {
                outputStream.write(n2 >> 8 * n3 & 0xFF);
                --n3;
            }
        }
    }

    public static void outputBase128(int n2, OutputStream outputStream) throws IOException {
        for (int i2 = ASN1Utils.lengthBase128(n2) - 1; i2 >= 0; --i2) {
            int n3 = n2 >> 7 * i2 & 0x7F;
            if (i2 != 0) {
                n3 |= 0x80;
            }
            outputStream.write(n3);
        }
    }

    public static byte[] toBytesBase128(int n2) {
        byte[] byArray = new byte[ASN1Utils.lengthBase128(n2)];
        for (int i2 = byArray.length - 1; i2 >= 0; --i2) {
            int n3 = n2 >> 7 * i2 & 0x7F;
            if (i2 != 0) {
                n3 |= 0x80;
            }
            byArray[byArray.length - 1 - i2] = (byte)n3;
        }
        return byArray;
    }

    public static int inputBase128(InputStream inputStream) throws IOException {
        byte by2;
        int n2 = 0;
        int n3 = 0;
        do {
            if (n3 > 4 || (n2 & 0xFF000000) != 0) {
                throw new InvalidInputException("Component too large.");
            }
            by2 = Utils.inputByte(inputStream);
            n2 <<= 7;
            n2 |= by2 & 0x7F;
            ++n3;
        } while ((by2 & 0x80) != 0);
        return n2;
    }

    public static int lengthBase128(int n2) {
        if (n2 >= 0x10000000) {
            return 5;
        }
        if (n2 >= 0x200000) {
            return 4;
        }
        if (n2 >= 16384) {
            return 3;
        }
        if (n2 >= 128) {
            return 2;
        }
        return 1;
    }

    public static int lengthBase256(int n2) {
        if (n2 >= 0x1000000) {
            return 4;
        }
        if (n2 >= 65536) {
            return 3;
        }
        if (n2 >= 256) {
            return 2;
        }
        return 1;
    }

    public static boolean isPrefix(int[] nArray, int[] nArray2) {
        if (nArray.length > nArray2.length) {
            return false;
        }
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (nArray[i2] == nArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public static void outputHeader(OutputStream outputStream, int n2, int n3) throws IOException {
        outputStream.write(n2 + n3 + 32);
        outputStream.write(128);
    }

    public static void outputEndOfContents(OutputStream outputStream) throws IOException {
        outputStream.write(0);
        outputStream.write(0);
    }

    public static int getTag(int n2) {
        return n2 & 0x1F;
    }

    public static ASN1Object addImplicitTag(ASN1Object aSN1Object, int n2) {
        try {
            InputStream inputStream = Utils.toStream(aSN1Object);
            ASN1Header aSN1Header = new ASN1Header(inputStream);
            if (aSN1Header.getEncodingMethod() == 0) {
                return new ASN1GenericPrimitive(aSN1Header.readBody(inputStream), n2);
            }
            ASN1Header aSN1Header2 = new ASN1Header(n2, 128, aSN1Header.getEncodingMethod(), aSN1Header.getBodyLength());
            return new ASN1GenericConstructed(new SequenceInputStream(Utils.toStream(aSN1Header2), inputStream));
        }
        catch (IOException iOException) {
            throw new StreamableOutputException(iOException.toString());
        }
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

