/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1Set;
import oracle.security.crypto.asn1.ASN1SetInputStream;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class Attribute
implements Externalizable,
ASN1Object {
    private ASN1ObjectID type;
    private ArrayList<ASN1Object> values;
    private ASN1Sequence seq = null;

    public Attribute() {
    }

    public Attribute(ASN1ObjectID aSN1ObjectID) {
        this.type = aSN1ObjectID;
        this.values = new ArrayList();
    }

    public Attribute(ASN1ObjectID aSN1ObjectID, ASN1Object aSN1Object) {
        this(aSN1ObjectID);
        this.addValue(aSN1Object);
    }

    public Attribute(ASN1ObjectID aSN1ObjectID, Vector<? extends ASN1Object> vector) {
        this(aSN1ObjectID);
        this.setValues(vector);
    }

    public Attribute(ASN1ObjectID aSN1ObjectID, List<? extends ASN1Object> list) {
        this(aSN1ObjectID);
        this.setValues(list);
    }

    public Attribute(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public ASN1ObjectID getType() {
        return this.type;
    }

    public void addValue(ASN1Object aSN1Object) {
        this.values.add(aSN1Object);
        this.reset();
    }

    public void setValues(Vector<? extends ASN1Object> vector) {
        if (vector.size() == 0) {
            throw new IllegalArgumentException("Attribute value set may not be empty");
        }
        this.values.clear();
        this.reset();
        int n2 = vector.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.values.add(vector.get(i2));
        }
    }

    public void setValues(List<? extends ASN1Object> list) {
        if (list.size() == 0) {
            throw new IllegalArgumentException("Attribute value set may not be empty");
        }
        this.values.clear();
        this.reset();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.values.add(list.get(i2));
        }
    }

    @Deprecated
    public Enumeration<ASN1Object> values() {
        return this.values == null ? null : new VectorOverArrayList<ASN1Object>(this.values).elements();
    }

    @Deprecated
    public Vector<ASN1Object> getValues() {
        return this.values == null ? null : new VectorOverArrayList<ASN1Object>(this.values);
    }

    public ArrayList<ASN1Object> getValuesAsList() {
        return this.values;
    }

    public int size() {
        return this.values.size();
    }

    public String toString() {
        String string = this.type + " : {";
        Iterator<ASN1Object> iterator = this.values.iterator();
        while (iterator.hasNext()) {
            string = string + " " + iterator.next();
            if (!iterator.hasNext()) continue;
            string = string + ",";
        }
        string = string + " }";
        return string;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.type = new ASN1ObjectID(aSN1SequenceInputStream);
        this.values = new ArrayList();
        ASN1SetInputStream aSN1SetInputStream = new ASN1SetInputStream(aSN1SequenceInputStream);
        do {
            this.values.add(ASN1Utils.inputASN1Object(aSN1SetInputStream));
        } while (aSN1SequenceInputStream.hasMoreData());
        aSN1SetInputStream.terminate();
        aSN1SequenceInputStream.terminate();
        this.reset();
    }

    private void reset() {
        this.seq = null;
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.seq == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(this.type);
            aSN1Sequence.addElement(new ASN1Set(this.values));
            this.seq = aSN1Sequence;
        }
        return this.seq;
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.toASN1Sequence().output(outputStream);
    }

    @Override
    public int length() {
        return this.toASN1Sequence().length();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }
}

