/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Set;
import oracle.security.crypto.asn1.ASN1SetInputStream;
import oracle.security.crypto.cert.Attribute;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class AttributeSet
implements Externalizable,
Cloneable,
ASN1Object {
    private LinkedHashMap<ASN1ObjectID, Attribute> attributes;
    private ASN1Set contents;

    public AttributeSet() {
        this.attributes = new LinkedHashMap();
    }

    public AttributeSet(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public Attribute addAttribute(Attribute attribute) {
        this.update();
        return this.attributes.put(attribute.getType(), attribute);
    }

    public Attribute addAttribute(ASN1ObjectID aSN1ObjectID, ASN1Object aSN1Object) {
        return this.addAttribute(new Attribute(aSN1ObjectID, aSN1Object));
    }

    public Attribute addAttribute(ASN1ObjectID aSN1ObjectID, Vector<? extends ASN1Object> vector) {
        return this.addAttribute(new Attribute(aSN1ObjectID, vector));
    }

    public Attribute addAttribute(ASN1ObjectID aSN1ObjectID, List<? extends ASN1Object> list) {
        return this.addAttribute(new Attribute(aSN1ObjectID, list));
    }

    public Attribute getAttribute(ASN1ObjectID aSN1ObjectID) {
        if (this.hasAttribute(aSN1ObjectID)) {
            return this.attributes.get(aSN1ObjectID);
        }
        return null;
    }

    public void addAttributeValue(ASN1ObjectID aSN1ObjectID, ASN1Object aSN1Object) {
        Attribute attribute = this.getAttribute(aSN1ObjectID);
        if (attribute != null) {
            attribute.addValue(aSN1Object);
        } else {
            this.addAttribute(aSN1ObjectID, aSN1Object);
        }
    }

    @Deprecated
    public Vector<ASN1Object> getAttributeValues(ASN1ObjectID aSN1ObjectID) {
        Attribute attribute = this.getAttribute(aSN1ObjectID);
        return attribute != null ? attribute.getValues() : null;
    }

    public ArrayList<ASN1Object> getAttributeValuesAsList(ASN1ObjectID aSN1ObjectID) {
        Attribute attribute = this.getAttribute(aSN1ObjectID);
        return attribute != null ? attribute.getValuesAsList() : null;
    }

    public Map<ASN1ObjectID, Attribute> getAttributesAsMap() {
        return this.attributes;
    }

    public int size() {
        return this.attributes.size();
    }

    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    public boolean hasAttribute(ASN1ObjectID aSN1ObjectID) {
        return this.attributes.containsKey(aSN1ObjectID);
    }

    @Deprecated
    public Enumeration<ASN1ObjectID> types() {
        return this.attributes == null ? null : new Vector<ASN1ObjectID>(this.attributes.keySet()).elements();
    }

    public Object clone() {
        AttributeSet attributeSet = new AttributeSet();
        attributeSet.attributes = new LinkedHashMap<ASN1ObjectID, Attribute>(this.attributes);
        return attributeSet;
    }

    public String toString() {
        String string = "{";
        Iterator<Attribute> iterator = this.attributes.values().iterator();
        while (iterator.hasNext()) {
            string = string + " " + iterator.next();
            if (!iterator.hasNext()) continue;
            string = string + ",";
        }
        string = string + " }";
        return string;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.attributes = new LinkedHashMap();
        ASN1SetInputStream aSN1SetInputStream = new ASN1SetInputStream(inputStream);
        while (aSN1SetInputStream.hasMoreData()) {
            Attribute attribute = new Attribute(aSN1SetInputStream);
            this.attributes.put(attribute.getType(), attribute);
        }
        aSN1SetInputStream.terminate();
        this.update();
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.toASN1Set().output(outputStream);
    }

    @Override
    public int length() {
        return this.toASN1Set().length();
    }

    private void update() {
        this.contents = null;
    }

    public ASN1Set toASN1Set() {
        if (this.contents == null) {
            ASN1Set aSN1Set = new ASN1Set();
            for (Attribute attribute : this.attributes.values()) {
                aSN1Set.addElement(attribute);
            }
            this.contents = aSN1Set;
        }
        return this.contents;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }
}

