/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class AttributeTypeAndValue
implements Externalizable,
ASN1Object {
    private ASN1ObjectID type = null;
    private ASN1Object value = null;
    private ASN1Sequence contents;

    public AttributeTypeAndValue() {
    }

    public AttributeTypeAndValue(ASN1ObjectID aSN1ObjectID, ASN1Object aSN1Object) {
        this.type = aSN1ObjectID;
        this.value = aSN1Object;
    }

    public AttributeTypeAndValue(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public ASN1ObjectID getType() {
        return this.type;
    }

    public ASN1Object getValue() {
        return this.value;
    }

    public void setValue(ASN1Object aSN1Object) {
        this.value = aSN1Object;
        this.update();
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.type = new ASN1ObjectID(aSN1SequenceInputStream);
        this.value = ASN1Utils.inputASN1Object(aSN1SequenceInputStream);
        aSN1SequenceInputStream.terminate();
        this.update();
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.toASN1Sequence().output(outputStream);
    }

    @Override
    public int length() {
        return this.toASN1Sequence().length();
    }

    private void update() {
        this.contents = null;
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.contents == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(this.type);
            aSN1Sequence.addElement(this.value);
            this.contents = aSN1Sequence;
        }
        return this.contents;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }
}

