/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.AttributeTypeAndValue;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class AttributeTypeAndValueList
implements Externalizable,
Cloneable,
ASN1Object {
    private LinkedHashMap<ASN1ObjectID, AttributeTypeAndValue> attrMap = new LinkedHashMap();
    private transient ASN1Sequence contents;

    public AttributeTypeAndValueList() {
    }

    public AttributeTypeAndValueList(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public AttributeTypeAndValue addAttribute(AttributeTypeAndValue attributeTypeAndValue) {
        AttributeTypeAndValue attributeTypeAndValue2 = this.attrMap.put(attributeTypeAndValue.getType(), attributeTypeAndValue);
        this.update();
        return attributeTypeAndValue2;
    }

    public AttributeTypeAndValue addAttribute(ASN1ObjectID aSN1ObjectID, ASN1Object aSN1Object) {
        return this.addAttribute(new AttributeTypeAndValue(aSN1ObjectID, aSN1Object));
    }

    public AttributeTypeAndValue getAttribute(ASN1ObjectID aSN1ObjectID) {
        if (this.hasAttribute(aSN1ObjectID)) {
            return this.attrMap.get(aSN1ObjectID);
        }
        return null;
    }

    public ASN1Object getAttributeValue(ASN1ObjectID aSN1ObjectID) {
        AttributeTypeAndValue attributeTypeAndValue = this.getAttribute(aSN1ObjectID);
        return attributeTypeAndValue != null ? attributeTypeAndValue.getValue() : null;
    }

    public boolean isEmpty() {
        return this.attrMap.isEmpty();
    }

    public boolean hasAttribute(ASN1ObjectID aSN1ObjectID) {
        return this.attrMap.containsKey(aSN1ObjectID);
    }

    @Deprecated
    public Enumeration<ASN1ObjectID> types() {
        return this.attrMap == null ? null : new Vector<ASN1ObjectID>(this.attrMap.keySet()).elements();
    }

    public Object clone() {
        try {
            AttributeTypeAndValueList attributeTypeAndValueList = (AttributeTypeAndValueList)super.clone();
            attributeTypeAndValueList.attrMap = this.attrMap == null ? null : new LinkedHashMap<ASN1ObjectID, AttributeTypeAndValue>(this.attrMap);
            return attributeTypeAndValueList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{ ");
        for (AttributeTypeAndValue attributeTypeAndValue : this.attrMap.values()) {
            stringBuffer.append(attributeTypeAndValue);
            stringBuffer.append(", ");
        }
        if (stringBuffer.length() >= 2) {
            stringBuffer.setLength(stringBuffer.length() - 2);
        }
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    @Deprecated
    public Vector<AttributeTypeAndValue> elements() {
        return this.attrMap == null ? null : new Vector<AttributeTypeAndValue>(this.attrMap.values());
    }

    public ArrayList<AttributeTypeAndValue> elementsAsList() {
        return this.attrMap == null ? null : new ArrayList<AttributeTypeAndValue>(this.attrMap.values());
    }

    public Map<ASN1ObjectID, AttributeTypeAndValue> elementsAsMap() {
        return this.attrMap;
    }

    public int size() {
        return this.attrMap.size();
    }

    public AttributeTypeAndValue elementAt(int n2) {
        ArrayList<AttributeTypeAndValue> arrayList = new ArrayList<AttributeTypeAndValue>(this.attrMap.values());
        return arrayList.get(n2);
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.attrMap.clear();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        while (aSN1SequenceInputStream.hasMoreData()) {
            AttributeTypeAndValue attributeTypeAndValue = new AttributeTypeAndValue(aSN1SequenceInputStream);
            this.attrMap.put(attributeTypeAndValue.getType(), attributeTypeAndValue);
        }
        aSN1SequenceInputStream.terminate();
        this.update();
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.toASN1().output(outputStream);
    }

    @Override
    public int length() {
        return this.toASN1().length();
    }

    ASN1Sequence toASN1() {
        if (this.contents == null) {
            this.contents = new ASN1Sequence(this.attrMap.values());
        }
        return this.contents;
    }

    private void update() {
        this.contents = null;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }
}

