/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class AuthorityInfoAccess
implements Externalizable,
ASN1Object {
    private LinkedHashMap<ASN1ObjectID, ArrayList<GeneralName>> access = new LinkedHashMap();
    private ASN1Sequence contents = null;

    public AuthorityInfoAccess() {
    }

    public AuthorityInfoAccess(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public void addAccessDescription(ASN1ObjectID aSN1ObjectID, GeneralName generalName) {
        ArrayList<GeneralName> arrayList = this.access.get(aSN1ObjectID);
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        arrayList.add(generalName);
        this.access.put(aSN1ObjectID, arrayList);
        this.reset();
    }

    @Deprecated
    public Enumeration<ASN1ObjectID> accessMethods() {
        return this.access == null ? null : new Vector<ASN1ObjectID>(this.access.keySet()).elements();
    }

    public Vector<GeneralName> getAccessDescriptions(ASN1ObjectID aSN1ObjectID) {
        ArrayList<GeneralName> arrayList = this.access.get(aSN1ObjectID);
        if (arrayList != null && arrayList.size() > 0) {
            return new VectorOverArrayList<GeneralName>(arrayList);
        }
        return null;
    }

    public ArrayList<GeneralName> getAccessDescriptionsAsList(ASN1ObjectID aSN1ObjectID) {
        ArrayList<GeneralName> arrayList = this.access.get(aSN1ObjectID);
        if (arrayList != null && arrayList.size() > 0) {
            return arrayList;
        }
        return null;
    }

    public boolean hasAccessMethod(ASN1ObjectID aSN1ObjectID) {
        return this.getAccessDescriptionsAsList(aSN1ObjectID) != null;
    }

    public int methodCount() {
        return this.access.size();
    }

    public String toString() {
        String string = "AuthorityAccessInfo {";
        for (ASN1ObjectID aSN1ObjectID : this.access.keySet()) {
            ArrayList<GeneralName> arrayList = this.access.get(aSN1ObjectID);
            if (arrayList == null) continue;
            for (GeneralName generalName : arrayList) {
                string = string + " {" + aSN1ObjectID.toStringCompact() + "," + generalName + "}";
            }
        }
        string = string + " }";
        return string;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.reset();
        this.access = new LinkedHashMap();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        while (aSN1SequenceInputStream.hasMoreData()) {
            ASN1SequenceInputStream aSN1SequenceInputStream2 = new ASN1SequenceInputStream(aSN1SequenceInputStream);
            ASN1ObjectID aSN1ObjectID = new ASN1ObjectID(aSN1SequenceInputStream2);
            GeneralName generalName = new GeneralName(aSN1SequenceInputStream2);
            this.addAccessDescription(aSN1ObjectID, generalName);
            aSN1SequenceInputStream2.terminate();
        }
        aSN1SequenceInputStream.terminate();
        if (this.access.size() == 0) {
            throw new ASN1FormatException("Sequence must contain at least 1 access description");
        }
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.toASN1Sequence().output(outputStream);
    }

    @Override
    public int length() {
        return this.toASN1Sequence().length();
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.contents == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            for (ASN1ObjectID aSN1ObjectID : this.access.keySet()) {
                ArrayList<GeneralName> arrayList = this.access.get(aSN1ObjectID);
                if (arrayList == null) continue;
                for (GeneralName generalName : arrayList) {
                    ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
                    aSN1Sequence2.addElement(aSN1ObjectID);
                    aSN1Sequence2.addElement(generalName);
                    aSN1Sequence.addElement(aSN1Sequence2);
                }
            }
            this.contents = aSN1Sequence;
        }
        return this.contents;
    }

    private void reset() {
        this.contents = null;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }
}

