/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import oracle.security.crypto.asn1.ASN1BitString;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1Date;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.RevokedCertificate;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.cert.X509ExtensionSet;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.SignatureException;
import oracle.security.crypto.provider.JCEUtil;
import oracle.security.crypto.provider.TransitionMode;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.OutputGenerationException;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class CRL
implements Externalizable,
ASN1Object {
    private ASN1Sequence tbsCertList = null;
    private AlgorithmIdentifier sigAlgID = null;
    private byte[] sigBytes = null;
    private X500Name issuer;
    private Date thisUpdate = new Date();
    private Date nextUpdate = null;
    private LinkedHashMap<BigInteger, RevokedCertificate> revokedCertificates = null;
    private X509ExtensionSet extensions = null;
    private PrivateKey privKey;
    private oracle.security.crypto.core.PublicKey pubKey;
    private X509Certificate issuerCert;
    private int version;
    private ASN1Sequence contents = null;
    X509CRLImpl crlImpl = new X509CRLImpl();

    public CRL() {
    }

    public CRL(InputStream inputStream) throws IOException {
        this();
        this.input(inputStream);
    }

    public CRL(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public CRL(URL uRL) throws IOException {
        this(uRL.openStream());
    }

    public CRL(X509 x509) {
        this.setIssuer(x509.getSubject());
        this.setPublicKey(x509.getPublicKey());
    }

    public CRL(X509 x509, InputStream inputStream) throws IOException {
        this(x509);
        this.input(inputStream);
    }

    public CRL(X509 x509, File file) throws FileNotFoundException, IOException {
        this(x509);
        FileInputStream fileInputStream = new FileInputStream(file);
        this.input(fileInputStream);
        fileInputStream.close();
    }

    public CRL(X509 x509, URL uRL) throws IOException {
        this(x509);
        InputStream inputStream = uRL.openStream();
        this.input(inputStream);
        inputStream.close();
    }

    public CRL(X500Name x500Name, oracle.security.crypto.core.PrivateKey privateKey, Date date, Date date2, Vector<? extends RevokedCertificate> vector) {
        this(x500Name, privateKey, date, date2, (List<? extends RevokedCertificate>)vector);
    }

    public CRL(X500Name x500Name, oracle.security.crypto.core.PrivateKey privateKey, Date date, Date date2, List<? extends RevokedCertificate> list) {
        this(x500Name, privateKey);
        this.setDates(date, date2);
        this.setRevokedCertificates(list);
    }

    public CRL(X500Name x500Name, oracle.security.crypto.core.PrivateKey privateKey, int n2) {
        this(x500Name, privateKey);
        if (n2 > 0) {
            this.setDates(n2);
        }
    }

    public CRL(X500Name x500Name, oracle.security.crypto.core.PrivateKey privateKey, int n2, AlgorithmIdentifier algorithmIdentifier) {
        this(x500Name, privateKey, n2);
        this.setSigAlgID(algorithmIdentifier);
    }

    public CRL(X500Name x500Name, oracle.security.crypto.core.PrivateKey privateKey) {
        this.setIssuer(x500Name);
        this.setPrivateKey(privateKey);
    }

    public static CRL toCRL(X509CRL x509CRL) {
        if (x509CRL instanceof X509CRLImpl) {
            return ((X509CRLImpl)x509CRL).toCRL();
        }
        try {
            return new CRL(new UnsyncByteArrayInputStream(x509CRL.getEncoded()));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (CRLException cRLException) {
            throw new RuntimeException(cRLException);
        }
    }

    public void setIssuer(X500Name x500Name) {
        this.issuer = x500Name;
        this.reset();
    }

    public void setIssuerCertificate(X509 x509) {
        this.setIssuerCertificate(x509.toX509Certificate());
    }

    public void setIssuerCertificate(X509Certificate x509Certificate) {
        this.issuerCert = x509Certificate;
        if (this.issuer == null) {
            if (x509Certificate instanceof X509.X509CertificateImpl) {
                this.setIssuer(((X509.X509CertificateImpl)x509Certificate).toX509().getIssuer());
            } else {
                this.setIssuer(X500Name.toX500Name(x509Certificate.getIssuerX500Principal()));
            }
        }
        this.setPublicKey(this.issuerCert.getPublicKey());
    }

    public X500Name getIssuer() {
        return this.issuer;
    }

    public void setPublicKey(oracle.security.crypto.core.PublicKey publicKey) {
        this.setPublicKey((PublicKey)publicKey);
    }

    public void setPublicKey(PublicKey publicKey) {
        this.pubKey = CryptoUtils.fromJCEPublicKey(publicKey);
    }

    public void setPrivateKey(oracle.security.crypto.core.PrivateKey privateKey) {
        this.setPrivateKey((PrivateKey)privateKey, null);
    }

    public void setPrivateKey(oracle.security.crypto.core.PrivateKey privateKey, AlgorithmIdentifier algorithmIdentifier) {
        this.setPrivateKey((PrivateKey)privateKey, algorithmIdentifier);
    }

    public void setPrivateKey(PrivateKey privateKey, AlgorithmIdentifier algorithmIdentifier) {
        this.privKey = privateKey;
        this.setSigAlgID(algorithmIdentifier);
    }

    public void setSigAlgID(AlgorithmIdentifier algorithmIdentifier) {
        this.sigAlgID = algorithmIdentifier;
        this.reset();
    }

    public Date getDate() {
        return this.thisUpdate;
    }

    public Date getNextDate() {
        return this.nextUpdate;
    }

    @Deprecated
    public Vector<RevokedCertificate> getRevokedCertificates() {
        ArrayList<RevokedCertificate> arrayList = this.getRevokedCertificatesAsList();
        return arrayList == null ? null : new VectorOverArrayList<RevokedCertificate>(arrayList);
    }

    public ArrayList<RevokedCertificate> getRevokedCertificatesAsList() {
        return this.revokedCertificates == null ? null : new ArrayList<RevokedCertificate>(this.revokedCertificates.values());
    }

    public Map<BigInteger, RevokedCertificate> getRevokedCertificatesAsMap() {
        return this.revokedCertificates;
    }

    public Enumeration<BigInteger> revokedSerialNos() {
        return this.revokedCertificates != null ? new Vector<BigInteger>(this.revokedCertificates.keySet()).elements() : new Vector().elements();
    }

    public void setRevokedCertificates(Vector<? extends RevokedCertificate> vector) {
        this.setRevokedCertificates((List<? extends RevokedCertificate>)vector);
    }

    public void setRevokedCertificates(List<? extends RevokedCertificate> list) {
        if (list != null && list.size() > 0) {
            this.revokedCertificates = new LinkedHashMap();
            for (RevokedCertificate revokedCertificate : list) {
                this.revokedCertificates.put(revokedCertificate.getSerialNo(), revokedCertificate);
            }
            this.reset();
        }
    }

    public void setDate(Date date) {
        this.thisUpdate = date;
        this.reset();
    }

    public void setDates(Date date, Date date2) {
        this.thisUpdate = date;
        this.nextUpdate = date2;
        this.reset();
    }

    public void setDates(int n2) {
        this.setDates(new Date(), Utils.daysFromNow(n2));
    }

    public void addCertificate(BigInteger bigInteger) {
        this.addCertificate(bigInteger, new Date());
    }

    public void addCertificate(BigInteger bigInteger, Date date) {
        this.addCertificate(new RevokedCertificate(bigInteger, date));
    }

    public void addCertificate(RevokedCertificate revokedCertificate) {
        if (this.revokedCertificates == null) {
            this.revokedCertificates = new LinkedHashMap();
        }
        this.revokedCertificates.put(revokedCertificate.getSerialNo(), revokedCertificate);
        this.reset();
    }

    public X509ExtensionSet getExtensionSet() {
        return this.extensions;
    }

    public X509Extension getExtension(ASN1ObjectID aSN1ObjectID) {
        return this.extensions != null ? this.extensions.getExtension(aSN1ObjectID) : null;
    }

    public void setExtensions(X509ExtensionSet x509ExtensionSet) {
        this.extensions = x509ExtensionSet;
        this.reset();
    }

    public void addExtension(X509Extension x509Extension) {
        if (this.extensions == null) {
            this.extensions = new X509ExtensionSet();
        }
        this.extensions.addExtension(x509Extension);
        this.reset();
    }

    public RevokedCertificate getRevokedCertificate(BigInteger bigInteger) {
        return this.revokedCertificates != null ? this.revokedCertificates.get(bigInteger) : null;
    }

    public Date revocationDate(BigInteger bigInteger) {
        RevokedCertificate revokedCertificate = this.getRevokedCertificate(bigInteger);
        return revokedCertificate != null ? revokedCertificate.getRevocationDate() : null;
    }

    public boolean isRevoked(BigInteger bigInteger) {
        return this.getRevokedCertificate(bigInteger) != null;
    }

    public boolean hasUnrecognizedCriticalExtension() {
        if (this.extensions != null && this.extensions.hasUnrecognizedCriticalExtension()) {
            return true;
        }
        if (this.revokedCertificates != null) {
            for (RevokedCertificate revokedCertificate : this.revokedCertificates.values()) {
                X509ExtensionSet x509ExtensionSet;
                if (revokedCertificate == null || (x509ExtensionSet = revokedCertificate.getExtensionSet()) == null || !x509ExtensionSet.hasUnrecognizedCriticalExtension()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean verify() throws AuthenticationException {
        if (this.hasUnrecognizedCriticalExtension()) {
            return false;
        }
        if (!this.verifyDate()) {
            return false;
        }
        return this.verifySignature();
    }

    public boolean verifyDate() {
        Date date = new Date();
        if (date.before(this.thisUpdate)) {
            return false;
        }
        return this.nextUpdate == null || !date.after(this.nextUpdate);
    }

    public boolean verifySignature() throws AuthenticationException {
        ASN1Sequence aSN1Sequence = this.getTBSCertListSeq();
        try {
            Signature signature = JCEUtil.getSignatureInstance(CryptoUtils.getSignatureAlg(this.sigAlgID));
            signature.initVerify(this.pubKey);
            signature.update(Utils.toBytes(aSN1Sequence));
            return signature.verify(this.getSignature());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AuthenticationException(noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new AuthenticationException(invalidKeyException);
        }
        catch (java.security.SignatureException signatureException) {
            throw new AuthenticationException(signatureException);
        }
    }

    public void sign() throws SignatureException {
        ASN1Sequence aSN1Sequence = this.getTBSCertListSeq();
        try {
            Signature signature = JCEUtil.getSignatureInstance(CryptoUtils.getSignatureAlg(this.sigAlgID));
            signature.initSign(this.privKey);
            signature.update(Utils.toBytes(aSN1Sequence));
            this.sigBytes = signature.sign();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SignatureException(noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SignatureException(invalidKeyException);
        }
        catch (java.security.SignatureException signatureException) {
            throw new SignatureException(signatureException);
        }
        finally {
            this.resetContents();
        }
    }

    public void sign(RandomBitsSource randomBitsSource) throws SignatureException {
        this.sign();
    }

    public byte[] getSigBytes() throws SignatureException {
        if (this.sigBytes == null) {
            this.sign();
        }
        return this.sigBytes;
    }

    private ASN1Sequence getTBSCertListSeq() {
        if (this.tbsCertList == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            if (this.extensions != null && this.extensions.size() > 0) {
                aSN1Sequence.addElement(new ASN1Integer(1L));
            } else if (this.revokedCertificates != null && this.revokedCertificates.size() > 0) {
                for (RevokedCertificate object2 : this.revokedCertificates.values()) {
                    if (object2.getExtensionsAsList() == null || object2.getExtensionsAsList().size() <= 0) continue;
                    aSN1Sequence.addElement(new ASN1Integer(1L));
                    break;
                }
            }
            if (this.sigAlgID == null && this.privKey != null) {
                if (this.privKey.getAlgorithm().equals("RSA")) {
                    this.sigAlgID = AlgID.sha256WithRSAEncryption;
                } else if (this.privKey.getAlgorithm().equals("DSA")) {
                    this.sigAlgID = AlgID.dsaWithSHA1;
                } else if (this.privKey.getAlgorithm().equals("EC")) {
                    int n2 = ((ECPrivateKey)this.privKey).getParams().getCurve().getField().getFieldSize();
                    switch (n2) {
                        case 256: {
                            this.sigAlgID = AlgID.ecdsaWithSHA256;
                            break;
                        }
                        case 384: {
                            this.sigAlgID = AlgID.ecdsaWithSHA384;
                            break;
                        }
                        case 512: {
                            this.sigAlgID = AlgID.ecdsaWithSHA512;
                            break;
                        }
                        default: {
                            this.sigAlgID = AlgID.ecdsaWithSHA1;
                        }
                    }
                }
            }
            aSN1Sequence.addElement(this.sigAlgID);
            aSN1Sequence.addElement(this.issuer);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.thisUpdate);
            aSN1Sequence.addElement(new ASN1Date(this.thisUpdate, calendar.get(1) > 2049));
            if (this.nextUpdate != null) {
                Calendar calendar2 = Calendar.getInstance();
                calendar2.setTime(this.nextUpdate);
                aSN1Sequence.addElement(new ASN1Date(this.nextUpdate, calendar2.get(1) > 2049));
            }
            if (this.revokedCertificates != null && this.revokedCertificates.size() > 0) {
                ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
                for (RevokedCertificate revokedCertificate : this.revokedCertificates.values()) {
                    aSN1Sequence2.addElement(revokedCertificate);
                }
                aSN1Sequence.addElement(aSN1Sequence2);
            }
            if (this.extensions != null && this.extensions.size() > 0) {
                aSN1Sequence.addElement(new ASN1GenericConstructed(this.extensions, 0));
            }
            this.tbsCertList = aSN1Sequence;
        }
        return this.tbsCertList;
    }

    private ASN1Sequence toASN1Sequence() throws SignatureException {
        if (this.contents == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(this.getTBSCertListSeq());
            aSN1Sequence.addElement(this.sigAlgID);
            aSN1Sequence.addElement(new ASN1BitString(this.getSigBytes()));
            this.contents = aSN1Sequence;
        }
        return this.contents;
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        try {
            this.toASN1Sequence().output(outputStream);
        }
        catch (SignatureException signatureException) {
            throw new OutputGenerationException(signatureException.toString());
        }
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        ASN1ConstructedInputStream aSN1ConstructedInputStream;
        Serializable serializable;
        this.reset();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.tbsCertList = new ASN1Sequence(aSN1SequenceInputStream);
        this.sigAlgID = new AlgorithmIdentifier(aSN1SequenceInputStream);
        this.sigBytes = ASN1BitString.inputValue(aSN1SequenceInputStream);
        aSN1SequenceInputStream.terminate();
        ASN1SequenceInputStream aSN1SequenceInputStream2 = new ASN1SequenceInputStream(Utils.toStream(this.tbsCertList));
        if (aSN1SequenceInputStream2.getCurrentTag() == 2) {
            serializable = ASN1Integer.inputValue(aSN1SequenceInputStream2);
            this.version = ((BigInteger)serializable).intValue() + 1;
        }
        if (!((AlgorithmIdentifier)(serializable = new AlgorithmIdentifier(aSN1SequenceInputStream2))).equals(this.sigAlgID)) {
            throw new IOException("Inconsistent signature algorithm IDs");
        }
        X500Name x500Name = new X500Name(aSN1SequenceInputStream2);
        if (this.issuer == null) {
            this.issuer = x500Name;
        } else if (!this.issuer.equals(x500Name)) {
            throw new IOException("Expected issuer {" + this.issuer + "}, got issuer {" + x500Name + "}");
        }
        this.thisUpdate = ASN1Date.inputValue(aSN1SequenceInputStream2);
        this.nextUpdate = aSN1SequenceInputStream2.getCurrentTag() == 23 || aSN1SequenceInputStream2.getCurrentTag() == 24 ? ASN1Date.inputValue(aSN1SequenceInputStream2) : null;
        if (aSN1SequenceInputStream2.getCurrentTag() == 16) {
            aSN1ConstructedInputStream = new ASN1SequenceInputStream(aSN1SequenceInputStream2);
            this.revokedCertificates = new LinkedHashMap();
            while (aSN1ConstructedInputStream.hasMoreData()) {
                RevokedCertificate revokedCertificate = new RevokedCertificate(aSN1ConstructedInputStream);
                this.revokedCertificates.put(revokedCertificate.getSerialNo(), revokedCertificate);
            }
            aSN1ConstructedInputStream.terminate();
        } else {
            this.revokedCertificates = null;
        }
        if (aSN1SequenceInputStream2.getCurrentTag() == 0) {
            aSN1ConstructedInputStream = new ASN1ConstructedInputStream(aSN1SequenceInputStream2);
            this.extensions = new X509ExtensionSet(aSN1ConstructedInputStream);
            aSN1ConstructedInputStream.terminate();
        } else {
            this.extensions = null;
        }
        aSN1SequenceInputStream2.terminate();
    }

    private void reset() {
        this.resetContents();
        this.tbsCertList = null;
        this.sigBytes = null;
    }

    private void resetContents() {
        this.contents = null;
    }

    @Override
    public int length() {
        try {
            return this.toASN1Sequence().length();
        }
        catch (SignatureException signatureException) {
            throw new StreamableOutputException(signatureException.toString());
        }
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof CRL) {
            return this.equals((CRL)object);
        }
        return false;
    }

    private boolean equals(CRL cRL) {
        return Utils.areEqual(Utils.toBytes(this), Utils.toBytes(cRL));
    }

    public String toString() {
        String string = "issuer = " + this.issuer + ", thisUpdate = " + this.thisUpdate;
        if (this.nextUpdate != null) {
            string = string + ", nextUpdate = " + this.nextUpdate;
        }
        string = string + ", revokedCertificates = {";
        if (this.revokedCertificates != null) {
            Iterator<RevokedCertificate> iterator = this.revokedCertificates.values().iterator();
            while (iterator.hasNext()) {
                RevokedCertificate revokedCertificate = iterator.next();
                string = string + "(" + revokedCertificate + ")";
                if (!iterator.hasNext()) continue;
                string = string + ", ";
            }
        }
        string = string + "}";
        if (this.extensions != null && this.extensions.size() > 0) {
            string = string + ", extensions = " + this.extensions;
        }
        return string;
    }

    public byte[] getEncoded() {
        try {
            return Utils.toBytes(this.toASN1Sequence());
        }
        catch (SignatureException signatureException) {
            throw new StreamableOutputException(signatureException.toString());
        }
    }

    public Principal getIssuerDN() {
        return this.getIssuerX500Principal();
    }

    public X500Principal getIssuerX500Principal() {
        return this.getIssuer().toX500Principal();
    }

    public Date getNextUpdate() {
        return this.getNextDate();
    }

    public X509CRLEntry getRevokedCertificate(X509Certificate x509Certificate) {
        return null;
    }

    public String getSigAlgName() {
        return CryptoUtils.getSignatureAlg(this.sigAlgID);
    }

    public String getSigAlgOID() {
        return this.sigAlgID.getOID().toStringCompact();
    }

    public byte[] getSigAlgParams() {
        return Utils.toBytes(this.sigAlgID.getParameters());
    }

    public byte[] getSignature() {
        try {
            return this.getSigBytes();
        }
        catch (SignatureException signatureException) {
            throw new RuntimeException(signatureException);
        }
    }

    public byte[] getTBSCertList() throws CRLException {
        return Utils.toBytes(this.getTBSCertListSeq());
    }

    public Date getThisUpdate() {
        return this.getDate();
    }

    public int getVersion() {
        return this.version;
    }

    public int hashCode() {
        return Arrays.hashCode(Utils.toBytes(this));
    }

    public void verify(PublicKey publicKey, String string) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, java.security.SignatureException {
        Signature signature = string != null && !TransitionMode.isFIPS140ModeEnabled() ? Signature.getInstance(this.getSigAlgName(), string) : JCEUtil.getSignatureInstance(this.getSigAlgName());
        signature.initVerify(publicKey);
        signature.update(this.getTBSCertList());
        boolean bl2 = signature.verify(this.getSignature());
        if (!bl2) {
            throw new java.security.SignatureException("Public key does not match");
        }
    }

    public void verify(PublicKey publicKey) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, java.security.SignatureException {
        this.verify(publicKey, null);
    }

    public boolean isRevoked(Certificate certificate) {
        BigInteger bigInteger = ((X509Certificate)certificate).getSerialNumber();
        return bigInteger != null && this.revokedCertificates.containsKey(bigInteger);
    }

    public Set<String> getCriticalExtensionOIDs() {
        return this.extensions.getCriticalExtensionOIDs();
    }

    public byte[] getExtensionValue(String string) {
        return this.extensions.getExtensionValue(string);
    }

    public Set<String> getNonCriticalExtensionOIDs() {
        return this.extensions.getNonCriticalExtensionOIDs();
    }

    public boolean hasUnsupportedCriticalExtension() {
        return this.hasUnrecognizedCriticalExtension();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }

    public X509CRL toX509CRL() {
        return this.crlImpl;
    }

    class X509CRLImpl
    extends X509CRL {
        X509CRLImpl() {
        }

        @Override
        public boolean equals(Object object) {
            return CRL.this.equals(object);
        }

        @Override
        public byte[] getEncoded() throws CRLException {
            return CRL.this.getEncoded();
        }

        @Override
        public Principal getIssuerDN() {
            return CRL.this.getIssuerDN();
        }

        @Override
        public X500Principal getIssuerX500Principal() {
            return CRL.this.getIssuerX500Principal();
        }

        @Override
        public Date getNextUpdate() {
            return CRL.this.getNextUpdate();
        }

        @Override
        public X509CRLEntry getRevokedCertificate(BigInteger bigInteger) {
            return CRL.this.getRevokedCertificate(bigInteger);
        }

        @Override
        public X509CRLEntry getRevokedCertificate(X509Certificate x509Certificate) {
            return CRL.this.getRevokedCertificate(x509Certificate);
        }

        @Override
        public Set<? extends X509CRLEntry> getRevokedCertificates() {
            return new LinkedHashSet<RevokedCertificate>(CRL.this.getRevokedCertificatesAsList());
        }

        @Override
        public String getSigAlgName() {
            return CRL.this.getSigAlgName();
        }

        @Override
        public String getSigAlgOID() {
            return CRL.this.getSigAlgOID();
        }

        @Override
        public byte[] getSigAlgParams() {
            return CRL.this.getSigAlgParams();
        }

        @Override
        public byte[] getSignature() {
            return CRL.this.getSignature();
        }

        @Override
        public byte[] getTBSCertList() throws CRLException {
            return CRL.this.getTBSCertList();
        }

        @Override
        public Date getThisUpdate() {
            return CRL.this.getThisUpdate();
        }

        @Override
        public int getVersion() {
            return CRL.this.getVersion();
        }

        @Override
        public int hashCode() {
            return CRL.this.hashCode();
        }

        @Override
        public void verify(PublicKey publicKey, String string) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, java.security.SignatureException {
            CRL.this.verify(publicKey, string);
        }

        @Override
        public void verify(PublicKey publicKey) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, java.security.SignatureException {
            CRL.this.verify(publicKey);
        }

        @Override
        public boolean isRevoked(Certificate certificate) {
            return CRL.this.isRevoked(certificate);
        }

        @Override
        public String toString() {
            return CRL.this.toString();
        }

        @Override
        public Set<String> getCriticalExtensionOIDs() {
            return CRL.this.getCriticalExtensionOIDs();
        }

        @Override
        public byte[] getExtensionValue(String string) {
            return CRL.this.getExtensionValue(string);
        }

        @Override
        public Set<String> getNonCriticalExtensionOIDs() {
            return CRL.this.getNonCriticalExtensionOIDs();
        }

        @Override
        public boolean hasUnsupportedCriticalExtension() {
            return CRL.this.hasUnsupportedCriticalExtension();
        }

        public CRL toCRL() {
            return CRL.this;
        }
    }
}

