/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1BitString;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1GenericPrimitive;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.CRLDistPointName;
import oracle.security.crypto.cert.CRLReason;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class CRLDistPoint
implements Externalizable,
ASN1Object {
    private CRLDistPointName distPointName = null;
    private boolean[] reasons;
    private int reasonsCount;
    private ArrayList<GeneralName> crlIssuer = null;
    private transient ASN1Object contents = null;

    public CRLDistPoint() {
    }

    public CRLDistPoint(CRLDistPointName cRLDistPointName) {
        this.distPointName = cRLDistPointName;
    }

    public CRLDistPoint(GeneralName generalName) {
        this.crlIssuer = new ArrayList();
        this.crlIssuer.add(generalName);
    }

    public CRLDistPoint(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public void setDistPointName(CRLDistPointName cRLDistPointName) {
        this.distPointName = cRLDistPointName;
        this.update();
    }

    public CRLDistPointName getDistPointName() {
        return this.distPointName;
    }

    public boolean hasReasonFlag(CRLReason cRLReason) {
        int n2 = cRLReason.getValue();
        return this.reasons != null && n2 < this.reasons.length ? this.reasons[n2] : false;
    }

    public void setReasonFlag(CRLReason cRLReason) {
        this.doSetReasonFlag(cRLReason);
        this.update();
    }

    public void setReasonFlags(CRLReason[] cRLReasonArray) {
        int n2 = cRLReasonArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.doSetReasonFlag(cRLReasonArray[i2]);
        }
        this.update();
    }

    public void clearReasonFlag(CRLReason cRLReason) {
        int n2 = cRLReason.getValue();
        if (this.reasons != null && n2 < this.reasons.length) {
            this.reasons[n2] = false;
        }
        this.update();
    }

    public void clearAllReasonFlags() {
        if (this.reasons != null) {
            int n2 = this.reasons.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.reasons[i2] = false;
            }
            this.update();
        }
    }

    private void doSetReasonFlag(CRLReason cRLReason) {
        if (this.reasons == null || this.reasons.length < CRLReason.LIST.length) {
            boolean[] blArray = new boolean[CRLReason.LIST.length];
            if (this.reasons != null) {
                System.arraycopy(this.reasons, 0, blArray, 0, this.reasons.length);
            }
            this.reasons = blArray;
        }
        this.reasons[cRLReason.getValue()] = true;
        ++this.reasonsCount;
    }

    public void addCRLIssuerName(GeneralName generalName) {
        if (this.crlIssuer == null) {
            this.crlIssuer = new ArrayList();
        }
        this.crlIssuer.add(generalName);
        this.update();
    }

    @Deprecated
    public Vector<GeneralName> getCRLIssuerNames() {
        return this.crlIssuer == null ? null : new VectorOverArrayList<GeneralName>(this.crlIssuer);
    }

    public ArrayList<GeneralName> getCRLIssuerNamesAsList() {
        return this.crlIssuer;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        Object object;
        this.update();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        if (aSN1SequenceInputStream.hasMoreData() && aSN1SequenceInputStream.getCurrentTag() == 0) {
            object = new ASN1ConstructedInputStream((InputStream)aSN1SequenceInputStream, 0);
            this.distPointName = new CRLDistPointName((InputStream)object);
            ((ASN1ConstructedInputStream)object).terminate();
        } else {
            this.distPointName = null;
        }
        if (aSN1SequenceInputStream.hasMoreData() && aSN1SequenceInputStream.getCurrentTag() == 1) {
            int n2;
            aSN1SequenceInputStream.setCurrentTag(3);
            object = new ASN1BitString(aSN1SequenceInputStream);
            this.reasons = new boolean[((ASN1BitString)object).bitLength()];
            try {
                for (n2 = 0; n2 < this.reasons.length; ++n2) {
                    this.reasons[n2] = ((ASN1BitString)object).testBit(n2);
                    ++this.reasonsCount;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new ASN1FormatException("Unknown reasons flag: " + n2);
            }
        } else {
            this.reasons = null;
            this.reasonsCount = 0;
        }
        if (aSN1SequenceInputStream.hasMoreData() && aSN1SequenceInputStream.getCurrentTag() == 2) {
            aSN1SequenceInputStream.setCurrentTag(16);
            this.crlIssuer = new ArrayList();
            object = new ASN1SequenceInputStream(aSN1SequenceInputStream);
            while (((ASN1ConstructedInputStream)object).hasMoreData()) {
                this.crlIssuer.add(new GeneralName((InputStream)object));
            }
            ((ASN1ConstructedInputStream)object).terminate();
        } else {
            this.crlIssuer = null;
        }
        aSN1SequenceInputStream.terminate();
        if (this.distPointName == null && this.reasons == null && this.crlIssuer == null) {
            throw new ASN1FormatException("Empty DRLDistPoint input");
        }
    }

    private ASN1Object toASN1() {
        if (this.contents == null) {
            if (this.distPointName == null && this.reasons == null && this.crlIssuer == null) {
                throw new IllegalStateException("Invalid CRLDistPoint, all fields missing");
            }
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            if (this.distPointName != null) {
                aSN1Sequence.addElement(new ASN1GenericConstructed(this.distPointName, 0));
            }
            if (this.reasons != null && this.reasonsCount > 0) {
                ASN1BitString aSN1BitString = new ASN1BitString(this.reasons.length);
                for (int i2 = 0; i2 < this.reasons.length; ++i2) {
                    if (!this.reasons[i2]) continue;
                    aSN1BitString.setBit(i2);
                }
                aSN1Sequence.addElement(new ASN1GenericPrimitive(aSN1BitString, 1));
            }
            if (this.crlIssuer != null) {
                aSN1Sequence.addElement(new ASN1GenericConstructed(this.crlIssuer, 2));
            }
            this.contents = aSN1Sequence;
        }
        return this.contents;
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.toASN1().output(outputStream);
    }

    @Override
    public int length() {
        return this.toASN1().length();
    }

    private void update() {
        this.contents = null;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }
}

