/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cert.X500RDN;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class CRLDistPointName
implements Externalizable,
ASN1Object {
    private ArrayList<GeneralName> fullName;
    private X500RDN relativeName;
    private transient ASN1Object contents;

    public CRLDistPointName() {
    }

    public CRLDistPointName(GeneralName generalName) {
        this.fullName = new ArrayList();
        this.fullName.add(generalName);
    }

    public CRLDistPointName(Vector<? extends GeneralName> vector) {
        this.fullName = vector == null ? null : new ArrayList<GeneralName>(vector);
    }

    public CRLDistPointName(List<? extends GeneralName> list) {
        this.fullName = list == null ? null : new ArrayList<GeneralName>(list);
    }

    public CRLDistPointName(X500RDN x500RDN) {
        this.relativeName = x500RDN;
    }

    public CRLDistPointName(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public void addGeneralName(GeneralName generalName) {
        if (this.fullName == null) {
            this.fullName = new ArrayList();
        }
        this.fullName.add(generalName);
    }

    public Vector<GeneralName> getFullName() {
        return this.fullName == null ? null : new VectorOverArrayList<GeneralName>(this.fullName);
    }

    public ArrayList<GeneralName> getFullNameAsList() {
        return this.fullName;
    }

    public X500RDN getRelativeName() {
        return this.relativeName;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream);
        int n2 = pushbackInputStream.read();
        int n3 = ASN1Utils.getTag(n2);
        if (n3 == 0) {
            pushbackInputStream.unread((n2 & 0x20) + 16);
            if (this.fullName == null) {
                this.fullName = new ArrayList();
            } else {
                this.fullName.clear();
            }
            ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(pushbackInputStream);
            while (aSN1SequenceInputStream.hasMoreData()) {
                this.fullName.add(new GeneralName(aSN1SequenceInputStream));
            }
            aSN1SequenceInputStream.terminate();
            this.relativeName = null;
        } else if (n3 == 1) {
            pushbackInputStream.unread((n2 & 0x20) + 17);
            this.fullName = null;
            this.relativeName = new X500RDN(pushbackInputStream);
        }
        if ((this.fullName == null || this.fullName.size() == 0) && this.relativeName == null) {
            throw new ASN1FormatException("No name elements found in CRLDistPointName");
        }
    }

    private ASN1Object toASN1() {
        if (this.contents == null) {
            this.contents = this.fullName != null ? new ASN1GenericConstructed(this.fullName, 0) : ASN1Utils.addImplicitTag(this.relativeName, 1);
        }
        return this.contents;
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.toASN1().output(outputStream);
    }

    @Override
    public int length() {
        return this.toASN1().length();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }
}

