/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.ECPrivateKey;
import java.util.ArrayList;
import oracle.security.crypto.asn1.ASN1BitString;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.Attribute;
import oracle.security.crypto.cert.AttributeSet;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.cert.X509ExtensionSet;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.core.KeyPair;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.SignatureException;
import oracle.security.crypto.provider.JCEUtil;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.OutputGenerationException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class CertificateRequest
implements Externalizable,
ASN1Object {
    private X500Name subject;
    private oracle.security.crypto.core.PublicKey pubKey;
    private AttributeSet attributes;
    private ASN1Sequence certReqInfo;
    private PrivateKey privKey;
    private AlgorithmIdentifier sigAlgID;
    private byte[] sigBytes;
    private boolean useWrongFormat;
    private ASN1Sequence contents = null;

    public CertificateRequest() {
    }

    public CertificateRequest(X500Name x500Name, PublicKey publicKey, PrivateKey privateKey) {
        this(x500Name, publicKey, privateKey, false);
    }

    public CertificateRequest(X500Name x500Name, PublicKey publicKey, PrivateKey privateKey, boolean bl2) {
        this.subject = x500Name;
        this.pubKey = CryptoUtils.fromJCEPublicKey(publicKey);
        this.privKey = privateKey;
        this.useWrongFormat = bl2;
    }

    public CertificateRequest(X500Name x500Name, KeyPair keyPair) {
        this(x500Name, keyPair, false);
    }

    public CertificateRequest(X500Name x500Name, KeyPair keyPair, boolean bl2) {
        this.subject = x500Name;
        this.pubKey = keyPair.getPublic();
        this.privKey = keyPair.getPrivate();
        this.useWrongFormat = bl2;
    }

    public CertificateRequest(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public CertificateRequest(byte[] byArray) throws IOException {
        this(new UnsyncByteArrayInputStream(byArray));
    }

    public void sign() throws SignatureException {
        this.getCertReqInfo();
        try {
            if (this.sigAlgID == null) {
                if (this.privKey.getAlgorithm().equals("RSA")) {
                    this.sigAlgID = AlgID.sha256WithRSAEncryption;
                } else if (this.privKey.getAlgorithm().equals("DSA")) {
                    this.sigAlgID = AlgID.dsaWithSHA1;
                } else if (this.privKey.getAlgorithm().equals("EC")) {
                    int n2 = ((ECPrivateKey)this.privKey).getParams().getCurve().getField().getFieldSize();
                    switch (n2) {
                        case 256: {
                            this.sigAlgID = AlgID.ecdsaWithSHA256;
                            break;
                        }
                        case 384: {
                            this.sigAlgID = AlgID.ecdsaWithSHA384;
                            break;
                        }
                        case 512: {
                            this.sigAlgID = AlgID.ecdsaWithSHA512;
                            break;
                        }
                        default: {
                            this.sigAlgID = AlgID.ecdsaWithSHA1;
                        }
                    }
                }
            }
            Signature signature = JCEUtil.getSignatureInstance(CryptoUtils.getSignatureAlg(this.sigAlgID));
            signature.initSign(this.privKey);
            signature.update(Utils.toBytes(this.certReqInfo));
            this.sigBytes = signature.sign();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SignatureException(noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SignatureException(invalidKeyException);
        }
        catch (java.security.SignatureException signatureException) {
            throw new SignatureException(signatureException);
        }
        this.reset();
    }

    public void sign(RandomBitsSource randomBitsSource) throws SignatureException {
        this.sign();
    }

    public byte[] getSigBytes() throws SignatureException {
        if (this.sigBytes == null) {
            this.sign();
        }
        return this.sigBytes;
    }

    private ASN1Sequence getCertReqInfo() {
        if (this.certReqInfo == null) {
            this.certReqInfo = new ASN1Sequence();
            this.certReqInfo.addElement(new ASN1Integer(0L));
            this.certReqInfo.addElement(this.subject);
            this.certReqInfo.addElement(CryptoUtils.subjectPublicKeyInfo(this.pubKey));
            if (this.attributes != null) {
                this.certReqInfo.addElement(new ASN1GenericConstructed(this.attributes.toASN1Set().elementsAsList(), 0));
            } else if (!this.useWrongFormat) {
                this.certReqInfo.addElement(new ASN1GenericConstructed(new ArrayList(), 0));
            }
        }
        return this.certReqInfo;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.resetAll();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.certReqInfo = new ASN1Sequence(aSN1SequenceInputStream);
        this.sigAlgID = new AlgorithmIdentifier(aSN1SequenceInputStream);
        this.sigBytes = ASN1BitString.inputValue(aSN1SequenceInputStream);
        aSN1SequenceInputStream.terminate();
        aSN1SequenceInputStream = new ASN1SequenceInputStream(Utils.toStream(this.certReqInfo));
        int n2 = ASN1Integer.inputValue(aSN1SequenceInputStream).intValue();
        if (n2 != 0) {
            throw new ASN1FormatException("Expected version 0, got " + n2);
        }
        this.subject = new X500Name(aSN1SequenceInputStream);
        this.pubKey = CryptoUtils.inputSPKI(aSN1SequenceInputStream);
        if (aSN1SequenceInputStream.hasMoreData()) {
            if (aSN1SequenceInputStream.getCurrentTag() == 0) {
                aSN1SequenceInputStream.setCurrentTag(17);
                this.attributes = new AttributeSet(aSN1SequenceInputStream);
            } else {
                throw new ASN1FormatException("Expected tag 0, got " + aSN1SequenceInputStream.getCurrentTag());
            }
        }
        aSN1SequenceInputStream.terminate();
        try {
            this.verifySignature();
        }
        catch (AuthenticationException authenticationException) {
            throw new IOException(authenticationException);
        }
    }

    public boolean verifySignature() throws AuthenticationException {
        try {
            Signature signature = JCEUtil.getSignatureInstance(CryptoUtils.getSignatureAlg(this.sigAlgID));
            signature.initVerify(this.pubKey);
            signature.update(Utils.toBytes(this.certReqInfo));
            return signature.verify(this.sigBytes);
        }
        catch (java.security.SignatureException signatureException) {
            throw new AuthenticationException(signatureException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AuthenticationException(noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new AuthenticationException(invalidKeyException);
        }
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        try {
            this.toASN1Sequence().output(outputStream);
        }
        catch (SignatureException signatureException) {
            throw new OutputGenerationException(signatureException);
        }
    }

    @Override
    public int length() {
        try {
            return this.toASN1Sequence().length();
        }
        catch (SignatureException signatureException) {
            return 0;
        }
    }

    ASN1Sequence toASN1Sequence() throws SignatureException {
        if (this.contents == null) {
            this.getSigBytes();
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(this.certReqInfo);
            aSN1Sequence.addElement(this.sigAlgID);
            aSN1Sequence.addElement(new ASN1BitString(this.sigBytes));
            this.contents = aSN1Sequence;
        }
        return this.contents;
    }

    private void reset() {
        this.contents = null;
    }

    private void resetAll() {
        this.reset();
        this.certReqInfo = null;
        this.sigBytes = null;
    }

    public void setSubject(X500Name x500Name) {
        this.subject = x500Name;
        this.resetAll();
    }

    public X500Name getSubject() {
        return this.subject;
    }

    public void setPublicKey(oracle.security.crypto.core.PublicKey publicKey) {
        this.setPublicKey((PublicKey)publicKey);
    }

    public oracle.security.crypto.core.PublicKey getPublicKey() {
        return this.pubKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.pubKey = CryptoUtils.fromJCEPublicKey(publicKey);
        this.resetAll();
    }

    public void setPrivateKey(oracle.security.crypto.core.PrivateKey privateKey) {
        this.setPrivateKey(privateKey, null);
    }

    public void setPrivateKey(oracle.security.crypto.core.PrivateKey privateKey, AlgorithmIdentifier algorithmIdentifier) {
        this.privKey = privateKey;
        this.setSigAlgID(algorithmIdentifier);
    }

    public void setPrivateKey(PrivateKey privateKey, AlgorithmIdentifier algorithmIdentifier) {
        this.privKey = privateKey;
        this.setSigAlgID(algorithmIdentifier);
    }

    public void setSigAlgID(AlgorithmIdentifier algorithmIdentifier) {
        this.sigAlgID = algorithmIdentifier;
        this.resetAll();
    }

    public AlgorithmIdentifier getSigAlgID() {
        return this.sigAlgID;
    }

    public Attribute addAttribute(ASN1ObjectID aSN1ObjectID, ASN1Object aSN1Object) {
        return this.addAttribute(new Attribute(aSN1ObjectID, aSN1Object));
    }

    public Attribute addAttribute(Attribute attribute) {
        this.resetAll();
        if (this.attributes == null) {
            this.attributes = new AttributeSet();
        }
        return this.attributes.addAttribute(attribute);
    }

    public Attribute getAttribute(ASN1ObjectID aSN1ObjectID) {
        return this.attributes != null ? this.attributes.getAttribute(aSN1ObjectID) : null;
    }

    public AttributeSet getAttributes() {
        return this.attributes;
    }

    public X509Extension addExtension(X509Extension x509Extension) {
        X509ExtensionSet x509ExtensionSet = this.getExtensions();
        if (x509ExtensionSet == null) {
            x509ExtensionSet = new X509ExtensionSet();
        }
        X509Extension x509Extension2 = x509ExtensionSet.getExtension(x509Extension.getType());
        x509ExtensionSet.addExtension(x509Extension);
        this.setExtensions(x509ExtensionSet);
        return x509Extension2;
    }

    public X509ExtensionSet setExtensions(X509ExtensionSet x509ExtensionSet) {
        Attribute attribute = this.addAttribute(PKIX.extensionRequest, x509ExtensionSet);
        if (attribute != null) {
            try {
                return new X509ExtensionSet(Utils.toStream(attribute.getValuesAsList().get(0)));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return null;
    }

    public X509ExtensionSet getExtensions() {
        Attribute attribute = this.getAttribute(PKIX.extensionRequest);
        if (attribute != null) {
            try {
                return new X509ExtensionSet(Utils.toStream(attribute.getValuesAsList().get(0)));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return null;
    }

    public void setUseWrongFormat(boolean bl2) {
        this.useWrongFormat = bl2;
        this.resetAll();
    }

    public boolean getUseWrongFormat() {
        return this.useWrongFormat;
    }

    public String toString() {
        return "subject = " + this.subject + ", pubKey = " + this.pubKey;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }
}

