/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Serializable;
import java.util.Date;

public class CertificateStatus
implements Serializable {
    public static final int UNKNOWN = 0;
    public static final int VALID = 1;
    public static final int INVALID = 2;
    public static final int REVOKED = 3;
    public static final int EXPIRED = 4;
    public static final int ON_HOLD = 5;
    protected static final String[] statusCodeStrs = new String[]{"UNKNOWN", "VALID", "INVALID", "REVOKED", "EXPIRED", "ON_HOLD"};
    protected int statusCode = 0;
    protected String reason;
    protected Date revocationDate;

    public CertificateStatus() {
    }

    public CertificateStatus(int n2) {
        this.statusCode = n2;
    }

    public CertificateStatus(int n2, String string) {
        this(n2);
        this.reason = string;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusCodeString() {
        if (this.statusCode >= 0 && this.statusCode < statusCodeStrs.length) {
            return statusCodeStrs[this.statusCode];
        }
        return "UNKNOWN";
    }

    public void setStatusCode(int n2) {
        this.statusCode = n2;
    }

    public void setStatusCode(String string) {
        int n2;
        int n3 = statusCodeStrs.length;
        for (n2 = 0; n2 < n3 && !string.equals(statusCodeStrs[n2]); ++n2) {
        }
        this.statusCode = n2 >= statusCodeStrs.length ? 0 : n2;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String string) {
        this.reason = string;
    }

    public Date getRevocationDate() {
        return this.revocationDate;
    }

    public void setRevocationDate(Date date) {
        this.revocationDate = date;
    }

    public String toString() {
        String string = "";
        string = string + this.getStatusCodeString();
        if (this.reason != null && this.reason.length() > 0) {
            string = string + ", reason = " + this.reason;
        }
        if (this.revocationDate != null) {
            string = string + ", revocationDate = " + this.revocationDate;
        }
        return string;
    }
}

