/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.List;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1String;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class GeneralName
implements Externalizable,
ASN1Object {
    private Type type;
    private ASN1Object value;
    private ASN1Object contents = null;

    public GeneralName() {
    }

    public GeneralName(Type type, ASN1Object aSN1Object) {
        try {
            this.initialize(type, aSN1Object);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.toString());
        }
    }

    public GeneralName(Type type, String string) {
        this(type, new ASN1String(string, 22));
    }

    public GeneralName(X500Name x500Name) {
        this(Type.DIRECTORY_NAME, x500Name);
    }

    public GeneralName(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    private void initialize(Type type, ASN1Object aSN1Object) throws IOException {
        if (type == Type.OTHER_NAME) {
            ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(Utils.toStream(aSN1Object));
            new ASN1ObjectID(aSN1SequenceInputStream);
            new ASN1ConstructedInputStream((InputStream)aSN1SequenceInputStream, 0);
        } else if (type == Type.RFC822_NAME || type == Type.DNS_NAME || type == Type.URI) {
            if (!(aSN1Object instanceof ASN1String)) {
                throw new ASN1FormatException("Invalid value for " + type);
            }
            if (((ASN1String)aSN1Object).getTag() != 22) {
                throw new ASN1FormatException("Invalid value for " + type);
            }
        } else if (type == Type.IP_ADDRESS) {
            if (!(aSN1Object instanceof ASN1OctetString)) {
                throw new ASN1FormatException("Invalid value for " + type);
            }
        } else if (type == Type.X400_ADDRESS || type == Type.DIRECTORY_NAME || type == Type.EDI_PARTY_NAME) {
            new ASN1Sequence(Utils.toStream(aSN1Object));
        } else if (type == Type.REGISTERED_ID) {
            new ASN1ObjectID(Utils.toStream(aSN1Object));
        }
        this.contents = null;
        this.type = type;
        this.value = aSN1Object;
    }

    public Type getType() {
        return this.type;
    }

    public ASN1Object getValue() {
        return this.value;
    }

    public List<?> getTypeAndValue() {
        ArrayList<Object> arrayList = new ArrayList<Object>(2);
        arrayList.add(new Integer(this.type.tag));
        if (this.value instanceof ASN1String) {
            arrayList.add(((ASN1String)this.value).getValue());
        } else if (this.value instanceof ASN1ObjectID) {
            arrayList.add(((ASN1ObjectID)this.value).toStringCompact());
        } else if (this.value instanceof X500Name) {
            arrayList.add(((X500Name)this.value).toString());
        } else {
            arrayList.add(Utils.toBytes(this.value));
        }
        return arrayList;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() == object.getClass()) {
            GeneralName generalName = (GeneralName)object;
            if (this.type == generalName.type) {
                return Utils.areEqual(Utils.toBytes(this.value), Utils.toBytes(generalName.value));
            }
            return false;
        }
        if (object instanceof ASN1Object) {
            return Utils.areEqual(Utils.toBytes(this.value), Utils.toBytes((ASN1Object)object));
        }
        return false;
    }

    public String toString() {
        if (this.value == null) {
            return "";
        }
        return "{ " + this.type + ": " + this.value + " }";
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        ASN1Object aSN1Object;
        Type type;
        PushbackInputStream pushbackInputStream = inputStream instanceof PushbackInputStream ? (PushbackInputStream)inputStream : new PushbackInputStream(inputStream);
        int n2 = pushbackInputStream.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        int n3 = n2 & 0x20;
        switch (n2 & 0x1F) {
            case 0: {
                type = Type.OTHER_NAME;
                pushbackInputStream.unread(n3 | 0x10);
                aSN1Object = new ASN1Sequence(pushbackInputStream);
                break;
            }
            case 1: {
                type = Type.RFC822_NAME;
                pushbackInputStream.unread(n3 | 0x16);
                aSN1Object = new ASN1String(pushbackInputStream);
                break;
            }
            case 2: {
                type = Type.DNS_NAME;
                pushbackInputStream.unread(n3 | 0x16);
                aSN1Object = new ASN1String(pushbackInputStream);
                break;
            }
            case 3: {
                type = Type.X400_ADDRESS;
                pushbackInputStream.unread(n3 | 0x10);
                aSN1Object = new ASN1Sequence(pushbackInputStream);
                break;
            }
            case 4: {
                type = Type.DIRECTORY_NAME;
                pushbackInputStream.unread(n2);
                ASN1ConstructedInputStream aSN1ConstructedInputStream = new ASN1ConstructedInputStream((InputStream)pushbackInputStream, 4);
                aSN1Object = new X500Name(aSN1ConstructedInputStream);
                aSN1ConstructedInputStream.terminate();
                break;
            }
            case 5: {
                type = Type.EDI_PARTY_NAME;
                pushbackInputStream.unread(n3 | 0x10);
                aSN1Object = new ASN1Sequence(pushbackInputStream);
                break;
            }
            case 6: {
                type = Type.URI;
                pushbackInputStream.unread(n3 | 0x16);
                aSN1Object = new ASN1String(pushbackInputStream);
                break;
            }
            case 7: {
                type = Type.IP_ADDRESS;
                pushbackInputStream.unread(n3 | 4);
                aSN1Object = new ASN1OctetString(pushbackInputStream);
                break;
            }
            case 8: {
                type = Type.REGISTERED_ID;
                pushbackInputStream.unread(n3 | 6);
                aSN1Object = new ASN1ObjectID(pushbackInputStream);
                break;
            }
            default: {
                throw new ASN1FormatException("Unrecognized tag for GeneralName");
            }
        }
        this.initialize(type, aSN1Object);
    }

    private ASN1Object getContents() {
        if (this.contents == null) {
            switch (this.type.getTag()) {
                case 4: {
                    this.contents = new ASN1GenericConstructed(this.value, this.type.getTag());
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    this.contents = ASN1Utils.addImplicitTag(this.value, this.type.getTag());
                    break;
                }
            }
        }
        return this.contents;
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.getContents().output(outputStream);
    }

    @Override
    public int length() {
        return this.getContents().length();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }

    public static class Type {
        public static final Type OTHER_NAME = new Type(0, "otherName");
        public static final Type RFC822_NAME = new Type(1, "rfc822Name");
        public static final Type DNS_NAME = new Type(2, "dNSName");
        public static final Type X400_ADDRESS = new Type(3, "x400Address");
        public static final Type DIRECTORY_NAME = new Type(4, "directoryName");
        public static final Type EDI_PARTY_NAME = new Type(5, "ediPartyName");
        public static final Type URI = new Type(6, "uniformResourceIdentifier");
        public static final Type IP_ADDRESS = new Type(7, "iPAddress");
        public static final Type REGISTERED_ID = new Type(8, "registeredID");
        private int tag;
        private String name;

        private Type(int n2, String string) {
            this.tag = n2;
            this.name = string;
        }

        private int getTag() {
            return this.tag;
        }

        public String toString() {
            return this.name;
        }
    }
}

