/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1String;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class GeneralNames
implements Externalizable,
ASN1Object {
    private ArrayList<GeneralName> gns = new ArrayList();
    private ASN1Sequence contents;

    public GeneralNames() {
    }

    public GeneralNames(Vector<GeneralName> vector) {
        this((List<GeneralName>)vector);
    }

    public GeneralNames(List<GeneralName> list) {
        this.addGeneralNames(list);
    }

    public GeneralNames(GeneralName generalName) {
        this.addGeneralName(generalName);
    }

    public GeneralNames(X500Name x500Name) {
        this(x500Name, null);
    }

    public GeneralNames(String string) {
        this(null, string);
    }

    public GeneralNames(X500Name x500Name, String string) {
        if (x500Name != null) {
            this.addGeneralName(x500Name);
        }
        if (string != null) {
            this.addGeneralName(string);
        }
    }

    public GeneralNames(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public void addGeneralName(X500Name x500Name) {
        if (x500Name != null) {
            this.addGeneralName(new GeneralName(x500Name));
        }
    }

    public void addGeneralName(String string) {
        if (string != null) {
            this.addGeneralName(new GeneralName(GeneralName.Type.RFC822_NAME, string));
        }
    }

    public void addGeneralName(GeneralName generalName) {
        if (generalName != null) {
            this.gns.add(generalName);
            this.clearContents();
        }
    }

    public void addGeneralNames(Vector<GeneralName> vector) {
        this.addGeneralNames((List<GeneralName>)vector);
    }

    public void addGeneralNames(List<GeneralName> list) {
        if (list != null) {
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.gns.add(list.get(i2));
            }
            this.clearContents();
        }
    }

    public boolean removeGeneralName(X500Name x500Name) {
        if (x500Name != null) {
            return this.removeGeneralName(new GeneralName(x500Name));
        }
        return false;
    }

    public boolean removeGeneralName(String string) {
        if (string != null) {
            return this.removeGeneralName(new GeneralName(GeneralName.Type.RFC822_NAME, string));
        }
        return false;
    }

    public boolean removeGeneralName(GeneralName generalName) {
        boolean bl2 = false;
        if (generalName != null) {
            bl2 = this.gns.remove(generalName);
            if (bl2) {
                // empty if block
            }
            this.clearContents();
        }
        return bl2;
    }

    public GeneralName removeGeneralName(int n2) {
        GeneralName generalName = this.gns.get(n2);
        this.gns.remove(n2);
        this.clearContents();
        return generalName;
    }

    public boolean removeGeneralNames(Vector<GeneralName> vector) {
        return this.removeGeneralNames((List<GeneralName>)vector);
    }

    public boolean removeGeneralNames(List<GeneralName> list) {
        boolean bl2 = false;
        if (list != null && list.size() != 0) {
            boolean bl3 = false;
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                bl3 = this.gns.remove(list.get(i2));
                if (bl2) continue;
                bl2 = bl3;
            }
        }
        if (bl2) {
            this.clearContents();
        }
        return bl2;
    }

    public GeneralName generalNameAt(int n2) {
        return this.gns.get(n2);
    }

    public int size() {
        return this.gns.size();
    }

    public boolean containsGeneralName(GeneralName generalName) {
        if (generalName == null || this.gns == null || this.gns.size() < 1) {
            return false;
        }
        return this.gns.contains(generalName);
    }

    public String toString() {
        if (this.gns == null || this.gns.size() < 1) {
            return "General Names: 0 Elements\n";
        }
        StringBuffer stringBuffer = new StringBuffer("GeneralNames: " + this.gns.size() + " Elements\n");
        int n2 = this.gns.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(i2 + ". " + this.gns.get(i2) + "\n");
        }
        return stringBuffer.toString();
    }

    @Deprecated
    public Vector<GeneralName> getGeneralNames() {
        return this.gns == null ? null : new VectorOverArrayList<GeneralName>(this.gns);
    }

    public ArrayList<GeneralName> getGeneralNamesAsList() {
        return this.gns;
    }

    public Enumeration<GeneralName> generalNames() {
        if (this.gns == null) {
            return new Vector().elements();
        }
        return new VectorOverArrayList<GeneralName>(this.gns).elements();
    }

    public ArrayList<String> getRFC822NamesAsList() {
        if (this.gns == null || this.gns.size() < 1) {
            return null;
        }
        ArrayList<String> arrayList = null;
        int n2 = this.gns.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            GeneralName generalName = this.gns.get(i2);
            if (!generalName.getType().equals(GeneralName.Type.RFC822_NAME)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(((ASN1String)generalName.getValue()).getValue());
        }
        return arrayList;
    }

    @Deprecated
    public Vector<String> getRFC822Names() {
        ArrayList<String> arrayList = this.getRFC822NamesAsList();
        return arrayList == null ? null : new VectorOverArrayList<String>(arrayList);
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.clearContents();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        if (aSN1SequenceInputStream.hasMoreData()) {
            this.gns = new ArrayList();
            while (aSN1SequenceInputStream.hasMoreData()) {
                this.gns.add(new GeneralName(aSN1SequenceInputStream));
            }
        }
        aSN1SequenceInputStream.terminate();
        if (this.gns == null || this.gns.size() < 1) {
            throw new IOException("General Names can not be Empty");
        }
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        if (this.gns == null || this.gns.size() < 1) {
            throw new IOException("General Names is Empty");
        }
        this.toASN1Sequence().output(outputStream);
    }

    @Override
    public int length() {
        return this.toASN1Sequence().length();
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.contents == null) {
            this.contents = new ASN1Sequence((List<? extends ASN1Object>)this.gns);
        }
        return this.contents;
    }

    private void clearContents() {
        this.contents = null;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }
}

