/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.math.BigInteger;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public final class IssuerAndSerialNo
implements Externalizable,
ASN1Object {
    private X500Name issuer;
    private BigInteger serialNo;
    private ASN1Sequence contents;

    public IssuerAndSerialNo() {
    }

    public IssuerAndSerialNo(X500Name x500Name, BigInteger bigInteger) {
        this.issuer = x500Name;
        this.serialNo = bigInteger;
    }

    public IssuerAndSerialNo(X509 x509) {
        this(x509.getIssuer(), x509.getSerialNo());
    }

    public IssuerAndSerialNo(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public X500Name getIssuer() {
        return this.issuer;
    }

    public BigInteger getSerialNo() {
        return this.serialNo;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof IssuerAndSerialNo)) {
            return false;
        }
        IssuerAndSerialNo issuerAndSerialNo = (IssuerAndSerialNo)object;
        return Utils.areEqual(this.getEncoded(), issuerAndSerialNo.getEncoded());
    }

    public int hashCode() {
        return new String(this.getEncoded()).hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        stringBuffer.append("issuer = ");
        stringBuffer.append(this.issuer != null ? this.issuer.toString() : "null");
        stringBuffer.append(", serialNo = ");
        stringBuffer.append(this.serialNo != null ? this.serialNo.toString() : "null");
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.issuer = new X500Name(aSN1SequenceInputStream);
        this.serialNo = ASN1Integer.inputValue(aSN1SequenceInputStream);
        aSN1SequenceInputStream.terminate();
        this.update();
    }

    public byte[] getEncoded() {
        return Utils.toBytes(this);
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.toASN1Sequence().output(outputStream);
    }

    @Override
    public int length() {
        return this.toASN1Sequence().length();
    }

    private void update() {
        this.contents = null;
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.contents == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(this.issuer);
            aSN1Sequence.addElement(new ASN1Integer(this.serialNo));
            this.contents = aSN1Sequence;
        }
        return this.contents;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }
}

