/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.cert.PKCS12;
import oracle.security.crypto.cert.PKCS12Bag;
import oracle.security.crypto.cert.PKCS12CertBag;
import oracle.security.crypto.cert.PKCS12Safe;
import oracle.security.crypto.cert.PKCS12ShroudedKeyBag;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.MessageDigest;
import oracle.security.crypto.core.PBEAlgorithmIdentifier;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.PrivateKeyPKCS8;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.VectorOverArrayList;

public class KeyPairPKCS12
extends PKCS12 {
    private ArrayList<X509> orderedCertChain = null;

    public KeyPairPKCS12() {
    }

    public KeyPairPKCS12(PrivateKeyPKCS8 privateKeyPKCS8, Vector<X509> vector, int n2) {
        this(privateKeyPKCS8, vector, KeyPairPKCS12.transformMode(n2));
    }

    public KeyPairPKCS12(PrivateKeyPKCS8 privateKeyPKCS8, Vector<X509> vector, ASN1ObjectID aSN1ObjectID) {
        this(privateKeyPKCS8, vector, aSN1ObjectID, (String)null);
    }

    public KeyPairPKCS12(PrivateKeyPKCS8 privateKeyPKCS8, Vector<X509> vector, int n2, String string) {
        this(privateKeyPKCS8, vector, KeyPairPKCS12.transformMode(n2), string);
    }

    public KeyPairPKCS12(PrivateKeyPKCS8 privateKeyPKCS8, Vector<X509> vector, ASN1ObjectID aSN1ObjectID, String string) {
        this(privateKeyPKCS8, (List<X509>)vector, aSN1ObjectID, string);
    }

    public KeyPairPKCS12(PrivateKeyPKCS8 privateKeyPKCS8, List<X509> list, ASN1ObjectID aSN1ObjectID, String string) {
        Object object;
        Externalizable externalizable;
        byte[] byArray = null;
        if (list != null && list.size() > 0) {
            externalizable = list.get(0);
            object = null;
            try {
                object = MessageDigest.getInstance(AlgID.sha_1);
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new RuntimeException("SHA1 class not found. " + algorithmIdentifierException.toString());
            }
            byArray = ((MessageDigest)object).computeDigest(((X509)externalizable).getEncoded());
        }
        if (privateKeyPKCS8 != null) {
            externalizable = new PKCS12Safe((PKCS12)this, (ASN1ObjectID)null);
            object = new PKCS12ShroudedKeyBag((PKCS12Safe)externalizable, privateKeyPKCS8);
            if (byArray != null) {
                ((PKCS12Bag)object).setLocalKeyID(byArray);
            }
            if (string != null) {
                ((PKCS12Bag)object).setFriendlyName(string);
            }
            ((PKCS12Safe)externalizable).addBag((PKCS12Bag)object);
            this.addAuthSafe((PKCS12Safe)externalizable);
        }
        if (list != null && list.size() > 0) {
            externalizable = new PKCS12Safe((PKCS12)this, aSN1ObjectID);
            for (int i2 = list.size() - 1; i2 > 0; --i2) {
                ((PKCS12Safe)externalizable).addBag(new PKCS12CertBag((PKCS12Safe)externalizable, list.get(i2)));
            }
            X509 x509 = list.get(0);
            PKCS12CertBag pKCS12CertBag = new PKCS12CertBag((PKCS12Safe)externalizable, x509);
            if (byArray != null) {
                pKCS12CertBag.setLocalKeyID(byArray);
            }
            if (string != null) {
                pKCS12CertBag.setFriendlyName(string);
            }
            ((PKCS12Safe)externalizable).addBag(pKCS12CertBag);
            this.addAuthSafe((PKCS12Safe)externalizable);
        }
    }

    public KeyPairPKCS12(String string, PrivateKeyPKCS8 privateKeyPKCS8, Vector<X509> vector, int n2) {
        this(string, privateKeyPKCS8, vector, KeyPairPKCS12.transformMode(n2));
    }

    public KeyPairPKCS12(String string, PrivateKeyPKCS8 privateKeyPKCS8, Vector<X509> vector, ASN1ObjectID aSN1ObjectID) {
        this(string, privateKeyPKCS8, vector, aSN1ObjectID, (String)null);
    }

    public KeyPairPKCS12(String string, PrivateKeyPKCS8 privateKeyPKCS8, Vector<X509> vector, int n2, String string2) {
        this(string, privateKeyPKCS8, vector, KeyPairPKCS12.transformMode(n2), string2);
    }

    public KeyPairPKCS12(String string, PrivateKeyPKCS8 privateKeyPKCS8, Vector<X509> vector, ASN1ObjectID aSN1ObjectID, String string2) {
        this(string, privateKeyPKCS8, (List<X509>)vector, aSN1ObjectID, string2);
    }

    public KeyPairPKCS12(String string, PrivateKeyPKCS8 privateKeyPKCS8, List<X509> list, ASN1ObjectID aSN1ObjectID, String string2) {
        this(privateKeyPKCS8, list, aSN1ObjectID, string2);
        this.setPassword(string);
    }

    public KeyPairPKCS12(String string, InputStream inputStream) throws IOException {
        super(string, inputStream);
        this.orderCertificateChain();
    }

    public KeyPairPKCS12(String string, ASN1Sequence aSN1Sequence) throws IOException {
        super(string, aSN1Sequence);
        this.orderCertificateChain();
    }

    private static ASN1ObjectID transformMode(int n2) {
        if (n2 == -2) {
            return PBEAlgorithmIdentifier.pbeWithMD2AndDES_CBC;
        }
        if (n2 == -1) {
            return PBEAlgorithmIdentifier.pbeWithMD5AndDES_CBC;
        }
        if (n2 == 0) {
            return null;
        }
        return new ASN1ObjectID(PBEAlgorithmIdentifier.pkcs12PBEids, n2);
    }

    @Override
    public void input(ASN1Sequence aSN1Sequence) throws IOException {
        super.input(aSN1Sequence);
        this.orderedCertChain = null;
        this.orderCertificateChain();
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        super.input(inputStream);
        this.orderedCertChain = null;
        this.orderCertificateChain();
    }

    private PKCS12ShroudedKeyBag getShroudedKeyBag() {
        for (PKCS12Safe pKCS12Safe : this.getAuthSafesAsList()) {
            for (PKCS12Bag pKCS12Bag : pKCS12Safe.getBagsAsList()) {
                if (!(pKCS12Bag instanceof PKCS12ShroudedKeyBag)) continue;
                return (PKCS12ShroudedKeyBag)pKCS12Bag;
            }
        }
        return null;
    }

    public PrivateKeyPKCS8 getPrivateKeyPKCS8() {
        PKCS12ShroudedKeyBag pKCS12ShroudedKeyBag = this.getShroudedKeyBag();
        if (pKCS12ShroudedKeyBag != null) {
            return pKCS12ShroudedKeyBag.getPKCS8();
        }
        return null;
    }

    public PrivateKey getPrivateKey() {
        PKCS12ShroudedKeyBag pKCS12ShroudedKeyBag = this.getShroudedKeyBag();
        if (pKCS12ShroudedKeyBag != null) {
            return pKCS12ShroudedKeyBag.getPrivateKey();
        }
        return null;
    }

    public PrivateKey getPrivateKey(String string) {
        PrivateKeyPKCS8 privateKeyPKCS8 = this.getPrivateKeyPKCS8();
        if (privateKeyPKCS8 != null) {
            privateKeyPKCS8.setPassword(string);
            return privateKeyPKCS8.getKey();
        }
        return null;
    }

    @Deprecated
    public Vector<X509> getCertificateChain() {
        return this.orderedCertChain == null ? null : new VectorOverArrayList<X509>(this.orderedCertChain);
    }

    public ArrayList<X509> getCertificateChainAsList() {
        return this.orderedCertChain;
    }

    public X509 getBottomCert() {
        ArrayList<X509> arrayList = this.getCertificateChainAsList();
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.get(0);
    }

    /*
     * WARNING - void declaration
     */
    private void orderCertificateChain() throws InvalidInputException {
        Object object;
        if (this.orderedCertChain != null) {
            return;
        }
        LinkedHashMap<X500Name, X509> linkedHashMap = new LinkedHashMap<X500Name, X509>();
        LinkedHashMap<X500Name, X509> linkedHashMap2 = new LinkedHashMap<X500Name, X509>();
        int n2 = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        LinkedHashMap<Object, Object> linkedHashMap3 = new LinkedHashMap<Object, Object>();
        for (PKCS12Safe aSN1Object : this.getAuthSafesAsList()) {
            for (PKCS12Bag pKCS12Bag : aSN1Object.getBagsAsList()) {
                if (!(pKCS12Bag instanceof PKCS12CertBag)) continue;
                X509 x509 = ((PKCS12CertBag)pKCS12Bag).getCert();
                if (x509.getIssuer().equals(x509.getSubject())) {
                    arrayList.add(x509);
                    linkedHashMap3.put(x509, x509);
                } else {
                    if (linkedHashMap.put(x509.getIssuer(), x509) != null) {
                        throw new InvalidInputException("Multiple certificates with same issuer");
                    }
                    if (linkedHashMap2.put(x509.getSubject(), x509) != null) {
                        throw new InvalidInputException("Multiple certificates with same subject");
                    }
                }
                ++n2;
            }
        }
        if (arrayList.size() == 0 && linkedHashMap.size() > 0) {
            object = (X509)linkedHashMap.values().iterator().next();
            if (object != null) {
                arrayList.add(object);
                linkedHashMap3.put(object, object);
            }
        } else if (arrayList.size() > 1) {
            throw new InvalidInputException("Certificate chain contains more than 1 self-signed cert");
        }
        if (arrayList.size() == 1) {
            void var7_9;
            object = (X509)arrayList.get(0);
            X509 x509 = (X509)linkedHashMap2.get(((X509)object).getIssuer());
            Object object2 = (X509)linkedHashMap.get(((X509)object).getSubject());
            while (var7_9 != null) {
                if (linkedHashMap3.put(var7_9, var7_9) != null) {
                    throw new InvalidInputException("Certificate chain contains a cycle");
                }
                arrayList.add(var7_9);
                X509 x5092 = (X509)linkedHashMap2.get(var7_9.getIssuer());
            }
            while (object2 != null) {
                if (linkedHashMap3.put(object2, object2) != null) {
                    throw new InvalidInputException("Certificate chain contains a cycle");
                }
                arrayList.add(0, object2);
                object2 = (X509)linkedHashMap.get(((X509)object2).getSubject());
            }
            if (arrayList.size() != n2) {
                throw new InvalidInputException("Certificate chain cannot be ordered");
            }
        }
        this.orderedCertChain = arrayList;
    }
}

