/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.PKCS12Safe;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.core.CipherException;
import oracle.security.crypto.core.DigestInfo;
import oracle.security.crypto.core.math.BigInt;
import oracle.security.crypto.provider.JCEUtil;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class PKCS12
implements Externalizable,
ASN1Object {
    private ArrayList<PKCS12Safe> authSafes = new ArrayList();
    private char[] passwd;
    private byte[] toBeMacedData;
    private AlgorithmIdentifier macAlg;
    private byte[] macBytes;
    private byte[] macSalt;
    private BigInteger iterations;
    private ASN1Sequence contents;

    public PKCS12() {
    }

    public PKCS12(InputStream inputStream) throws IOException {
        this();
        this.input(inputStream);
    }

    public PKCS12(String string, InputStream inputStream) throws IOException {
        this();
        this.setPassword(string);
        this.input(inputStream);
    }

    public PKCS12(String string, ASN1Sequence aSN1Sequence) throws IOException {
        this();
        this.setPassword(string);
        this.input(aSN1Sequence);
    }

    void reset() {
        this.contents = null;
        this.macBytes = null;
        this.toBeMacedData = null;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        Object object;
        ASN1ConstructedInputStream aSN1ConstructedInputStream;
        this.reset();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        int n2 = ASN1Integer.inputValue(aSN1SequenceInputStream).intValue();
        if (n2 != 3) {
            throw new ASN1FormatException("Expecting version 3, got version " + n2);
        }
        ASN1SequenceInputStream aSN1SequenceInputStream2 = new ASN1SequenceInputStream(aSN1SequenceInputStream);
        ASN1ObjectID aSN1ObjectID = new ASN1ObjectID(aSN1SequenceInputStream2);
        if (aSN1ObjectID.equals(ASN1Utils.pkcsID, 7, 1)) {
            if (aSN1SequenceInputStream2.hasMoreData()) {
                aSN1ConstructedInputStream = new ASN1ConstructedInputStream((InputStream)aSN1SequenceInputStream2, 0);
                object = ASN1OctetString.inputValue(aSN1ConstructedInputStream);
                aSN1ConstructedInputStream.terminate();
                ASN1SequenceInputStream aSN1SequenceInputStream3 = new ASN1SequenceInputStream(new UnsyncByteArrayInputStream((byte[])object));
                while (aSN1SequenceInputStream3.hasMoreData()) {
                    this.addAuthSafe(new PKCS12Safe(this, new ASN1Sequence(aSN1SequenceInputStream3)));
                }
                this.toBeMacedData = (byte[])object;
                aSN1SequenceInputStream3.terminate();
            }
        } else {
            if (aSN1ObjectID.equals(ASN1Utils.pkcsID, 7, 2)) {
                throw new ASN1FormatException("Public-key integrity mode not supported");
            }
            throw new ASN1FormatException("Invalid integrity mode OID " + aSN1ObjectID.toStringCompact());
        }
        aSN1SequenceInputStream2.terminate();
        if (aSN1SequenceInputStream.hasMoreData()) {
            aSN1ConstructedInputStream = new ASN1SequenceInputStream(aSN1SequenceInputStream);
            object = new DigestInfo(aSN1ConstructedInputStream);
            this.macAlg = ((DigestInfo)object).getDigestAlgID();
            this.macBytes = ((DigestInfo)object).getDigest();
            this.macSalt = ASN1OctetString.inputValue(aSN1ConstructedInputStream);
            this.iterations = aSN1ConstructedInputStream.hasMoreData() ? ASN1Integer.inputValue(aSN1ConstructedInputStream) : BigInteger.valueOf(1L);
            aSN1ConstructedInputStream.terminate();
        } else {
            this.macAlg = null;
            this.macBytes = null;
            this.macSalt = null;
            this.iterations = null;
        }
        aSN1SequenceInputStream.terminate();
    }

    public void input(ASN1Sequence aSN1Sequence) throws IOException {
        this.input(Utils.toStream(aSN1Sequence));
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.toASN1().output(outputStream);
    }

    private ASN1Sequence toASN1() {
        if (this.contents != null) {
            return this.contents;
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(new ASN1Integer(3L));
        ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
        aSN1Sequence2.addElement(new ASN1ObjectID(ASN1Utils.pkcsID, 7, 1));
        byte[] byArray = Utils.toBytes(new ASN1Sequence((List<? extends ASN1Object>)this.authSafes));
        aSN1Sequence2.addElement(new ASN1GenericConstructed(new ASN1OctetString(byArray), 0));
        aSN1Sequence.addElement(aSN1Sequence2);
        ASN1Sequence aSN1Sequence3 = new ASN1Sequence();
        if (this.macBytes == null) {
            try {
                this.computeMAC();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                StreamableOutputException streamableOutputException = new StreamableOutputException(noSuchAlgorithmException.toString());
                streamableOutputException.initCause(noSuchAlgorithmException);
                throw streamableOutputException;
            }
            catch (InvalidKeyException invalidKeyException) {
                StreamableOutputException streamableOutputException = new StreamableOutputException(invalidKeyException.toString());
                streamableOutputException.initCause(invalidKeyException);
                throw streamableOutputException;
            }
            catch (CipherException cipherException) {
                StreamableOutputException streamableOutputException = new StreamableOutputException(cipherException.toString());
                streamableOutputException.initCause(cipherException);
                throw streamableOutputException;
            }
        }
        aSN1Sequence3.addElement(new DigestInfo(this.macAlg, this.macBytes));
        aSN1Sequence3.addElement(new ASN1OctetString(this.macSalt));
        if (this.iterations.intValue() != 1) {
            aSN1Sequence3.addElement(new ASN1Integer(this.iterations));
        }
        aSN1Sequence.addElement(aSN1Sequence3);
        this.contents = aSN1Sequence;
        return aSN1Sequence;
    }

    private void computeMAC() throws NoSuchAlgorithmException, InvalidKeyException, CipherException {
        Object object;
        if (this.macAlg == null) {
            this.macAlg = AlgID.sha_1;
        }
        if (this.macSalt == null) {
            object = JCEUtil.getSecureRandom();
            this.macSalt = new byte[8];
            ((SecureRandom)object).nextBytes(this.macSalt);
        }
        object = CryptoUtils.getHmacAlg(this.macAlg);
        Mac mac = JCEUtil.getMacInstance((String)object);
        if (this.iterations == null) {
            this.iterations = BigInteger.valueOf(10000L);
        }
        byte[] byArray = PKCS12.pbkdf12(CryptoUtils.getDigestAlg(this.macAlg), this.passwd, this.macSalt, this.iterations.intValue(), (byte)3, mac.getMacLength());
        mac.init(new SecretKeySpec(byArray, (String)object));
        this.toBeMacedData = Utils.toBytes(new ASN1Sequence((List<? extends ASN1Object>)this.authSafes));
        this.macBytes = mac.doFinal(this.toBeMacedData);
    }

    @Override
    public int length() {
        return this.toASN1().length();
    }

    public String getPassword() {
        return this.passwd == null ? null : new String(this.passwd);
    }

    public char[] getPasswd() {
        return this.passwd;
    }

    public void setPassword(String string) {
        if (this.passwd != null && !Arrays.equals(this.passwd, string.toCharArray())) {
            this.reset();
        }
        this.passwd = string.toCharArray();
    }

    public void setPasswd(char[] cArray) {
        if (this.passwd != null && !Arrays.equals(this.passwd, cArray)) {
            this.reset();
        }
        this.passwd = cArray;
    }

    public Vector<PKCS12Safe> getAuthSafes() {
        return this.authSafes == null ? null : new VectorOverArrayList<PKCS12Safe>(this.authSafes);
    }

    public ArrayList<PKCS12Safe> getAuthSafesAsList() {
        return this.authSafes;
    }

    public void setAuthSafes(Vector<PKCS12Safe> vector) {
        this.setAuthSafes((List<PKCS12Safe>)vector);
    }

    public void setAuthSafes(List<PKCS12Safe> list) {
        this.authSafes = list == null ? null : (list instanceof ArrayList ? (ArrayList<Object>)list : new ArrayList<PKCS12Safe>(list));
        this.reset();
    }

    public void addAuthSafe(PKCS12Safe pKCS12Safe) {
        this.authSafes.add(pKCS12Safe);
        this.reset();
    }

    public boolean verify() throws AuthenticationException {
        try {
            if (this.macBytes == null) {
                this.computeMAC();
                return true;
            }
            String string = CryptoUtils.getHmacAlg(this.macAlg);
            Mac mac = JCEUtil.getMacInstance(string);
            if (this.iterations == null) {
                this.iterations = BigInteger.valueOf(10000L);
            }
            byte[] byArray = PKCS12.pbkdf12(CryptoUtils.getDigestAlg(this.macAlg), this.passwd, this.macSalt, this.iterations.intValue(), (byte)3, mac.getMacLength());
            mac.init(new SecretKeySpec(byArray, string));
            byte[] byArray2 = mac.doFinal(this.toBeMacedData);
            return Utils.areEqual(this.macBytes, byArray2);
        }
        catch (CipherException cipherException) {
            AuthenticationException authenticationException = new AuthenticationException(cipherException.toString());
            authenticationException.initCause(cipherException);
            throw authenticationException;
        }
        catch (InvalidKeyException invalidKeyException) {
            AuthenticationException authenticationException = new AuthenticationException(invalidKeyException.toString());
            authenticationException.initCause(invalidKeyException);
            throw authenticationException;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            AuthenticationException authenticationException = new AuthenticationException(noSuchAlgorithmException.toString());
            authenticationException.initCause(noSuchAlgorithmException);
            throw authenticationException;
        }
    }

    static byte[] pbkdf12(String string, char[] cArray, byte[] byArray, int n2, byte by2, int n3) throws NoSuchAlgorithmException {
        int n4;
        if (cArray == null) {
            throw new NullPointerException("Password not set");
        }
        MessageDigest messageDigest = JCEUtil.getMessageDigestInstance(string);
        int n5 = messageDigest.getDigestLength();
        int n6 = string.contains("512") || string.contains("384") ? 128 : 64;
        byte[] byArray2 = new byte[n6];
        Utils.setArray(byArray2, by2);
        byte[] byArray3 = new byte[cArray.length * 2];
        Utils.charsToBytes(cArray, byArray3);
        byte[] byArray4 = new byte[byArray3.length + 2];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        byArray4[byArray4.length - 1] = 0;
        byArray4[byArray4.length - 2] = 0;
        int n7 = byArray.length == 0 ? 0 : ((byArray.length - 1) / n6 + 1) * n6;
        int n8 = byArray4.length == 0 ? 0 : ((byArray4.length - 1) / n6 + 1) * n6;
        byte[] byArray5 = new byte[n7 + n8];
        for (n4 = 0; n4 < n7; n4 += byArray.length) {
            System.arraycopy(byArray, 0, byArray5, n4, Math.min(n7 - n4, byArray.length));
        }
        int n9 = byArray5.length;
        for (n4 = n7; n4 < n9; n4 += byArray4.length) {
            System.arraycopy(byArray4, 0, byArray5, n4, Math.min(byArray5.length - n4, byArray4.length));
        }
        Utils.setArray(byArray4, (byte)0);
        Utils.setArray(byArray3, (byte)0);
        byte[] byArray6 = new byte[n3];
        byte[] byArray7 = null;
        for (int i2 = 0; i2 < n3; i2 += n5) {
            messageDigest.update(byArray2);
            messageDigest.update(byArray5);
            byArray7 = messageDigest.digest();
            int n10 = n2 - 1;
            for (int i3 = 0; i3 < n10; ++i3) {
                messageDigest.update(byArray7);
                byArray7 = messageDigest.digest();
            }
            byte[] byArray8 = new byte[n6];
            for (n10 = 0; n10 < n6; n10 += n5) {
                System.arraycopy(byArray7, 0, byArray8, n10, Math.min(n6 - n10, n5));
            }
            BigInt bigInt = new BigInt(1, byArray8).add(BigInt.ONE);
            BigInt bigInt2 = BigInt.ONE.shiftLeft(n6 * 8).subtract(BigInt.ONE);
            int n11 = byArray5.length;
            for (int i4 = 0; i4 < n11; i4 += n6) {
                byte[] byArray9 = new byte[n6];
                System.arraycopy(byArray5, i4, byArray9, 0, n6);
                BigInt bigInt3 = new BigInt(1, byArray9).add(bigInt).and(bigInt2);
                Utils.toByteArray(bigInt3, byArray5, i4, n6);
            }
            System.arraycopy(byArray7, 0, byArray6, i2, Math.min(n3 - i2, n5));
        }
        Utils.setArray(byArray7, (byte)0);
        messageDigest = null;
        return byArray6;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        boolean bl2 = false;
        Iterator<PKCS12Safe> iterator = this.authSafes.iterator();
        while (iterator.hasNext()) {
            if (bl2) {
                stringBuffer.append(", ");
            }
            stringBuffer.append('[');
            stringBuffer.append(iterator.next().toString());
            stringBuffer.append(']');
            bl2 = true;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }
}

