/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1Set;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.PKCS12Bag;
import oracle.security.crypto.cert.PKCS12Safe;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.StreamableInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class PKCS12KeyBag
extends PKCS12Bag {
    private PKCS12Safe parent;
    private PrivateKey key;
    private ASN1Sequence contents;

    public PKCS12KeyBag() {
    }

    public PKCS12KeyBag(PKCS12Safe pKCS12Safe) {
        this.parent = pKCS12Safe;
    }

    public PKCS12KeyBag(PKCS12Safe pKCS12Safe, PrivateKey privateKey) {
        this(pKCS12Safe);
        this.key = privateKey;
    }

    public PKCS12KeyBag(PKCS12Safe pKCS12Safe, java.security.PrivateKey privateKey) {
        this(pKCS12Safe);
        this.key = CryptoUtils.fromJCEPrivateKey(privateKey);
    }

    public PKCS12KeyBag(PKCS12Safe pKCS12Safe, InputStream inputStream) throws IOException {
        this(pKCS12Safe);
        this.input(inputStream);
    }

    public PKCS12KeyBag(PKCS12Safe pKCS12Safe, ASN1Sequence aSN1Sequence) throws IOException {
        this(pKCS12Safe);
        this.input(aSN1Sequence);
    }

    @Override
    void reset() {
        this.contents = null;
        if (this.parent != null) {
            this.parent.reset();
        }
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.input(new ASN1Sequence(inputStream));
    }

    public void input(ASN1Sequence aSN1Sequence) throws IOException {
        this.reset();
        ASN1GenericConstructed aSN1GenericConstructed = (ASN1GenericConstructed)aSN1Sequence.elementAt(1);
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1GenericConstructed.elementAt(0);
        this.key = CryptoUtils.inputPrivateKey(Utils.toStream(aSN1Sequence2));
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.outputASN1().output(outputStream);
    }

    private ASN1Sequence outputASN1() {
        if (this.contents == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(new ASN1ObjectID(ASN1Utils.pkcsID, 12, 10, 1, 1));
            aSN1Sequence.addElement(new ASN1GenericConstructed(this.key, 0));
            ASN1Set aSN1Set = this.outputAttrsASN1();
            if (aSN1Set != null) {
                aSN1Sequence.addElement(aSN1Set);
            }
            this.contents = aSN1Sequence;
        }
        return this.contents;
    }

    @Override
    public int length() {
        return this.outputASN1().length();
    }

    public PrivateKey getPrivateKey() {
        return this.key;
    }

    public ASN1Sequence getPrivateKeyInfo() {
        try {
            return new ASN1Sequence(new UnsyncByteArrayInputStream(this.key.getEncoded()));
        }
        catch (IOException iOException) {
            throw new StreamableInputException(iOException.toString());
        }
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.key = privateKey;
        this.reset();
    }

    public void setPrivateKey(java.security.PrivateKey privateKey) {
        this.key = CryptoUtils.fromJCEPrivateKey(privateKey);
        this.reset();
    }

    public String toString() {
        String string = "";
        if (this.friendlyName != null) {
            string = string + "friendlyName = \"" + this.friendlyName + "\", ";
        }
        if (this.localKeyID != null) {
            string = string + "localKeyID = " + Utils.toHexString(this.localKeyID) + ", ";
        }
        return string + this.key.toString();
    }
}

