/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1GenericPrimitive;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.PKCS12;
import oracle.security.crypto.cert.PKCS12Bag;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.CBCAlgorithmIdentifier;
import oracle.security.crypto.core.CipherException;
import oracle.security.crypto.core.PBE;
import oracle.security.crypto.core.PBEAlgorithmIdentifier;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.provider.JCEUtil;
import oracle.security.crypto.provider.TransitionMode;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class PKCS12Safe
implements Externalizable,
ASN1Object {
    private PKCS12 parent;
    private ASN1ObjectID pbeOID;
    private AlgorithmIdentifier prfAlgID;
    private AlgorithmIdentifier cipherAlgID;
    private ArrayList<PKCS12Bag> bags;
    private char[] passwd;
    private ASN1Sequence contents;

    public PKCS12Safe() {
    }

    public PKCS12Safe(PKCS12 pKCS12) {
        this.parent = pKCS12;
        this.bags = new ArrayList();
    }

    public PKCS12Safe(PKCS12 pKCS12, int n2) {
        this(pKCS12);
        this.setMode(n2);
    }

    public PKCS12Safe(PKCS12 pKCS12, ASN1ObjectID aSN1ObjectID) {
        this(pKCS12);
        this.setPBEOID(aSN1ObjectID);
    }

    public PKCS12Safe(PKCS12 pKCS12, InputStream inputStream) throws IOException {
        this(pKCS12);
        this.input(inputStream);
    }

    public PKCS12Safe(PKCS12 pKCS12, ASN1Sequence aSN1Sequence) throws IOException {
        this(pKCS12);
        this.input(aSN1Sequence);
    }

    void reset() {
        this.contents = null;
        if (this.parent != null) {
            this.parent.reset();
        }
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.input(new ASN1Sequence(inputStream));
    }

    public void input(ASN1Sequence aSN1Sequence) throws IOException {
        this.reset();
        try {
            Object object;
            ASN1ObjectID aSN1ObjectID = (ASN1ObjectID)aSN1Sequence.elementAt(0);
            ASN1GenericConstructed aSN1GenericConstructed = (ASN1GenericConstructed)aSN1Sequence.elementAt(1);
            byte[] byArray = null;
            if (aSN1ObjectID.equals(ASN1Utils.pkcsID, 7, 1)) {
                this.pbeOID = null;
                byArray = ((ASN1OctetString)aSN1GenericConstructed.elementAt(0)).getValue();
            } else if (aSN1ObjectID.equals(ASN1Utils.pkcsID, 7, 6)) {
                Object object2;
                byte[] byArray2;
                object = (ASN1Sequence)aSN1GenericConstructed.elementAt(0);
                ASN1Sequence aSN1Sequence2 = (ASN1Sequence)((ASN1Sequence)object).elementAt(1);
                ASN1Sequence aSN1Sequence3 = (ASN1Sequence)aSN1Sequence2.elementAt(1);
                PBEAlgorithmIdentifier pBEAlgorithmIdentifier = new PBEAlgorithmIdentifier(Utils.toStream(aSN1Sequence3));
                this.pbeOID = pBEAlgorithmIdentifier.getOID();
                this.cipherAlgID = pBEAlgorithmIdentifier.getEncryptionScheme();
                this.prfAlgID = pBEAlgorithmIdentifier.getPseudorandomFunc();
                ASN1Object aSN1Object = aSN1Sequence2.elementAt(2);
                if (aSN1Object instanceof ASN1GenericPrimitive) {
                    byArray2 = ((ASN1OctetString)((ASN1GenericPrimitive)aSN1Object).withTag(4)).getValue();
                } else if (aSN1Object instanceof ASN1GenericConstructed) {
                    int n2;
                    object2 = ((ASN1GenericConstructed)aSN1Object).elementsAsList();
                    byte[][] byArray3 = new byte[((ArrayList)object2).size()][0];
                    int n3 = 0;
                    int n4 = byArray3.length;
                    for (n2 = 0; n2 < n4; ++n2) {
                        byArray3[n2] = ((ASN1OctetString)((ArrayList)object2).get(n2)).getValue();
                        n3 += byArray3[n2].length;
                    }
                    byArray2 = new byte[n3];
                    n2 = 0;
                    int n5 = byArray3.length;
                    for (n4 = 0; n4 < n5; ++n4) {
                        System.arraycopy(byArray3[n4], 0, byArray2, n2, byArray3[n4].length);
                        n2 += byArray3[n4].length;
                    }
                } else {
                    throw new InvalidInputException("Cound not read encrypted content.");
                }
                object2 = PBE.getInstance(pBEAlgorithmIdentifier);
                byArray = ((PBE)object2).decrypt(this.getPassword(), byArray2);
            } else {
                throw new IOException("Unrecognized ContentType " + aSN1ObjectID);
            }
            object = new ASN1SequenceInputStream(new UnsyncByteArrayInputStream(byArray));
            while (((ASN1ConstructedInputStream)object).hasMoreData()) {
                this.addBag(PKCS12Bag.inputBag(this, new ASN1Sequence((InputStream)object)));
            }
            ((ASN1ConstructedInputStream)object).terminate();
        }
        catch (ClassCastException classCastException) {
            throw new ASN1FormatException(classCastException.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ASN1FormatException(indexOutOfBoundsException.toString());
        }
        catch (CipherException cipherException) {
            throw new ASN1FormatException(cipherException.toString());
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new ASN1FormatException(algorithmIdentifierException.toString());
        }
        this.contents = aSN1Sequence;
    }

    private static byte[] makeSalt() {
        return PKCS12Safe.randomBytes(8);
    }

    private static byte[] makeAES_CBC_IV() {
        return PKCS12Safe.randomBytes(16);
    }

    private static byte[] randomBytes(int n2) {
        byte[] byArray;
        if (TransitionMode.isJCEUseEnabled()) {
            SecureRandom secureRandom = JCEUtil.getSecureRandom();
            byArray = new byte[n2];
            secureRandom.nextBytes(byArray);
        } else {
            byArray = RandomBitsSource.getDefault().randomBytes(new byte[n2]);
        }
        return byArray;
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.outputASN1().output(outputStream);
    }

    private ASN1Sequence outputASN1() {
        if (this.contents != null) {
            return this.contents;
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        byte[] byArray = Utils.toBytes(new ASN1Sequence((List<? extends ASN1Object>)this.bags));
        if (this.pbeOID == null) {
            aSN1Sequence.addElement(new ASN1ObjectID(ASN1Utils.pkcsID, 7, 1));
            aSN1Sequence.addElement(new ASN1GenericConstructed(new ASN1OctetString(byArray), 0));
        } else {
            try {
                PBEAlgorithmIdentifier pBEAlgorithmIdentifier;
                byte[] byArray2;
                byte[] byArray3 = PKCS12Safe.makeSalt();
                if (this.pbeOID.equals(PBEAlgorithmIdentifier.id_PBES2)) {
                    int n2 = 0;
                    if (this.cipherAlgID.getOID().equals(AlgID.aes128_CBC.getOID())) {
                        n2 = 16;
                    } else if (this.cipherAlgID.getOID().equals(AlgID.aes192_CBC.getOID())) {
                        n2 = 24;
                    } else if (this.cipherAlgID.getOID().equals(AlgID.aes256_CBC.getOID())) {
                        n2 = 32;
                    }
                    byArray2 = PKCS12Safe.makeAES_CBC_IV();
                    pBEAlgorithmIdentifier = new PBEAlgorithmIdentifier(byArray3, 10000, n2, this.prfAlgID, new CBCAlgorithmIdentifier(this.cipherAlgID.getOID(), byArray2));
                } else {
                    pBEAlgorithmIdentifier = new PBEAlgorithmIdentifier(this.pbeOID, byArray3, 10000);
                }
                PBE pBE = PBE.getInstance(pBEAlgorithmIdentifier);
                byArray2 = pBE.encrypt(this.getPassword(), byArray);
                aSN1Sequence.addElement(new ASN1ObjectID(ASN1Utils.pkcsID, 7, 6));
                ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
                aSN1Sequence2.addElement(new ASN1Integer(0L));
                ASN1Sequence aSN1Sequence3 = new ASN1Sequence();
                aSN1Sequence3.addElement(new ASN1ObjectID(ASN1Utils.pkcsID, 7, 1));
                aSN1Sequence3.addElement(pBEAlgorithmIdentifier);
                aSN1Sequence3.addElement(new ASN1GenericPrimitive(new ASN1OctetString(byArray2), 0));
                aSN1Sequence2.addElement(aSN1Sequence3);
                aSN1Sequence.addElement(new ASN1GenericConstructed(aSN1Sequence2, 0));
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new StreamableOutputException(algorithmIdentifierException.toString());
            }
            catch (CipherException cipherException) {
                throw new StreamableOutputException(cipherException.toString());
            }
        }
        this.contents = aSN1Sequence;
        return aSN1Sequence;
    }

    @Override
    public int length() {
        return this.outputASN1().length();
    }

    public void setPassword(String string) {
        this.passwd = string == null ? null : string.toCharArray();
        this.reset();
    }

    public void setPasswd(char[] cArray) {
        this.passwd = cArray;
        this.reset();
    }

    public String getPassword() {
        return this.passwd != null ? new String(this.passwd) : this.parent.getPassword();
    }

    public char[] getPasswd() {
        return this.passwd != null ? this.passwd : this.parent.getPasswd();
    }

    public Vector<PKCS12Bag> getBags() {
        return this.bags == null ? null : new VectorOverArrayList<PKCS12Bag>(this.bags);
    }

    public ArrayList<PKCS12Bag> getBagsAsList() {
        return this.bags;
    }

    public void setBags(Vector<PKCS12Bag> vector) {
        this.setBags((List<PKCS12Bag>)vector);
    }

    public void setBags(List<PKCS12Bag> list) {
        this.bags = list == null ? null : (list instanceof ArrayList ? (ArrayList<Object>)list : new ArrayList<PKCS12Bag>(list));
        this.reset();
    }

    public void addBag(PKCS12Bag pKCS12Bag) {
        this.bags.add(pKCS12Bag);
        this.reset();
    }

    public int getMode() {
        if (this.pbeOID == null) {
            return 0;
        }
        if (this.pbeOID.equals(PBEAlgorithmIdentifier.pbeWithMD2AndDES_CBC)) {
            return -2;
        }
        if (this.pbeOID.equals(PBEAlgorithmIdentifier.pbeWithMD5AndDES_CBC)) {
            return -1;
        }
        return this.pbeOID.getValue()[this.pbeOID.getValue().length - 1];
    }

    public void setMode(int n2) {
        this.reset();
        if (n2 == -2) {
            this.setPBEOID(PBEAlgorithmIdentifier.pbeWithMD2AndDES_CBC);
        } else if (n2 == -1) {
            this.setPBEOID(PBEAlgorithmIdentifier.pbeWithMD5AndDES_CBC);
        } else if (n2 == 0) {
            this.setPBEOID(null);
        } else {
            this.setPBEOID(new ASN1ObjectID(PBEAlgorithmIdentifier.pkcs12PBEids, n2));
        }
    }

    public void setPBEOID(ASN1ObjectID aSN1ObjectID) {
        this.pbeOID = aSN1ObjectID;
        this.reset();
    }

    public void setPBES2Parameters(ASN1ObjectID aSN1ObjectID, AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2) {
        this.pbeOID = aSN1ObjectID;
        this.prfAlgID = algorithmIdentifier;
        this.cipherAlgID = algorithmIdentifier2;
        this.reset();
    }

    public ASN1ObjectID getPBEOID() {
        return this.pbeOID;
    }

    public String toString() {
        String string = "pbeOID = {" + this.pbeOID + "}";
        for (PKCS12Bag pKCS12Bag : this.bags) {
            string = string + ", {" + pKCS12Bag + "}";
        }
        return string;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }
}

