/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Constructed;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.PKCS12Bag;
import oracle.security.crypto.cert.PKCS12Safe;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class PKCS12SafeContentsBag
extends PKCS12Bag {
    private PKCS12Safe parent;
    private ArrayList<PKCS12Bag> bags;
    private ASN1Sequence contents;

    public PKCS12SafeContentsBag() {
    }

    public PKCS12SafeContentsBag(PKCS12Safe pKCS12Safe) {
        this.parent = pKCS12Safe;
    }

    public PKCS12SafeContentsBag(PKCS12Safe pKCS12Safe, Vector<PKCS12Bag> vector) {
        this(pKCS12Safe, (List<PKCS12Bag>)vector);
    }

    public PKCS12SafeContentsBag(PKCS12Safe pKCS12Safe, List<PKCS12Bag> list) {
        this(pKCS12Safe);
        this.bags = list == null ? null : new ArrayList<PKCS12Bag>(list);
    }

    public PKCS12SafeContentsBag(PKCS12Safe pKCS12Safe, InputStream inputStream) throws IOException {
        this(pKCS12Safe);
        this.input(inputStream);
    }

    public PKCS12SafeContentsBag(PKCS12Safe pKCS12Safe, ASN1Sequence aSN1Sequence) throws IOException {
        this(pKCS12Safe);
        this.input(aSN1Sequence);
    }

    @Override
    void reset() {
        this.contents = null;
        if (this.parent != null) {
            this.parent.reset();
        }
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.input(new ASN1Sequence(inputStream));
    }

    public void input(ASN1Sequence aSN1Sequence) throws IOException {
        this.reset();
        try {
            ASN1GenericConstructed aSN1GenericConstructed = (ASN1GenericConstructed)aSN1Sequence.elementAt(1);
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1GenericConstructed.elementAt(0);
            this.bags = new ArrayList();
            int n2 = aSN1Sequence2.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.bags.add(PKCS12Bag.inputBag(null, (ASN1Sequence)aSN1Sequence2.elementAt(i2)));
            }
        }
        catch (ClassCastException classCastException) {
            throw new ASN1FormatException(classCastException.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ASN1FormatException(indexOutOfBoundsException.toString());
        }
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.outputASN1().output(outputStream);
    }

    private ASN1Sequence outputASN1() {
        if (this.contents != null) {
            return this.contents;
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(new ASN1ObjectID(ASN1Utils.pkcsID, 12, 10, 1, 6));
        ASN1Constructed aSN1Constructed = new ASN1Sequence((List<? extends ASN1Object>)this.bags);
        aSN1Sequence.addElement(new ASN1GenericConstructed(aSN1Constructed, 0));
        aSN1Constructed = this.outputAttrsASN1();
        if (aSN1Constructed != null) {
            aSN1Sequence.addElement(aSN1Constructed);
        }
        this.contents = aSN1Sequence;
        return aSN1Sequence;
    }

    @Override
    public int length() {
        return this.outputASN1().length();
    }

    public Vector<PKCS12Bag> getBags() {
        return this.bags == null ? null : new VectorOverArrayList<PKCS12Bag>(this.bags);
    }

    public ArrayList<PKCS12Bag> getBagsAsList() {
        return this.bags;
    }

    public void setBags(Vector<PKCS12Bag> vector) {
        this.setBags((List<PKCS12Bag>)vector);
    }

    public void setBags(List<PKCS12Bag> list) {
        this.bags = list == null ? null : (list instanceof ArrayList ? (ArrayList<Object>)list : new ArrayList<PKCS12Bag>(list));
        this.reset();
    }

    public void addBag(PKCS12Bag pKCS12Bag) {
        if (this.bags == null) {
            this.bags = new ArrayList();
        }
        this.bags.add(pKCS12Bag);
        this.reset();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.friendlyName != null) {
            stringBuffer.append("friendlyName = \"" + this.friendlyName + "\", ");
        }
        if (this.localKeyID != null) {
            stringBuffer.append("localKeyID = " + Utils.toHexString(this.localKeyID) + ", ");
        }
        stringBuffer.append("bags = {");
        int n2 = this.bags.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(this.bags.get(i2).toString());
            if (i2 == n2 - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

