/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.security.crypto.asn1.ASN1Constructed;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.PKCS12Bag;
import oracle.security.crypto.cert.PKCS12Safe;
import oracle.security.crypto.util.Utils;

public class PKCS12SecretBag
extends PKCS12Bag {
    private PKCS12Safe parent;
    private ASN1ObjectID type;
    private ASN1Object value;
    private ASN1Sequence contents;

    public PKCS12SecretBag() {
    }

    public PKCS12SecretBag(PKCS12Safe pKCS12Safe) {
        this.parent = pKCS12Safe;
    }

    public PKCS12SecretBag(PKCS12Safe pKCS12Safe, ASN1ObjectID aSN1ObjectID, ASN1Object aSN1Object) {
        this(pKCS12Safe);
        this.type = aSN1ObjectID;
        this.value = aSN1Object;
    }

    public PKCS12SecretBag(PKCS12Safe pKCS12Safe, InputStream inputStream) throws IOException {
        this(pKCS12Safe);
        this.input(inputStream);
    }

    public PKCS12SecretBag(PKCS12Safe pKCS12Safe, ASN1Sequence aSN1Sequence) throws IOException {
        this(pKCS12Safe);
        this.input(aSN1Sequence);
    }

    @Override
    void reset() {
        this.contents = null;
        if (this.parent != null) {
            this.parent.reset();
        }
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.input(new ASN1Sequence(inputStream));
    }

    public void input(ASN1Sequence aSN1Sequence) throws IOException {
        this.reset();
        try {
            ASN1GenericConstructed aSN1GenericConstructed = (ASN1GenericConstructed)aSN1Sequence.elementAt(1);
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1GenericConstructed.elementAt(0);
            this.type = (ASN1ObjectID)aSN1Sequence2.elementAt(0);
            ASN1GenericConstructed aSN1GenericConstructed2 = (ASN1GenericConstructed)aSN1Sequence2.elementAt(1);
            this.value = aSN1GenericConstructed2.elementAt(0);
        }
        catch (ClassCastException classCastException) {
            throw new ASN1FormatException(classCastException.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ASN1FormatException(indexOutOfBoundsException.toString());
        }
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.outputASN1().output(outputStream);
    }

    private ASN1Sequence outputASN1() {
        if (this.contents != null) {
            return this.contents;
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(new ASN1ObjectID(ASN1Utils.pkcsID, 12, 10, 1, 5));
        ASN1Constructed aSN1Constructed = new ASN1Sequence();
        aSN1Constructed.addElement(this.type);
        aSN1Constructed.addElement(new ASN1GenericConstructed(this.value, 0));
        aSN1Sequence.addElement(new ASN1GenericConstructed(aSN1Constructed, 0));
        aSN1Constructed = this.outputAttrsASN1();
        if (aSN1Constructed != null) {
            aSN1Sequence.addElement(aSN1Constructed);
        }
        this.contents = aSN1Sequence;
        return aSN1Sequence;
    }

    @Override
    public int length() {
        return this.outputASN1().length();
    }

    public void setSecretType(ASN1ObjectID aSN1ObjectID) {
        this.type = aSN1ObjectID;
        this.reset();
    }

    public ASN1ObjectID getSecretType() {
        return this.type;
    }

    public void setSecretValue(ASN1Object aSN1Object) {
        this.value = aSN1Object;
        this.reset();
    }

    public ASN1Object getSecretValue() {
        return this.value;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.friendlyName != null) {
            stringBuffer.append("friendlyName = \"" + this.friendlyName + "\", ");
        }
        if (this.localKeyID != null) {
            stringBuffer.append("localKeyID = " + Utils.toHexString(this.localKeyID) + ", ");
        }
        stringBuffer.append("type = " + this.type + ", ");
        stringBuffer.append("value = " + this.value);
        return stringBuffer.toString();
    }
}

