/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1Set;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.PKCS12Bag;
import oracle.security.crypto.cert.PKCS12Safe;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.PrivateKeyPKCS8;
import oracle.security.crypto.util.StreamableInputException;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class PKCS12ShroudedKeyBag
extends PKCS12Bag {
    private PKCS12Safe parent;
    private char[] passwd;
    private PrivateKeyPKCS8 pkcs8;
    private ASN1Sequence contents;
    private static final ASN1ObjectID OID = new ASN1ObjectID(ASN1Utils.pkcsID, 12, 10, 1, 2);

    public PKCS12ShroudedKeyBag() {
    }

    public PKCS12ShroudedKeyBag(PKCS12Safe pKCS12Safe) {
        this.parent = pKCS12Safe;
    }

    public PKCS12ShroudedKeyBag(PKCS12Safe pKCS12Safe, PrivateKeyPKCS8 privateKeyPKCS8) {
        this(pKCS12Safe);
        this.setPKCS8_FIPS(privateKeyPKCS8);
    }

    public PKCS12ShroudedKeyBag(PKCS12Safe pKCS12Safe, InputStream inputStream) throws IOException {
        this(pKCS12Safe);
        this.input(inputStream);
    }

    public PKCS12ShroudedKeyBag(PKCS12Safe pKCS12Safe, ASN1Sequence aSN1Sequence) throws IOException {
        this(pKCS12Safe);
        this.input(aSN1Sequence);
    }

    @Override
    void reset() {
        this.contents = null;
        if (this.parent != null) {
            this.parent.reset();
        }
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.input(new ASN1Sequence(inputStream));
    }

    public void input(ASN1Sequence aSN1Sequence) throws IOException {
        this.reset();
        ASN1GenericConstructed aSN1GenericConstructed = (ASN1GenericConstructed)aSN1Sequence.elementAt(1);
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1GenericConstructed.elementAt(0);
        this.pkcs8 = new PKCS8_FIPS(aSN1Sequence2);
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        try {
            this.toASN1().output(outputStream);
        }
        catch (StreamableOutputException streamableOutputException) {
            throw new IOException(streamableOutputException.toString());
        }
    }

    private ASN1Sequence toASN1() {
        if (this.contents != null) {
            return this.contents;
        }
        ASN1Sequence aSN1Sequence = null;
        try {
            aSN1Sequence = (ASN1Sequence)this.pkcs8.getContents();
        }
        catch (StreamableOutputException streamableOutputException) {
            this.pkcs8.setPassword(this.getPassword());
            aSN1Sequence = (ASN1Sequence)this.pkcs8.getContents();
        }
        ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
        aSN1Sequence2.addElement(new ASN1ObjectID(ASN1Utils.pkcsID, 12, 10, 1, 2));
        aSN1Sequence2.addElement(new ASN1GenericConstructed(aSN1Sequence, 0));
        ASN1Set aSN1Set = this.outputAttrsASN1();
        if (aSN1Set != null) {
            aSN1Sequence2.addElement(aSN1Set);
        }
        this.contents = aSN1Sequence2;
        return aSN1Sequence2;
    }

    @Override
    public int length() {
        return this.toASN1().length();
    }

    public void setPassword(String string) {
        this.passwd = string == null ? null : string.toCharArray();
        this.reset();
    }

    public void setPasswd(char[] cArray) {
        this.passwd = cArray;
        this.reset();
    }

    public String getPassword() {
        return this.passwd != null ? new String(this.passwd) : this.parent.getPassword();
    }

    public char[] getPasswd() {
        return this.passwd != null ? this.passwd : this.parent.getPasswd();
    }

    public PrivateKey getPrivateKey() {
        if (this.pkcs8 == null) {
            return null;
        }
        this.pkcs8.setPassword(this.getPassword());
        return this.getPKCS8_FIPS().getKey();
    }

    public PrivateKeyPKCS8 getPKCS8() {
        return this.getPKCS8_FIPS();
    }

    public void setPKCS8(PrivateKeyPKCS8 privateKeyPKCS8) {
        this.setPKCS8_FIPS(privateKeyPKCS8);
        this.reset();
    }

    private void setPKCS8_FIPS(PrivateKeyPKCS8 privateKeyPKCS8) {
        block7: {
            if (!(privateKeyPKCS8 instanceof PKCS8_FIPS)) {
                try {
                    privateKeyPKCS8 = new PKCS8_FIPS(new UnsyncByteArrayInputStream(privateKeyPKCS8.getEncoded()));
                }
                catch (IOException iOException) {
                    throw new StreamableInputException(iOException.toString());
                }
                catch (StreamableOutputException streamableOutputException) {
                    String string = this.getPassword();
                    if (string == null) break block7;
                    privateKeyPKCS8.setPassword(string);
                    try {
                        privateKeyPKCS8 = new PKCS8_FIPS(new UnsyncByteArrayInputStream(privateKeyPKCS8.getEncoded()));
                    }
                    catch (IOException iOException) {
                        throw new StreamableInputException(streamableOutputException.toString());
                    }
                    catch (StreamableOutputException streamableOutputException2) {
                        // empty catch block
                    }
                }
            }
        }
        this.pkcs8 = privateKeyPKCS8;
    }

    private PrivateKeyPKCS8 getPKCS8_FIPS() {
        block7: {
            if (!(this.pkcs8 instanceof PKCS8_FIPS)) {
                try {
                    this.pkcs8 = new PKCS8_FIPS(new UnsyncByteArrayInputStream(this.pkcs8.getEncoded()));
                }
                catch (IOException iOException) {
                    throw new StreamableInputException(iOException.toString());
                }
                catch (StreamableOutputException streamableOutputException) {
                    String string = this.getPassword();
                    if (string == null) break block7;
                    this.pkcs8.setPassword(string);
                    try {
                        this.pkcs8 = new PKCS8_FIPS(new UnsyncByteArrayInputStream(this.pkcs8.getEncoded()));
                    }
                    catch (IOException iOException) {
                        throw new StreamableInputException(streamableOutputException.toString());
                    }
                    catch (StreamableOutputException streamableOutputException2) {
                        // empty catch block
                    }
                }
            }
        }
        return this.pkcs8;
    }

    public String toString() {
        String string = "";
        if (this.friendlyName != null) {
            string = string + "friendlyName = \"" + this.friendlyName + "\", ";
        }
        if (this.localKeyID != null) {
            string = string + "localKeyID = " + Utils.toHexString(this.localKeyID) + ", ";
        }
        return string + this.pkcs8.toString();
    }

    private static class PKCS8_FIPS
    extends PrivateKeyPKCS8 {
        public PKCS8_FIPS(InputStream inputStream) throws IOException {
            super(inputStream);
        }

        public PKCS8_FIPS(ASN1Sequence aSN1Sequence) throws IOException {
            super(Utils.toStream(aSN1Sequence));
        }

        protected void assertAllowExport() {
        }
    }
}

