/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Constructed;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1Set;
import oracle.security.crypto.asn1.ASN1TaggedObject;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.CRL;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.core.RSAPublicKey;
import oracle.security.crypto.core.SignatureException;
import oracle.security.crypto.provider.JCEUtil;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class PKCS7
implements Externalizable,
ASN1Object {
    private ArrayList<X509> certificates;
    private ArrayList<CRL> crls;
    private X500Name issuer;
    private BigInteger serialNo;
    private RSAPublicKey pubKey;
    private Signature sig;
    private byte[] aaBytes;
    private byte[] hashBytes;
    private byte[] docHash;
    private byte[] sigBytes;
    private byte[] doc;
    private AlgorithmIdentifier mdAlg;
    private ASN1Sequence contents;
    protected static final int[] pkcs7 = new int[]{1, 2, 840, 113549, 1, 7};

    public PKCS7() {
    }

    public PKCS7(Vector<X509> vector, Vector<CRL> vector2) {
        this((List<X509>)vector, (List<CRL>)vector2);
    }

    public PKCS7(List<X509> list, List<CRL> list2) {
        ArrayList<Object> arrayList = list == null ? null : (this.certificates = list instanceof ArrayList ? (ArrayList<Object>)list : new ArrayList<X509>(list));
        this.crls = list2 == null ? null : (list2 instanceof ArrayList ? (ArrayList<Object>)list2 : new ArrayList<CRL>(list2));
    }

    public PKCS7(X509 x509) {
        this.certificates = new ArrayList();
        this.certificates.add(x509);
    }

    public PKCS7(CRL cRL) {
        this.crls = new ArrayList();
        this.crls.add(cRL);
    }

    public PKCS7(X509 x509, oracle.security.crypto.core.RSAPrivateKey rSAPrivateKey, byte[] byArray) throws SignatureException {
        this();
        this.sign(x509, rSAPrivateKey, byArray);
    }

    public PKCS7(X509Certificate x509Certificate, RSAPrivateKey rSAPrivateKey, AlgorithmIdentifier algorithmIdentifier, byte[] byArray) throws SignatureException {
        this();
        this.sign(x509Certificate, rSAPrivateKey, algorithmIdentifier, byArray);
    }

    public PKCS7(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public PKCS7(ASN1Sequence aSN1Sequence) throws IOException {
        this.input(aSN1Sequence);
    }

    @Deprecated
    public Vector<X509> getCertificates() {
        return this.certificates == null ? null : new VectorOverArrayList<X509>(this.certificates);
    }

    public ArrayList<X509> getCertificatesAsList() {
        return this.certificates;
    }

    @Deprecated
    public Vector<CRL> getCRLs() {
        return this.crls == null ? null : new VectorOverArrayList<CRL>(this.crls);
    }

    public ArrayList<CRL> getCRLsAsList() {
        return this.crls;
    }

    public void addCertificate(X509 x509) {
        if (this.certificates == null) {
            this.certificates = new ArrayList();
        }
        this.certificates.add(x509);
    }

    public void addCRL(CRL cRL) {
        if (this.crls == null) {
            this.crls = new ArrayList();
        }
        this.crls.add(cRL);
    }

    public X500Name getIssuer() {
        return this.issuer;
    }

    public BigInteger getSerialNo() {
        return this.serialNo;
    }

    public void setPublicKey(RSAPublicKey rSAPublicKey) {
        this.setPublicKey((java.security.interfaces.RSAPublicKey)rSAPublicKey);
    }

    public void setPublicKey(java.security.interfaces.RSAPublicKey rSAPublicKey) {
        this.pubKey = (RSAPublicKey)CryptoUtils.fromJCEPublicKey(rSAPublicKey);
        try {
            this.sig = JCEUtil.getSignatureInstance(CryptoUtils.getSignatureAlg(PKCS7.getSigAlgID(this.mdAlg)));
            this.sig.initVerify(this.pubKey);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException(noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalStateException(invalidKeyException);
        }
    }

    public void setSigner(X509 x509) {
    }

    public void setSigner(X509Certificate x509Certificate) {
        if (this.issuer == null) {
            this.issuer = X500Name.toX500Name(x509Certificate.getIssuerX500Principal());
        } else if (!this.issuer.equals(x509Certificate.getIssuerX500Principal())) {
            throw new RuntimeException("The issuer is " + this.issuer + ", which is not " + x509Certificate.getIssuerX500Principal());
        }
        if (this.serialNo == null) {
            this.serialNo = x509Certificate.getSerialNumber();
        } else if (!this.serialNo.equals(x509Certificate.getSerialNumber())) {
            throw new RuntimeException("The serial number is " + this.serialNo + ", which is not " + x509Certificate.getSerialNumber());
        }
        this.setPublicKey((java.security.interfaces.RSAPublicKey)x509Certificate.getPublicKey());
    }

    public void setDocument(byte[] byArray) {
        if (this.pubKey == null) {
            throw new IllegalStateException("The public key is not set");
        }
        this.doc = byArray;
    }

    public void sign(X509 x509, oracle.security.crypto.core.RSAPrivateKey rSAPrivateKey, byte[] byArray) throws SignatureException {
        this.sign(x509, rSAPrivateKey, AlgID.md5WithRSAEncryption, byArray);
    }

    public void sign(X509 x509, oracle.security.crypto.core.RSAPrivateKey rSAPrivateKey, AlgorithmIdentifier algorithmIdentifier, byte[] byArray) throws SignatureException {
        this.sign(x509.toX509Certificate(), (RSAPrivateKey)rSAPrivateKey, algorithmIdentifier, byArray);
    }

    public void sign(X509Certificate x509Certificate, RSAPrivateKey rSAPrivateKey, AlgorithmIdentifier algorithmIdentifier, byte[] byArray) throws SignatureException {
        this.issuer = X500Name.toX500Name(x509Certificate.getIssuerX500Principal());
        this.serialNo = x509Certificate.getSerialNumber();
        if (!x509Certificate.getPublicKey().getAlgorithm().equals("RSA")) {
            throw new SignatureException("Only RSA signatures are supported");
        }
        this.pubKey = (RSAPublicKey)x509Certificate.getPublicKey();
        this.mdAlg = PKCS7.getDigestAlgID(algorithmIdentifier);
        try {
            this.sig = JCEUtil.getSignatureInstance(CryptoUtils.getSignatureAlg(algorithmIdentifier));
            this.sig.initSign(rSAPrivateKey);
            this.sig.update(byArray);
            this.sigBytes = this.sig.sign();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SignatureException(noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SignatureException(invalidKeyException);
        }
        catch (java.security.SignatureException signatureException) {
            throw new SignatureException(signatureException);
        }
    }

    public boolean verify() throws AuthenticationException {
        if (this.aaBytes == null) {
            try {
                this.sig.update(this.doc);
                return this.sig.verify(this.sigBytes);
            }
            catch (java.security.SignatureException signatureException) {
                throw new AuthenticationException(signatureException);
            }
        }
        try {
            this.sig.update(this.doc);
            MessageDigest messageDigest = JCEUtil.getMessageDigestInstance(CryptoUtils.getDigestAlg(this.mdAlg));
            messageDigest.update(this.doc);
            this.docHash = messageDigest.digest();
            return this.sig.verify(this.sigBytes) && Utils.areEqual(this.docHash, this.hashBytes);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AuthenticationException(noSuchAlgorithmException);
        }
        catch (java.security.SignatureException signatureException) {
            throw new AuthenticationException(signatureException);
        }
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.outputASN1().output(outputStream);
    }

    private ASN1Sequence outputASN1() {
        if (this.contents != null) {
            return this.contents;
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(new ASN1ObjectID(pkcs7, 2));
        ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
        aSN1Sequence2.addElement(new ASN1Integer(1L));
        aSN1Sequence2.addElement(new ASN1Set());
        ASN1Sequence aSN1Sequence3 = new ASN1Sequence();
        aSN1Sequence3.addElement(new ASN1ObjectID(pkcs7, 1));
        aSN1Sequence2.addElement(aSN1Sequence3);
        if (this.certificates != null) {
            aSN1Sequence2.addElement(new ASN1GenericConstructed(this.certificates, 0));
        }
        if (this.crls != null) {
            aSN1Sequence2.addElement(new ASN1GenericConstructed(this.crls, 1));
        }
        if (this.sig == null) {
            aSN1Sequence2.addElement(new ASN1Set());
        } else {
            aSN1Sequence3 = new ASN1Sequence();
            aSN1Sequence3.addElement(new ASN1Integer(1L));
            ASN1Sequence aSN1Sequence4 = new ASN1Sequence();
            aSN1Sequence4.addElement(this.issuer);
            aSN1Sequence4.addElement(new ASN1Integer(this.serialNo));
            aSN1Sequence3.addElement(aSN1Sequence4);
            aSN1Sequence3.addElement(this.mdAlg);
            aSN1Sequence3.addElement(AlgID.rsaEncryption);
            aSN1Sequence3.addElement(new ASN1OctetString(this.sigBytes));
            aSN1Sequence2.addElement(new ASN1Set(aSN1Sequence3));
        }
        aSN1Sequence.addElement(new ASN1GenericConstructed(aSN1Sequence2, 0));
        this.contents = aSN1Sequence;
        return aSN1Sequence;
    }

    private static AlgorithmIdentifier getDigestAlgID(AlgorithmIdentifier algorithmIdentifier) {
        if (algorithmIdentifier.getOID().equals(AlgID.md2WithRSAEncryption.getOID())) {
            return AlgID.md2;
        }
        if (algorithmIdentifier.getOID().equals(AlgID.md5WithRSAEncryption.getOID())) {
            return AlgID.md5;
        }
        if (algorithmIdentifier.getOID().equals(AlgID.sha_1WithRSAEncryption.getOID())) {
            return AlgID.sha_1;
        }
        throw new IllegalStateException("Unsupported signature algorithm identifier");
    }

    private static AlgorithmIdentifier getSigAlgID(AlgorithmIdentifier algorithmIdentifier) {
        if (algorithmIdentifier.getOID().equals(AlgID.md2.getOID())) {
            return AlgID.md2WithRSAEncryption;
        }
        if (algorithmIdentifier.getOID().equals(AlgID.md5.getOID())) {
            return AlgID.md5WithRSAEncryption;
        }
        if (algorithmIdentifier.getOID().equals(AlgID.sha_1.getOID()) || algorithmIdentifier.getOID().equals(AlgID.sha.getOID())) {
            return AlgID.sha_1WithRSAEncryption;
        }
        throw new IllegalStateException("Unsupported message digest algorithm identifier");
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.input(new ASN1Sequence(inputStream));
    }

    public void input(ASN1Sequence aSN1Sequence) throws IOException {
        try {
            ASN1Constructed aSN1Constructed;
            this.contents = aSN1Sequence;
            ASN1ObjectID aSN1ObjectID = (ASN1ObjectID)aSN1Sequence.elementAt(0);
            if (!aSN1ObjectID.equals(pkcs7, 2)) {
                throw new IOException("contentType has to be signedData");
            }
            if (aSN1Sequence.elementsAsList().size() < 2) {
                throw new IOException("No content");
            }
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)((ASN1GenericConstructed)aSN1Sequence.elementAt(1)).elementAt(0);
            this.certificates = null;
            this.crls = null;
            int n2 = 3;
            while (!(aSN1Sequence2.elementAt(n2) instanceof ASN1Set)) {
                aSN1Constructed = (ASN1GenericConstructed)aSN1Sequence2.elementAt(n2);
                switch (((ASN1GenericConstructed)aSN1Constructed).getTag()) {
                    case 0: {
                        int n3;
                        this.certificates = new ArrayList();
                        int n4 = ((ASN1GenericConstructed)aSN1Constructed).size();
                        for (n3 = 0; n3 < n4; ++n3) {
                            this.certificates.add(new X509(Utils.toStream(((ASN1GenericConstructed)aSN1Constructed).elementAt(n3))));
                        }
                        break;
                    }
                    case 1: {
                        int n3;
                        this.crls = new ArrayList();
                        int n4 = ((ASN1GenericConstructed)aSN1Constructed).size();
                        for (n3 = 0; n3 < n4; ++n3) {
                            this.crls.add(new CRL(Utils.toStream(((ASN1GenericConstructed)aSN1Constructed).elementAt(n3))));
                        }
                        break;
                    }
                }
                ++n2;
            }
            aSN1Constructed = (ASN1Set)aSN1Sequence2.elementAt(n2);
            if (((ASN1Set)aSN1Constructed).elementsAsList().size() > 0) {
                n2 = 0;
                ASN1Sequence aSN1Sequence3 = (ASN1Sequence)((ASN1Set)aSN1Constructed).elementAt(0);
                int n5 = ++n2;
                ASN1TaggedObject aSN1TaggedObject = (ASN1Sequence)aSN1Sequence3.elementAt(n5);
                this.issuer = new X500Name((ASN1Sequence)((ASN1Sequence)aSN1TaggedObject).elementAt(0));
                this.serialNo = ((ASN1Integer)((ASN1Sequence)aSN1TaggedObject).elementAt(1)).getValue();
                int n6 = ++n2;
                this.mdAlg = new AlgorithmIdentifier(Utils.toStream((ASN1Sequence)aSN1Sequence3.elementAt(n6)));
                if (aSN1Sequence3.elementAt(++n2) instanceof ASN1GenericConstructed) {
                    aSN1TaggedObject = new ASN1Set(((ASN1GenericConstructed)aSN1Sequence3.elementAt(n2++)).elementsAsList());
                    this.aaBytes = Utils.toBytes(aSN1TaggedObject);
                    this.hashBytes = null;
                    ArrayList<ASN1Object> arrayList = ((ASN1Set)aSN1TaggedObject).elementsAsList();
                    int n7 = arrayList.size();
                    for (int i2 = 0; i2 < n7; ++i2) {
                        ASN1Sequence aSN1Sequence4 = (ASN1Sequence)arrayList.get(i2);
                        ASN1ObjectID aSN1ObjectID2 = (ASN1ObjectID)aSN1Sequence4.elementAt(0);
                        if (!aSN1ObjectID2.equals(ASN1Utils.pkcsID, 9, 4)) continue;
                        this.hashBytes = ((ASN1OctetString)((ASN1Set)aSN1Sequence4.elementAt(1)).elementAt(0)).getValue();
                    }
                    if (this.hashBytes == null) {
                        throw new IOException("No message digest found in authenticatedAttributes");
                    }
                }
                if (!((ASN1ObjectID)(aSN1TaggedObject = (ASN1ObjectID)((ASN1Sequence)aSN1Sequence3.elementAt(n2++)).elementAt(0))).equals(AlgID.rsaEncryption.getOID())) {
                    throw new IOException("Unsupported encryption algorithm " + aSN1TaggedObject);
                }
                this.sigBytes = ((ASN1OctetString)aSN1Sequence3.elementAt(n2++)).getValue();
            }
        }
        catch (ClassCastException classCastException) {
            throw new ASN1FormatException(classCastException.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ASN1FormatException(indexOutOfBoundsException.toString());
        }
    }

    @Override
    public int length() {
        return this.outputASN1().length();
    }

    public byte[] getEncoded() {
        return Utils.toBytes(this.outputASN1());
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }
}

