/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.X509CRLEntry;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import oracle.security.crypto.asn1.ASN1Date;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.cert.X509ExtensionSet;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class RevokedCertificate
extends X509CRLEntry
implements Externalizable,
ASN1Object {
    private BigInteger serialNo;
    private Date revocationDate;
    private X509ExtensionSet extensions = null;
    private ASN1Sequence seq = null;

    public RevokedCertificate() {
    }

    public RevokedCertificate(BigInteger bigInteger, Date date) {
        this.serialNo = bigInteger;
        this.revocationDate = date;
    }

    public RevokedCertificate(BigInteger bigInteger, Date date, X509ExtensionSet x509ExtensionSet) {
        this(bigInteger, date);
        if (x509ExtensionSet != null && x509ExtensionSet.size() > 0) {
            this.extensions = x509ExtensionSet;
        }
    }

    public RevokedCertificate(BigInteger bigInteger, Date date, Vector<X509Extension> vector) {
        this(bigInteger, date, (List<X509Extension>)vector);
    }

    public RevokedCertificate(BigInteger bigInteger, Date date, List<X509Extension> list) {
        this(bigInteger, date);
        if (list != null && list.size() > 0) {
            this.extensions = new X509ExtensionSet(list);
        }
    }

    public RevokedCertificate(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public BigInteger getSerialNo() {
        return this.serialNo;
    }

    @Override
    public Date getRevocationDate() {
        return this.revocationDate;
    }

    public void addExtension(X509Extension x509Extension) {
        if (this.extensions == null) {
            this.extensions = new X509ExtensionSet();
        }
        this.extensions.addExtension(x509Extension);
    }

    public X509ExtensionSet getExtensionSet() {
        return this.extensions;
    }

    public Vector<X509Extension> getExtensions() {
        return this.extensions != null ? this.extensions.getExtensions() : null;
    }

    public ArrayList<X509Extension> getExtensionsAsList() {
        return this.extensions != null ? this.extensions.getExtensionsAsList() : null;
    }

    public Map<ASN1ObjectID, X509Extension> getExtensionsAsMap() {
        return this.extensions != null ? this.extensions.getExtensionsAsMap() : null;
    }

    public Enumeration<ASN1ObjectID> extensionTypes() {
        return this.extensions != null ? this.extensions.types() : null;
    }

    public X509Extension getExtension(ASN1ObjectID aSN1ObjectID) {
        return this.extensions != null ? this.extensions.getExtension(aSN1ObjectID) : null;
    }

    @Override
    public X500Principal getCertificateIssuer() {
        return null;
    }

    @Override
    public byte[] getEncoded() throws CRLException {
        return Utils.toBytes(this);
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.getSerialNo();
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null;
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        return this.extensions.getCriticalExtensionOIDs();
    }

    @Override
    public byte[] getExtensionValue(String string) {
        return this.extensions.getExtensionValue(string);
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        return this.extensions.getNonCriticalExtensionOIDs();
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        return this.extensions.hasUnsupportedCriticalExtension();
    }

    @Override
    public String toString() {
        String string = "serialNo = " + this.serialNo + ", revocationDate = " + this.revocationDate;
        if (this.extensions != null && this.extensions.size() > 0) {
            string = string + ", extensions = " + this.extensions;
        }
        return string;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.reset();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.serialNo = new ASN1Integer(aSN1SequenceInputStream).getValue();
        this.revocationDate = new ASN1Date(aSN1SequenceInputStream).getValue();
        this.extensions = aSN1SequenceInputStream.hasMoreData() ? new X509ExtensionSet(aSN1SequenceInputStream) : null;
        aSN1SequenceInputStream.terminate();
    }

    private void reset() {
        this.seq = null;
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.seq == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(new ASN1Integer(this.getSerialNo()));
            aSN1Sequence.addElement(new ASN1Date(this.getRevocationDate()));
            if (this.extensions != null && this.extensions.size() > 0) {
                aSN1Sequence.addElement(this.extensions);
            }
            this.seq = aSN1Sequence;
        }
        return this.seq;
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.toASN1Sequence().output(outputStream);
    }

    @Override
    public int length() {
        return this.toASN1Sequence().length();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }
}

