/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.cert.CRL;
import oracle.security.crypto.cert.CertificateTrustPolicy;
import oracle.security.crypto.cert.CertificateVerifier;
import oracle.security.crypto.cert.IssuerAndSerialNo;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cert.ext.BasicConstraintsExtension;
import oracle.security.crypto.core.AuthenticationException;

public class TrustedCAPolicy
implements CertificateTrustPolicy {
    private boolean requireCRL = false;
    private boolean requireCA = true;
    private LinkedHashMap<X500Name, X509> trustedTable = new LinkedHashMap();

    public TrustedCAPolicy() {
    }

    public TrustedCAPolicy(Vector<X509> vector, boolean bl2, boolean bl3) {
        this((List<X509>)vector, bl2, bl3);
    }

    public TrustedCAPolicy(List<X509> list, boolean bl2, boolean bl3) {
        this.setTrustedCAs(list);
        this.requireCRL = bl2;
        this.requireCA = bl3;
    }

    @Override
    public CertificateVerifier makeCertificateVerifier(Vector<X509> vector, Vector<CRL> vector2) {
        return this.makeCertificateVerifier((List<X509>)vector, (List<CRL>)vector2);
    }

    public CertificateVerifier makeCertificateVerifier(List<X509> list, List<CRL> list2) {
        return new TrustedCACertificateVerifier(list, list2);
    }

    public void addTrustedCA(X509 x509) {
        this.trustedTable.put(x509.getSubject(), x509);
    }

    public void setRequireCRLs(boolean bl2) {
        this.requireCRL = bl2;
    }

    public boolean getRequireCRLs() {
        return this.requireCRL;
    }

    public void setRequireCAFlag(boolean bl2) {
        this.requireCA = bl2;
    }

    public boolean getRequireCAFlag() {
        return this.requireCA;
    }

    public void setTrustedCAs(Vector<X509> vector) {
        this.setTrustedCAs((List<X509>)vector);
    }

    public void setTrustedCAs(List<X509> list) {
        this.trustedTable.clear();
        if (list == null) {
            return;
        }
        for (X509 x509 : list) {
            this.trustedTable.put(x509.getSubject(), x509);
        }
    }

    @Deprecated
    public Enumeration<X509> trustedCAs() {
        return this.trustedTable == null ? null : new Vector<X509>(this.trustedTable.values()).elements();
    }

    public ArrayList<X509> getTrustedCAs() {
        return this.trustedTable == null ? null : new ArrayList<X509>(this.trustedTable.values());
    }

    class TrustedCACertificateVerifier
    implements CertificateVerifier {
        private LinkedHashMap<IssuerAndSerialNo, X509> iasnTable = new LinkedHashMap();
        private LinkedHashMap<X500Name, X509> subjectTable = new LinkedHashMap();
        private LinkedHashMap<X500Name, CRL> crlTable = new LinkedHashMap();

        TrustedCACertificateVerifier(List<X509> list, List<CRL> list2) {
            if (list != null) {
                int n2 = list.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    X509 x509 = list.get(i2);
                    IssuerAndSerialNo issuerAndSerialNo = new IssuerAndSerialNo(x509);
                    this.iasnTable.put(issuerAndSerialNo, x509);
                    this.subjectTable.put(x509.getSubject(), x509);
                }
            }
            if (list2 != null) {
                for (CRL cRL : list2) {
                    this.crlTable.put(cRL.getIssuer(), cRL);
                }
            }
        }

        @Override
        public X509 getValidCertificate(IssuerAndSerialNo issuerAndSerialNo) throws AuthenticationException {
            X509 x509;
            X509 x5092 = this.iasnTable.get(issuerAndSerialNo);
            if (x5092 == null) {
                return null;
            }
            if (TrustedCAPolicy.this.trustedTable.containsKey(x5092.getSubject())) {
                return x5092;
            }
            ArrayList<X509> arrayList = new ArrayList<X509>();
            X500Name x500Name = null;
            while (x5092 != null) {
                x509 = this.subjectTable.get(x5092.getIssuer());
                if (x509 != null && arrayList.contains(x509)) {
                    throw new AuthenticationException("Chain does not terminate with a trusted CA");
                }
                arrayList.add(x5092);
                x500Name = x5092.getIssuer();
                x5092 = this.subjectTable.get(x500Name);
                if (TrustedCAPolicy.this.trustedTable.containsKey(x500Name)) break;
                if (x5092 != null) continue;
                throw new AuthenticationException("Chain does not terminate with a trusted CA");
            }
            x509 = (X509)TrustedCAPolicy.this.trustedTable.get(x500Name);
            boolean bl2 = false;
            while (!arrayList.isEmpty()) {
                BasicConstraintsExtension basicConstraintsExtension;
                x5092 = (X509)arrayList.get(arrayList.size() - 1);
                CRL cRL = this.crlTable.get(x509.getSubject());
                x5092.setIssuerCertificate(x509);
                if (cRL != null) {
                    x5092.setIssuerCRL(cRL);
                } else if (TrustedCAPolicy.this.requireCRL) {
                    throw new AuthenticationException("CRL not found for certificate");
                }
                if (TrustedCAPolicy.this.requireCA && bl2 && ((basicConstraintsExtension = (BasicConstraintsExtension)x509.getExtension(PKIX.id_ce_basicConstraints)) == null || !basicConstraintsExtension.getCA())) {
                    throw new AuthenticationException("Certificate is not a CA");
                }
                if (!x5092.verify()) {
                    throw new AuthenticationException("Certificate invalid");
                }
                x509 = x5092;
                arrayList.remove(arrayList.size() - 1);
                bl2 = true;
            }
            return x5092;
        }
    }
}

