/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1String;
import oracle.security.crypto.cert.Entity;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X500RDN;
import oracle.security.crypto.util.InvalidFormatException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class X500Name
extends Entity
implements ASN1Object {
    private ArrayList<X500RDN> rdnSequence = new ArrayList();
    private String countryName = null;
    private String stateName = null;
    private String localityName = null;
    private String organizationName = null;
    private String orgUnitName = null;
    private String email = null;
    private String serialNumber = null;
    private ASN1Sequence contents;
    private String stringContents;
    private int hash = -1;

    public X500Name() {
    }

    public X500Name(String string) {
        this.input(string);
    }

    public X500Name(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public static X500Name toX500Name(X500Principal x500Principal) {
        try {
            return new X500Name(new UnsyncByteArrayInputStream(x500Principal.getEncoded()));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    X500Name(ASN1Sequence aSN1Sequence) throws IOException {
        this.input(aSN1Sequence);
    }

    public void addComponent(X500RDN x500RDN) {
        this.rdnSequence.add(x500RDN);
        for (ASN1ObjectID aSN1ObjectID : x500RDN.getValues().keySet()) {
            ASN1Object aSN1Object = x500RDN.getValue(aSN1ObjectID);
            if (!(aSN1Object instanceof ASN1String)) continue;
            ASN1String aSN1String = (ASN1String)aSN1Object;
            if (aSN1ObjectID.equals(PKIX.id_at_commonName)) {
                this.setName(aSN1String.getValue());
                continue;
            }
            if (aSN1ObjectID.equals(PKIX.id_at_countryName)) {
                this.countryName = aSN1String.getValue();
                continue;
            }
            if (aSN1ObjectID.equals(PKIX.id_at_localityName)) {
                this.localityName = aSN1String.getValue();
                continue;
            }
            if (aSN1ObjectID.equals(PKIX.id_at_stateOrProvinceName)) {
                this.stateName = aSN1String.getValue();
                continue;
            }
            if (aSN1ObjectID.equals(PKIX.id_at_organizationName)) {
                this.organizationName = aSN1String.getValue();
                continue;
            }
            if (aSN1ObjectID.equals(PKIX.id_at_organizationalUnitName)) {
                this.orgUnitName = aSN1String.getValue();
                continue;
            }
            if (aSN1ObjectID.equals(PKIX.emailAddress)) {
                this.email = aSN1String.getValue();
                continue;
            }
            if (!aSN1ObjectID.equals(PKIX.id_at_serialNumber)) continue;
            this.serialNumber = aSN1String.getValue();
        }
        this.stringContents = null;
        this.contents = null;
        this.hash = -1;
    }

    public void addComponent(ASN1ObjectID aSN1ObjectID, ASN1String aSN1String) {
        this.addComponent(new X500RDN(aSN1ObjectID, aSN1String));
    }

    public void addComponent(ASN1ObjectID aSN1ObjectID, String string) {
        this.addComponent(new X500RDN(aSN1ObjectID, string));
    }

    public void addComponent(String string, String string2) {
        this.addComponent(X500RDN.getTypeID(string), string2);
    }

    public ASN1Object getAttributeValue(String string) {
        return this.getAttributeValue(X500RDN.getTypeID(string));
    }

    public ASN1Object getAttributeValue(ASN1ObjectID aSN1ObjectID) {
        X500RDN x500RDN = this.getAttribute(aSN1ObjectID);
        return x500RDN != null ? x500RDN.getValue(aSN1ObjectID) : null;
    }

    public X500RDN getAttribute(String string) {
        ASN1ObjectID aSN1ObjectID = X500RDN.getTypeID(string);
        return aSN1ObjectID != null ? this.getAttribute(aSN1ObjectID) : null;
    }

    public X500RDN getAttribute(ASN1ObjectID aSN1ObjectID) {
        for (X500RDN x500RDN : this.getComponentsAsList()) {
            if (x500RDN == null || x500RDN.getValue(aSN1ObjectID) == null) continue;
            return x500RDN;
        }
        return null;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.reset();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        while (aSN1SequenceInputStream.hasMoreData()) {
            this.addComponent(new X500RDN(aSN1SequenceInputStream));
        }
        aSN1SequenceInputStream.terminate();
    }

    void input(ASN1Sequence aSN1Sequence) throws IOException {
        this.input(Utils.toStream(aSN1Sequence));
    }

    public void input(String string) throws InvalidFormatException {
        this.reset();
        boolean bl2 = true;
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (X500RDN.isWhitespace(string.charAt(i2))) continue;
            bl2 = false;
            break;
        }
        if (bl2) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        n2 = 0;
        boolean bl3 = false;
        int n3 = 0;
        ArrayList<X500RDN> arrayList = new ArrayList<X500RDN>();
        while (n3 < string.length()) {
            try {
                char c2 = string.charAt(n3);
                if (c2 == '\"') {
                    n2 = n2 == 0 ? 1 : 0;
                    stringBuffer.append(c2);
                } else if (c2 == ',' || c2 == ';') {
                    if (n2 != 0) {
                        stringBuffer.append(c2);
                    } else {
                        bl3 = true;
                    }
                } else if (c2 == '\\') {
                    stringBuffer.append(c2);
                    c2 = string.charAt(++n3);
                    stringBuffer.append(c2);
                } else {
                    stringBuffer.append(c2);
                }
                if (!bl3 && ++n3 != string.length()) continue;
                arrayList.add(new X500RDN(stringBuffer.toString()));
                stringBuffer = new StringBuffer();
                n2 = 0;
                bl3 = false;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new InvalidFormatException("Malformed DN string");
            }
        }
        X500RDN[] x500RDNArray = arrayList.toArray(new X500RDN[arrayList.size()]);
        for (int i3 = x500RDNArray.length - 1; i3 >= 0; --i3) {
            this.addComponent(x500RDNArray[i3]);
        }
    }

    private void reset() {
        this.rdnSequence.clear();
        this.countryName = null;
        this.stateName = null;
        this.localityName = null;
        this.organizationName = null;
        this.orgUnitName = null;
        this.email = null;
        this.serialNumber = null;
        this.stringContents = null;
        this.contents = null;
        this.hash = -1;
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.outputASN1().output(outputStream);
    }

    @Override
    public int length() {
        return this.outputASN1().length();
    }

    ASN1Sequence outputASN1() {
        if (this.contents == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            int n2 = this.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                aSN1Sequence.addElement(this.rdnSequence.get(i2));
            }
            this.contents = aSN1Sequence;
        }
        return this.contents;
    }

    public String toString() {
        if (this.stringContents == null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = this.size() - 1; i2 >= 0; --i2) {
                X500RDN x500RDN = this.componentAt(i2);
                stringBuffer.append(x500RDN.toString());
                stringBuffer.append(',');
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.setLength(stringBuffer.length() - 1);
            }
            this.stringContents = stringBuffer.toString();
        }
        return this.stringContents;
    }

    public Vector<X500RDN> getComponents() {
        ArrayList<X500RDN> arrayList = this.getComponentsAsList();
        return arrayList == null ? null : new VectorOverArrayList<X500RDN>(arrayList);
    }

    public ArrayList<X500RDN> getComponentsAsList() {
        if (this.rdnSequence == null) {
            this.rdnSequence = new ArrayList();
            if (this.countryName != null) {
                this.rdnSequence.add(new X500RDN(PKIX.id_at_countryName, this.countryName));
            }
            if (this.stateName != null) {
                this.rdnSequence.add(new X500RDN(PKIX.id_at_stateOrProvinceName, this.stateName));
            }
            if (this.localityName != null) {
                this.rdnSequence.add(new X500RDN(PKIX.id_at_localityName, this.localityName));
            }
            if (this.organizationName != null) {
                this.rdnSequence.add(new X500RDN(PKIX.id_at_organizationName, this.organizationName));
            }
            if (this.orgUnitName != null) {
                this.rdnSequence.add(new X500RDN(PKIX.id_at_organizationalUnitName, this.orgUnitName));
            }
            if (this.getName() != null) {
                this.rdnSequence.add(new X500RDN(PKIX.id_at_commonName, this.getName()));
            }
            if (this.email != null) {
                this.rdnSequence.add(new X500RDN(PKIX.emailAddress, this.email));
            }
            if (this.serialNumber != null) {
                this.rdnSequence.add(new X500RDN(PKIX.id_at_serialNumber, this.serialNumber));
            }
        }
        return this.rdnSequence;
    }

    public Enumeration<X500RDN> components() {
        return this.getComponents().elements();
    }

    public int size() {
        return this.getComponents().size();
    }

    public X500RDN componentAt(int n2) {
        return this.getComponents().elementAt(n2);
    }

    private void clearNewAPI() {
        this.rdnSequence = null;
        this.contents = null;
        this.stringContents = null;
        this.hash = -1;
    }

    public String getCountryName() {
        return this.countryName;
    }

    public void setCountryName(String string) {
        this.countryName = string;
        this.clearNewAPI();
    }

    public String getStateName() {
        return this.stateName;
    }

    public void setStateName(String string) {
        this.stateName = string;
        this.clearNewAPI();
    }

    public String getLocalityName() {
        return this.localityName;
    }

    public void setLocalityName(String string) {
        this.localityName = string;
        this.clearNewAPI();
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public void setOrganizationName(String string) {
        this.organizationName = string;
        this.clearNewAPI();
    }

    public String getOrgUnitName() {
        return this.orgUnitName;
    }

    public void setOrgUnitName(String string) {
        this.orgUnitName = string;
        this.clearNewAPI();
    }

    public String getCommonName() {
        return this.getName();
    }

    public void setCommonName(String string) {
        this.setName(string);
        this.clearNewAPI();
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String string) {
        this.email = string;
        this.clearNewAPI();
    }

    public void setAttr(String string, String string2) {
        if (string.equalsIgnoreCase("C")) {
            this.setCountryName(string2);
        } else if (string.equalsIgnoreCase("ST")) {
            this.setStateName(string2);
        } else if (string.equalsIgnoreCase("L")) {
            this.setLocalityName(string2);
        } else if (string.equalsIgnoreCase("O")) {
            this.setOrganizationName(string2);
        } else if (string.equalsIgnoreCase("OU")) {
            this.setOrgUnitName(string2);
        } else if (string.equalsIgnoreCase("CN")) {
            this.setName(string2);
        } else if (string.equalsIgnoreCase("Email")) {
            this.setEmail(string2);
        } else if (string.equalsIgnoreCase("EmailAddress")) {
            this.setEmail(string2);
        } else {
            throw new IllegalArgumentException("Attribute '" + string + "' cannot be set using setAttr(String, String), only {C, ST, L, O, OU, CN, EMAIL (or EMAILADDRESS)} are allowed.");
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof X500Principal) {
            return this.toX500Principal().equals(object);
        }
        if (object instanceof X500Name) {
            X500Name x500Name = (X500Name)object;
            if (x500Name.size() != this.size()) {
                return false;
            }
            int n2 = this.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.componentAt(i2).equals(x500Name.componentAt(i2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == -1) {
            this.hash = this.toString().hashCode();
        }
        return this.hash;
    }

    public X500Principal toX500Principal() {
        return new X500Principal(Utils.toBytes(this.outputASN1()));
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray = (byte[])objectInput.readObject();
        this.input(new UnsyncByteArrayInputStream(byArray));
    }
}

