/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Set;
import oracle.security.crypto.asn1.ASN1SetInputStream;
import oracle.security.crypto.asn1.ASN1String;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.AttributeTypeAndValue;
import oracle.security.crypto.cert.OIDRegistrar;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.util.InvalidFormatException;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.OIDManager;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.UnsyncByteArrayOutputStream;
import oracle.security.crypto.util.Utils;

public class X500RDN
implements Externalizable,
ASN1Object {
    private LinkedHashMap<ASN1ObjectID, AttributeTypeAndValue> attrSet = new LinkedHashMap();
    private ASN1Set contents = null;

    public X500RDN() {
    }

    public X500RDN(ASN1ObjectID aSN1ObjectID, ASN1Object aSN1Object) {
        this.attrSet.put(aSN1ObjectID, new AttributeTypeAndValue(aSN1ObjectID, aSN1Object));
    }

    public X500RDN(ASN1ObjectID aSN1ObjectID, String string) {
        this.addAttribute(aSN1ObjectID, string);
    }

    public X500RDN(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    X500RDN(String string) {
        this.input(string);
    }

    public void addAttribute(ASN1ObjectID aSN1ObjectID, ASN1Object aSN1Object) {
        this.contents = null;
        this.attrSet.put(aSN1ObjectID, new AttributeTypeAndValue(aSN1ObjectID, aSN1Object));
    }

    public void addAttribute(ASN1ObjectID aSN1ObjectID, String string) {
        int n2 = aSN1ObjectID.equals(PKIX.emailAddress) || aSN1ObjectID.equals(PKIX.id_domainComponent) ? 22 : 19;
        char[] cArray = string.toCharArray();
        int n3 = cArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (cArray[i2] <= '\u007f' && (n2 != 19 || X500RDN.isASN1Printable(cArray[i2]))) continue;
            n2 = 12;
            break;
        }
        this.addAttribute(aSN1ObjectID, new ASN1String(string, n2));
    }

    private void addAttribute(AttributeTypeAndValue attributeTypeAndValue) {
        this.contents = null;
        this.attrSet.put(attributeTypeAndValue.getType(), attributeTypeAndValue);
    }

    public Enumeration<ASN1ObjectID> types() {
        return this.attrSet == null ? null : new Vector<ASN1ObjectID>(this.attrSet.keySet()).elements();
    }

    public Map<ASN1ObjectID, AttributeTypeAndValue> getValues() {
        return this.attrSet;
    }

    public ASN1Object getValue(ASN1ObjectID aSN1ObjectID) {
        AttributeTypeAndValue attributeTypeAndValue = this.attrSet.get(aSN1ObjectID);
        return attributeTypeAndValue != null ? attributeTypeAndValue.getValue() : null;
    }

    public int hashCode() {
        return Utils.hashBytes(this.toASN1Set());
    }

    private static String fixWhitespace(String string) {
        String string2 = string.trim();
        if (string2.length() == 0) {
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2.charAt(0));
        int n2 = string2.length();
        for (int i2 = 1; i2 < n2; ++i2) {
            char c2 = string2.charAt(i2);
            if (Character.isWhitespace(c2)) {
                if (Character.isWhitespace(string2.charAt(i2 - 1))) continue;
                stringBuffer.append(' ');
                continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        X500RDN x500RDN = (X500RDN)object;
        if (this.attrSet.size() != x500RDN.attrSet.size()) {
            return false;
        }
        Iterator<AttributeTypeAndValue> iterator = this.attrSet.values().iterator();
        Iterator<AttributeTypeAndValue> iterator2 = x500RDN.attrSet.values().iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            AttributeTypeAndValue attributeTypeAndValue = iterator.next();
            AttributeTypeAndValue attributeTypeAndValue2 = iterator2.next();
            if (!attributeTypeAndValue.getType().equals(attributeTypeAndValue2.getType())) {
                return false;
            }
            if (attributeTypeAndValue.getValue().getClass() != attributeTypeAndValue2.getValue().getClass()) {
                return false;
            }
            if (attributeTypeAndValue.getValue() instanceof ASN1String) {
                ASN1String aSN1String = (ASN1String)attributeTypeAndValue.getValue();
                ASN1String aSN1String2 = (ASN1String)attributeTypeAndValue2.getValue();
                if (!(aSN1String.getTag() == 19 && aSN1String2.getTag() == 19 ? !X500RDN.fixWhitespace(aSN1String.getValue()).equalsIgnoreCase(X500RDN.fixWhitespace(aSN1String2.getValue())) : !aSN1String.getValue().equals(aSN1String2.getValue()))) continue;
                return false;
            }
            if (Utils.areEqual(Utils.toBytes(attributeTypeAndValue.getValue()), Utils.toBytes(attributeTypeAndValue2.getValue()))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.toString(false);
    }

    private String toString(boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (AttributeTypeAndValue attributeTypeAndValue : this.attrSet.values()) {
            String string = X500RDN.getTypeName(attributeTypeAndValue.getType());
            stringBuffer.append(string != null ? string : attributeTypeAndValue.getType().toStringCompact());
            stringBuffer.append('=');
            ASN1Object aSN1Object = attributeTypeAndValue.getValue();
            if (aSN1Object instanceof ASN1String) {
                stringBuffer.append(X500RDN.escapeValue(((ASN1String)aSN1Object).getValue(), bl2));
            } else {
                stringBuffer.append('#');
                stringBuffer.append(Utils.toHexString(Utils.toBytes(aSN1Object)));
            }
            stringBuffer.append('+');
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public String toASCII() {
        return this.toString(true);
    }

    static String escapeValue(String string, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            CharSequence charSequence;
            char c2 = string.charAt(i2);
            if (bl2 && c2 >= '\u0080') {
                charSequence = new StringBuffer();
                while (true) {
                    ((StringBuffer)charSequence).append(c2);
                    if (i2 == string.length() || string.charAt(i2 + 1) < '\u0080') break;
                    c2 = string.charAt(++i2);
                }
                String string2 = Utils.toHexString(Utils.toUTF8(((StringBuffer)charSequence).toString()));
                int n3 = string2.length();
                for (int i3 = 0; i3 < n3; i3 += 2) {
                    stringBuffer.append('\\');
                    stringBuffer.append(string2.charAt(i3));
                    stringBuffer.append(string2.charAt(i3 + 1));
                }
                continue;
            }
            if (c2 < ' ' || c2 == '\u007f' || i2 == 0 && c2 == ' ' || i2 == string.length() - 1 && c2 == ' ') {
                charSequence = Integer.toString(c2, 16);
                stringBuffer.append('\\');
                if (c2 < '\u0010') {
                    stringBuffer.append('0');
                }
                stringBuffer.append((String)charSequence);
                continue;
            }
            if (X500RDN.isSpecial(c2) || c2 == '\\' || c2 == '\"') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    static String unescapeValue(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (string.charAt(i2) == '\\' && i2 < string.length() - 1) {
                stringBuffer.append(string.charAt(++i2));
                continue;
            }
            stringBuffer.append(string.charAt(i2));
        }
        return stringBuffer.toString();
    }

    static ASN1ObjectID getTypeID(String string) {
        return OIDManager.getOIDManager().getAttributeType(string);
    }

    private static String getTypeName(ASN1ObjectID aSN1ObjectID) {
        return OIDManager.getOIDManager().getAttributeName(aSN1ObjectID);
    }

    private static boolean isAlpha(char c2) {
        return c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z';
    }

    private static boolean isDigit(char c2) {
        return c2 >= '0' && c2 <= '9';
    }

    private static boolean isHexChar(char c2) {
        return X500RDN.isDigit(c2) || c2 >= 'A' && c2 <= 'F' || c2 >= 'a' && c2 <= 'f';
    }

    private static boolean isSpecial(char c2) {
        return c2 == ',' || c2 == '+' || c2 == '=' || c2 == '<' || c2 == '>' || c2 == ';' || c2 == '#';
    }

    static boolean isWhitespace(char c2) {
        return c2 == ' ' || c2 == '\t' || c2 == '\r' || c2 == '\n';
    }

    static boolean isASN1Printable(char c2) {
        return X500RDN.isAlpha(c2) || X500RDN.isDigit(c2) || c2 == ' ' || c2 == '\'' || c2 == '(' || c2 == ')' || c2 == '+' || c2 == ',' || c2 == '-' || c2 == '.' || c2 == '/' || c2 == ':' || c2 == '=' || c2 == '?';
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.contents = null;
        this.attrSet = new LinkedHashMap();
        ASN1SetInputStream aSN1SetInputStream = new ASN1SetInputStream(inputStream);
        while (aSN1SetInputStream.hasMoreData()) {
            AttributeTypeAndValue attributeTypeAndValue = new AttributeTypeAndValue(aSN1SetInputStream);
            if (attributeTypeAndValue == null) continue;
            this.attrSet.put(attributeTypeAndValue.getType(), attributeTypeAndValue);
        }
        aSN1SetInputStream.terminate();
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.toASN1Set().output(outputStream);
    }

    @Override
    public int length() {
        return this.toASN1Set().length();
    }

    private ASN1Set toASN1Set() {
        if (this.contents == null) {
            ASN1Set aSN1Set = new ASN1Set();
            Iterator<AttributeTypeAndValue> iterator = this.attrSet.values().iterator();
            while (iterator.hasNext()) {
                aSN1Set.addElement(iterator.next());
            }
            this.contents = aSN1Set;
        }
        return this.contents;
    }

    private void input(String string) {
        this.contents = null;
        this.attrSet = new LinkedHashMap();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = 0;
        while (n2 < string.length()) {
            char c2 = string.charAt(n2);
            if (c2 == '+' && !bl2 && n2 > 0 && string.charAt(n2 - 1) != '\\') {
                bl3 = true;
            } else if (c2 == '\"') {
                bl2 = !bl2;
                stringBuffer.append(c2);
            } else {
                stringBuffer.append(c2);
            }
            if (!bl3 && ++n2 != string.length()) continue;
            this.parseAttribute(stringBuffer.toString());
            stringBuffer = new StringBuffer();
            bl2 = false;
            bl3 = false;
        }
    }

    private void parseAttribute(String string) {
        String string2;
        int n2;
        int n3 = 0;
        n3 = string.indexOf("=");
        if (n3 == -1) {
            throw new InvalidFormatException("'=' missing in attribute");
        }
        for (n2 = 0; n2 < n3 && X500RDN.isWhitespace(string.charAt(n2)); ++n2) {
        }
        if (n2 == n3) {
            throw new InvalidFormatException("Attribute type missing");
        }
        int n4 = n3 - 1;
        while (n4 >= 0 & X500RDN.isWhitespace(string.charAt(n4))) {
            --n4;
        }
        String string3 = string.substring(n2, n4 + 1);
        ASN1ObjectID aSN1ObjectID = X500RDN.isDigit(string3.charAt(0)) ? new ASN1ObjectID(string3) : (string3.toUpperCase().startsWith("OID.") ? new ASN1ObjectID(string3.substring(4)) : X500RDN.getTypeID(string3));
        if (aSN1ObjectID == null) {
            throw new InvalidFormatException("Malformed attribute type");
        }
        ++n3;
        while (n3 < string.length() && X500RDN.isWhitespace(string.charAt(n3))) {
            ++n3;
        }
        n2 = string.length() - 1;
        while (X500RDN.isWhitespace(string.charAt(n2))) {
            --n2;
        }
        String string4 = string2 = n2 >= n3 ? string.substring(n3, n2 + 1) : "";
        if (string2.startsWith("#") && string2.length() > 1) {
            try {
                this.addAttribute(aSN1ObjectID, ASN1Utils.inputASN1Object(Utils.fromHexString(string2.substring(1))));
                return;
            }
            catch (IOException iOException) {
                throw new InvalidFormatException("Malformed attribute value string");
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFormatException("Malformed attribute value string");
            }
        }
        boolean bl2 = false;
        if (string2.startsWith("\"")) {
            if (string2.length() == 1 || !string2.endsWith("\"")) {
                throw new InvalidFormatException("Missing final '\"'");
            }
            string2 = string2.substring(1, string2.length() - 1);
            bl2 = true;
        }
        StringBuffer stringBuffer = new StringBuffer(string2.length());
        int n5 = string2.length();
        for (n3 = 0; n3 < n5; ++n3) {
            char c2 = string2.charAt(n3);
            if (c2 == '\\') {
                try {
                    if (X500RDN.isHexChar(string2.charAt(n3 + 1))) {
                        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
                        while (true) {
                            unsyncByteArrayOutputStream.write(Integer.parseInt(string2.substring(n3 + 1, n3 + 3), 16));
                            if ((n3 += 2) >= string2.length() - 1 || string2.charAt(n3 + 1) != '\\' || !X500RDN.isHexChar(string2.charAt(n3 + 2))) break;
                            ++n3;
                        }
                        stringBuffer.append(Utils.fromUTF8(unsyncByteArrayOutputStream.toByteArray()));
                        continue;
                    }
                    if (X500RDN.isSpecial(c2 = string2.charAt(++n3)) || c2 == '\\' || c2 == '\"') {
                        stringBuffer.append(c2);
                        continue;
                    }
                    throw new IllegalArgumentException("Malformed attribute value string");
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new IllegalArgumentException("Malformed attribute value string");
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Malformed attribute value string");
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException.toString());
                }
            }
            if (!bl2 && (X500RDN.isSpecial(c2) || c2 == '\\' || c2 == '\"')) {
                throw new IllegalArgumentException("Malformed attribute value string");
            }
            if (bl2 && (c2 == '\\' || c2 == '\"')) {
                throw new IllegalArgumentException("Malformed attribute value string");
            }
            stringBuffer.append(c2);
        }
        this.addAttribute(aSN1ObjectID, stringBuffer.toString());
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }

    static {
        OIDRegistrar.mapAttributeTypeNames();
    }
}

