/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import oracle.security.crypto.asn1.ASN1BitString;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1Date;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.CRL;
import oracle.security.crypto.cert.Certificate;
import oracle.security.crypto.cert.CertificateRequest;
import oracle.security.crypto.cert.Entity;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.SPKAC;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.cert.X509ExtensionSet;
import oracle.security.crypto.cert.ext.BasicConstraintsExtension;
import oracle.security.crypto.cert.ext.ExtKeyUsageExtension;
import oracle.security.crypto.cert.ext.IssuerAltNameExtension;
import oracle.security.crypto.cert.ext.KeyUsageExtension;
import oracle.security.crypto.cert.ext.SubjectAltNameExtension;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.SignatureException;
import oracle.security.crypto.provider.JCEUtil;
import oracle.security.crypto.provider.TransitionMode;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.OutputGenerationException;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class X509
extends Certificate
implements ASN1Object {
    private ASN1Sequence tbsCert;
    private AlgorithmIdentifier sigAlgID;
    private byte[] sigBytes;
    private BigInteger serialNo;
    private X500Name issuer;
    private Date notBeforeDate;
    private Date notAfterDate;
    private X509ExtensionSet extensions = null;
    private PrivateKey issuerPrivateKey;
    private CRL issuerCRL;
    private X509Certificate issuerCertificate;
    protected boolean isDecoded = false;
    private int version = 3;
    private boolean[] issuerID;
    private boolean[] subjectID;
    private ASN1Sequence contents = null;
    X509CertificateImpl certImpl = new X509CertificateImpl();

    public X509() {
    }

    public X509(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public X509(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.input(fileInputStream);
        ((InputStream)fileInputStream).close();
    }

    public X509(URL uRL) throws IOException {
        InputStream inputStream = uRL.openStream();
        this.input(inputStream);
        inputStream.close();
    }

    public static X509 toX509(X509Certificate x509Certificate) {
        if (x509Certificate instanceof X509CertificateImpl) {
            return ((X509CertificateImpl)x509Certificate).toX509();
        }
        try {
            return new X509(x509Certificate.getEncoded());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new RuntimeException(certificateEncodingException);
        }
    }

    public X509(byte[] byArray) throws IOException {
        this(new UnsyncByteArrayInputStream(byArray));
    }

    public X509(CertificateRequest certificateRequest, X509 x509, oracle.security.crypto.core.PrivateKey privateKey, BigInteger bigInteger, int n2) throws SignatureException {
        this(certificateRequest, x509, privateKey, bigInteger, n2, null);
    }

    public X509(CertificateRequest certificateRequest, X509 x509, oracle.security.crypto.core.PrivateKey privateKey, BigInteger bigInteger, int n2, AlgorithmIdentifier algorithmIdentifier) throws SignatureException {
        this();
        this.holder = certificateRequest.getSubject();
        this.key = certificateRequest.getPublicKey();
        this.setIssuerCertificate(x509);
        this.issuer = (X500Name)x509.getHolder();
        this.issuerPrivateKey = privateKey;
        this.serialNo = bigInteger;
        this.setValidity(n2);
        if (algorithmIdentifier != null) {
            this.setSigAlgID(algorithmIdentifier);
        }
        this.sign();
    }

    public X509(X500Name x500Name, SPKAC sPKAC, X509 x509, oracle.security.crypto.core.PrivateKey privateKey, BigInteger bigInteger, int n2) throws SignatureException {
        this();
        this.holder = x500Name;
        this.key = sPKAC.getPublicKey();
        this.setIssuerCertificate(x509);
        this.issuer = (X500Name)x509.getHolder();
        this.issuerPrivateKey = privateKey;
        this.serialNo = bigInteger;
        this.setValidity(n2);
        this.sign();
    }

    public X509(X500Name x500Name, oracle.security.crypto.core.PublicKey publicKey, X500Name x500Name2, oracle.security.crypto.core.PrivateKey privateKey, BigInteger bigInteger, int n2) throws SignatureException {
        this(x500Name, publicKey, x500Name2, privateKey, bigInteger, n2, (AlgorithmIdentifier)null);
    }

    public X509(X500Name x500Name, oracle.security.crypto.core.PublicKey publicKey, X500Name x500Name2, oracle.security.crypto.core.PrivateKey privateKey, BigInteger bigInteger, int n2, AlgorithmIdentifier algorithmIdentifier) throws SignatureException {
        this();
        this.holder = x500Name;
        this.key = publicKey;
        this.issuer = x500Name2;
        this.issuerPrivateKey = privateKey;
        this.serialNo = bigInteger;
        this.setValidity(n2);
        if (algorithmIdentifier != null) {
            this.setSigAlgID(algorithmIdentifier);
        }
        this.sign();
    }

    public X509(X500Name x500Name, PublicKey publicKey, X500Name x500Name2, PrivateKey privateKey, BigInteger bigInteger, int n2, AlgorithmIdentifier algorithmIdentifier) throws SignatureException {
        this();
        this.holder = x500Name;
        this.key = CryptoUtils.fromJCEPublicKey(publicKey);
        this.issuer = x500Name2;
        this.issuerPrivateKey = privateKey;
        this.serialNo = bigInteger;
        this.setValidity(n2);
        if (algorithmIdentifier != null) {
            this.setSigAlgID(algorithmIdentifier);
        }
        this.sign();
    }

    public X509(X500Name x500Name, oracle.security.crypto.core.PublicKey publicKey, X500Name x500Name2, oracle.security.crypto.core.PrivateKey privateKey, BigInteger bigInteger, Date date, Date date2) throws SignatureException {
        this(x500Name, publicKey, x500Name2, privateKey, bigInteger, date, date2, (AlgorithmIdentifier)null);
    }

    public X509(X500Name x500Name, oracle.security.crypto.core.PublicKey publicKey, X500Name x500Name2, oracle.security.crypto.core.PrivateKey privateKey, BigInteger bigInteger, Date date, Date date2, AlgorithmIdentifier algorithmIdentifier) throws SignatureException {
        this();
        this.holder = x500Name;
        this.key = publicKey;
        this.issuer = x500Name2;
        this.issuerPrivateKey = privateKey;
        this.serialNo = bigInteger;
        this.notBeforeDate = date;
        this.notAfterDate = date2;
        if (algorithmIdentifier != null) {
            this.setSigAlgID(algorithmIdentifier);
        }
        this.sign();
    }

    public X509(X500Name x500Name, PublicKey publicKey, X500Name x500Name2, PrivateKey privateKey, BigInteger bigInteger, Date date, Date date2, AlgorithmIdentifier algorithmIdentifier) throws SignatureException {
        this();
        this.holder = x500Name;
        this.key = CryptoUtils.fromJCEPublicKey(publicKey);
        this.issuer = x500Name2;
        this.issuerPrivateKey = privateKey;
        this.serialNo = bigInteger;
        this.notBeforeDate = date;
        this.notAfterDate = date2;
        if (algorithmIdentifier != null) {
            this.setSigAlgID(algorithmIdentifier);
        }
        this.sign();
    }

    protected void decode() {
        this.isDecoded = true;
    }

    public void sign() throws SignatureException {
        if (!this.isDecoded) {
            this.decode();
        }
        if (this.issuerPrivateKey == null) {
            throw new SignatureException("Cannot sign certificate, no issuer private key set");
        }
        ASN1Sequence aSN1Sequence = this.getTBSCert();
        try {
            if (this.sigAlgID == null) {
                throw new SignatureException("Cannot sign certificate, no signature algorithm set");
            }
            if (this.issuerPrivateKey.getAlgorithm().equals("RSA") && CryptoUtils.getSignatureAlg(this.sigAlgID).contains("ECDSA")) {
                throw new SignatureException("Cannot create ECDSA signature using RSA keys");
            }
            Signature signature = JCEUtil.getSignatureInstance(CryptoUtils.getSignatureAlg(this.sigAlgID));
            signature.initSign(this.issuerPrivateKey);
            signature.update(Utils.toBytes(aSN1Sequence));
            this.sigBytes = signature.sign();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SignatureException(noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SignatureException(invalidKeyException);
        }
        catch (java.security.SignatureException signatureException) {
            throw new SignatureException(signatureException);
        }
        this.reset();
    }

    public void sign(RandomBitsSource randomBitsSource) throws SignatureException {
        this.sign();
    }

    public byte[] getSigBytes() throws SignatureException {
        if (!this.isDecoded) {
            this.decode();
        }
        if (this.sigBytes == null) {
            this.sign();
        }
        return this.sigBytes;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        int n2;
        int n3;
        Object object;
        Serializable serializable;
        Object object2;
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.tbsCert = new ASN1Sequence(aSN1SequenceInputStream);
        this.sigAlgID = new AlgorithmIdentifier(aSN1SequenceInputStream);
        this.sigBytes = ASN1BitString.inputValue(aSN1SequenceInputStream);
        aSN1SequenceInputStream.terminate();
        ASN1SequenceInputStream aSN1SequenceInputStream2 = new ASN1SequenceInputStream(Utils.toStream(this.tbsCert));
        if (aSN1SequenceInputStream2.getCurrentTag() == 0) {
            object2 = new ASN1ConstructedInputStream(aSN1SequenceInputStream2);
            serializable = ASN1Integer.inputValue((InputStream)object2);
            this.version = serializable.intValue() + 1;
            ((ASN1ConstructedInputStream)object2).terminate();
        }
        this.serialNo = ASN1Integer.inputValue(aSN1SequenceInputStream2);
        object2 = new AlgorithmIdentifier(aSN1SequenceInputStream2);
        if (!((AlgorithmIdentifier)object2).equals(this.sigAlgID)) {
            throw new IOException("Inconsistent signature algorithm IDs");
        }
        serializable = new X500Name(aSN1SequenceInputStream2);
        if (this.issuer == null) {
            this.issuer = serializable;
        } else if (!this.issuer.equals(serializable)) {
            throw new IOException("Expected issuer {" + this.issuer + "}, got issuer {" + serializable + "}");
        }
        ASN1SequenceInputStream aSN1SequenceInputStream3 = new ASN1SequenceInputStream(aSN1SequenceInputStream2);
        this.notBeforeDate = ASN1Date.inputValue(aSN1SequenceInputStream3);
        this.notAfterDate = ASN1Date.inputValue(aSN1SequenceInputStream3);
        aSN1SequenceInputStream3.terminate();
        this.holder = new X500Name(aSN1SequenceInputStream2);
        this.key = CryptoUtils.inputSPKI(aSN1SequenceInputStream2);
        if (aSN1SequenceInputStream2.getCurrentTag() == 1) {
            object = new ASN1BitString(aSN1SequenceInputStream2);
            this.issuerID = new boolean[((ASN1BitString)object).bitLength()];
            n3 = ((ASN1BitString)object).bitLength();
            for (n2 = 0; n2 < n3; ++n2) {
                this.issuerID[n2] = ((ASN1BitString)object).testBit(n2);
            }
        }
        if (aSN1SequenceInputStream2.getCurrentTag() == 2) {
            aSN1SequenceInputStream2.setCurrentTag(3);
            object = new ASN1BitString(aSN1SequenceInputStream2);
            this.subjectID = new boolean[((ASN1BitString)object).bitLength()];
            n3 = ((ASN1BitString)object).bitLength();
            for (n2 = 0; n2 < n3; ++n2) {
                this.subjectID[n2] = ((ASN1BitString)object).testBit(n2);
            }
        }
        if (aSN1SequenceInputStream2.getCurrentTag() == 3) {
            object = new ASN1ConstructedInputStream(aSN1SequenceInputStream2);
            this.extensions = new X509ExtensionSet((InputStream)object);
            ((ASN1ConstructedInputStream)object).terminate();
        } else {
            this.extensions = null;
        }
        aSN1SequenceInputStream2.terminate();
        this.reset();
    }

    private ASN1Sequence getTBSCert() throws SignatureException {
        if (!this.isDecoded) {
            this.decode();
        }
        if (this.tbsCert == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            if (this.extensions != null && this.extensions.size() > 0) {
                aSN1Sequence.addElement(new ASN1GenericConstructed(new ASN1Integer(2L), 0));
            }
            aSN1Sequence.addElement(new ASN1Integer(this.serialNo));
            if (this.sigAlgID == null && this.issuerPrivateKey != null) {
                if (this.issuerPrivateKey.getAlgorithm().equals("RSA")) {
                    this.sigAlgID = AlgID.sha256WithRSAEncryption;
                } else if (this.issuerPrivateKey.getAlgorithm().equals("DSA")) {
                    this.sigAlgID = AlgID.dsaWithSHA1;
                } else if (this.issuerPrivateKey.getAlgorithm().equals("EC")) {
                    int n2 = ((ECPrivateKey)this.issuerPrivateKey).getParams().getCurve().getField().getFieldSize();
                    switch (n2) {
                        case 256: {
                            this.sigAlgID = AlgID.ecdsaWithSHA256;
                            break;
                        }
                        case 384: {
                            this.sigAlgID = AlgID.ecdsaWithSHA384;
                            break;
                        }
                        case 512: {
                            this.sigAlgID = AlgID.ecdsaWithSHA512;
                            break;
                        }
                        default: {
                            this.sigAlgID = AlgID.ecdsaWithSHA1;
                        }
                    }
                }
            }
            if (this.sigAlgID == null) {
                throw new SignatureException("Cannot build to-be-signed certificate, no signature algorithm set");
            }
            aSN1Sequence.addElement(this.sigAlgID);
            aSN1Sequence.addElement(this.issuer);
            ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.notBeforeDate);
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(this.notAfterDate);
            aSN1Sequence2.addElement(new ASN1Date(this.notBeforeDate, calendar.get(1) > 2049));
            aSN1Sequence2.addElement(new ASN1Date(this.notAfterDate, calendar2.get(1) > 2049));
            aSN1Sequence.addElement(aSN1Sequence2);
            aSN1Sequence.addElement((X500Name)this.holder);
            aSN1Sequence.addElement(CryptoUtils.subjectPublicKeyInfo(this.key));
            if (this.extensions != null && this.extensions.size() > 0) {
                aSN1Sequence.addElement(new ASN1GenericConstructed(this.extensions, 3));
            }
            this.tbsCert = aSN1Sequence;
        }
        return this.tbsCert;
    }

    private ASN1Sequence toASN1Sequence() throws SignatureException {
        if (this.contents == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(this.getTBSCert());
            aSN1Sequence.addElement(this.sigAlgID);
            aSN1Sequence.addElement(new ASN1BitString(this.getSigBytes()));
            this.contents = aSN1Sequence;
        }
        return this.contents;
    }

    private void reset() {
        this.contents = null;
    }

    private void resetAll() {
        this.reset();
        this.tbsCert = null;
        this.sigBytes = null;
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        try {
            this.toASN1Sequence().output(outputStream);
        }
        catch (SignatureException signatureException) {
            throw new OutputGenerationException(signatureException);
        }
    }

    @Override
    public int length() {
        try {
            return this.toASN1Sequence().length();
        }
        catch (SignatureException signatureException) {
            throw new StreamableOutputException(signatureException);
        }
    }

    public byte[] getEncoded() {
        try {
            return Utils.toBytes(this.toASN1Sequence());
        }
        catch (SignatureException signatureException) {
            throw new StreamableOutputException(signatureException);
        }
    }

    @Override
    public boolean verify() throws AuthenticationException {
        if (!this.isDecoded) {
            this.decode();
        }
        if (this.hasUnrecognizedCriticalExtension()) {
            return false;
        }
        if (!this.verifyCertDate()) {
            return false;
        }
        if (this.issuerCertificate != null) {
            if (!this.verifyCertSigner()) {
                return false;
            }
            if (!this.issuer.equals(this.issuerCertificate.getSubjectX500Principal())) {
                return false;
            }
            if (!this.verifyCertSignature()) {
                return false;
            }
        }
        return this.issuerCRL == null || this.verifyCertCRL();
    }

    private boolean verifyCertSigner() {
        if (!this.isDecoded) {
            this.decode();
        }
        int n2 = this.issuerCertificate.getBasicConstraints();
        boolean[] blArray = this.issuerCertificate.getKeyUsage();
        return blArray == null || blArray[5];
    }

    public boolean verifyCertDate() {
        Date date;
        if (!this.isDecoded) {
            this.decode();
        }
        return !(date = new Date()).before(this.notBeforeDate) && !date.after(this.notAfterDate);
    }

    public boolean verifyCertSignature() throws AuthenticationException {
        if (!this.isDecoded) {
            this.decode();
        }
        if (this.issuerCertificate == null) {
            throw new IllegalStateException("Issuer certificate not set");
        }
        try {
            Signature signature = JCEUtil.getSignatureInstance(CryptoUtils.getSignatureAlg(this.sigAlgID));
            signature.initVerify(this.issuerCertificate.getPublicKey());
            signature.update(Utils.toBytes(this.getTBSCert()));
            return signature.verify(this.getSigBytes());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AuthenticationException(noSuchAlgorithmException);
        }
        catch (java.security.SignatureException signatureException) {
            throw new AuthenticationException(signatureException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new AuthenticationException(invalidKeyException);
        }
        catch (StreamableOutputException streamableOutputException) {
            throw new AuthenticationException(streamableOutputException);
        }
        catch (SignatureException signatureException) {
            throw new AuthenticationException(signatureException);
        }
    }

    public boolean verifyCertCRL() {
        if (!this.isDecoded) {
            this.decode();
        }
        if (this.issuerCRL == null) {
            throw new IllegalStateException("Issuer CRL not set");
        }
        return !this.issuerCRL.isRevoked(this.serialNo);
    }

    @Override
    public Entity getHolder() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.holder;
    }

    public void setHolder(X500Name x500Name) {
        this.holder = x500Name;
        this.resetAll();
    }

    @Override
    public oracle.security.crypto.core.PublicKey getPublicKey() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.key;
    }

    public void setPublicKey(oracle.security.crypto.core.PublicKey publicKey) {
        this.setPublicKey((PublicKey)publicKey);
    }

    public void setPublicKey(PublicKey publicKey) {
        this.key = CryptoUtils.fromJCEPublicKey(publicKey);
        this.resetAll();
    }

    public Date getNotBeforeDate() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.notBeforeDate;
    }

    public void setNotBeforeDate(Date date) {
        this.notBeforeDate = date;
        this.resetAll();
    }

    public Date getNotAfterDate() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.notAfterDate;
    }

    public void setNotAfterDate(Date date) {
        this.notAfterDate = date;
        this.resetAll();
    }

    public void setValidity(int n2) {
        this.notBeforeDate = new Date();
        this.notAfterDate = Utils.daysFrom(this.notBeforeDate, n2);
        this.resetAll();
    }

    public X500Name getSubject() {
        if (!this.isDecoded) {
            this.decode();
        }
        return (X500Name)this.holder;
    }

    public void setSubject(X500Name x500Name) {
        this.holder = x500Name;
        this.resetAll();
    }

    public X500Name getIssuer() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.issuer;
    }

    public void setIssuer(X500Name x500Name) {
        this.issuer = x500Name;
        if (this.issuerCRL != null && !x500Name.equals(this.issuerCRL.getIssuer())) {
            throw new IllegalStateException("Certificate issuer does not match CRL issuer");
        }
        this.resetAll();
    }

    public void setIssuerCertificate(X509 x509) {
        this.setIssuerCertificate(x509.toX509Certificate());
    }

    public void setIssuerCertificate(X509Certificate x509Certificate) {
        this.issuerCertificate = x509Certificate;
        if (this.issuer == null) {
            if (x509Certificate instanceof X509CertificateImpl) {
                this.setIssuer(((X509CertificateImpl)x509Certificate).toX509().getIssuer());
            } else {
                this.setIssuer(X500Name.toX500Name(x509Certificate.getIssuerX500Principal()));
            }
        }
    }

    public void setIssuerPrivateKey(oracle.security.crypto.core.PrivateKey privateKey) {
        this.setIssuerPrivateKey((PrivateKey)privateKey, null);
    }

    public void setIssuerPrivateKey(oracle.security.crypto.core.PrivateKey privateKey, AlgorithmIdentifier algorithmIdentifier) {
        this.setIssuerPrivateKey((PrivateKey)privateKey, null);
    }

    public void setIssuerPrivateKey(PrivateKey privateKey, AlgorithmIdentifier algorithmIdentifier) {
        this.issuerPrivateKey = privateKey;
        this.setSigAlgID(algorithmIdentifier);
    }

    public void setSigAlgID(AlgorithmIdentifier algorithmIdentifier) {
        this.sigAlgID = algorithmIdentifier;
        this.resetAll();
    }

    public void setIssuerCRL(CRL cRL) {
        if (!this.isDecoded) {
            this.decode();
        }
        this.issuerCRL = cRL;
        if (this.issuer != null && !this.issuer.equals(cRL.getIssuer())) {
            throw new IllegalStateException("CRL issuer does not match certificate issuer");
        }
    }

    public BigInteger getSerialNo() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.serialNo;
    }

    public void setSerialNo(BigInteger bigInteger) {
        this.serialNo = bigInteger;
        this.resetAll();
    }

    public boolean hasUnrecognizedCriticalExtension() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.extensions != null && this.extensions.hasUnrecognizedCriticalExtension();
    }

    public X509ExtensionSet getExtensionSet() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.extensions;
    }

    public X509Extension getExtension(ASN1ObjectID aSN1ObjectID) {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.extensions != null ? this.extensions.getExtension(aSN1ObjectID) : null;
    }

    public void setExtensions(X509ExtensionSet x509ExtensionSet) {
        this.extensions = x509ExtensionSet;
        this.resetAll();
    }

    public void addExtension(X509Extension x509Extension) {
        if (!this.isDecoded) {
            this.decode();
        }
        if (this.extensions == null) {
            this.extensions = new X509ExtensionSet();
        }
        this.extensions.addExtension(x509Extension);
        this.resetAll();
    }

    public byte[] getFingerprint() {
        if (!this.isDecoded) {
            this.decode();
        }
        try {
            String string = TransitionMode.isFIPS140ModeEnabled() ? "SHA-256" : "MD5";
            MessageDigest messageDigest = JCEUtil.getMessageDigestInstance(string);
            return messageDigest.digest(Utils.toBytes(this.toASN1Sequence()));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("MessageDigest algorithm not available.", noSuchAlgorithmException);
        }
        catch (SignatureException signatureException) {
            throw new IllegalStateException(signatureException);
        }
    }

    public static byte[] getCertID(X500Name x500Name, BigInteger bigInteger, oracle.security.crypto.core.MessageDigest messageDigest) {
        messageDigest.init();
        messageDigest.updateASCII(x500Name.toString());
        messageDigest.updateASCII(bigInteger.toString());
        messageDigest.computeCurrent();
        return messageDigest.getDigestBits();
    }

    public byte[] getCertID(oracle.security.crypto.core.MessageDigest messageDigest) {
        if (!this.isDecoded) {
            this.decode();
        }
        return X509.getCertID(this.issuer, this.serialNo, messageDigest);
    }

    public byte[] getCertID(String string) {
        try {
            MessageDigest messageDigest = JCEUtil.getMessageDigestInstance(string);
            if (!this.isDecoded) {
                this.decode();
            }
            messageDigest.update(this.issuer.toString().getBytes("ASCII"));
            messageDigest.update(this.serialNo.toString().getBytes("ASCII"));
            return messageDigest.digest();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
    }

    public ASN1ObjectID getSigAlgOID() {
        try {
            this.getTBSCert();
        }
        catch (SignatureException signatureException) {
            throw new IllegalStateException(signatureException);
        }
        if (this.sigAlgID != null) {
            return this.sigAlgID.getOID();
        }
        throw new IllegalStateException("Signature algorithm not defined");
    }

    public String getSigAlgString() {
        String string = null;
        string = CryptoUtils.getSignatureAlg(new AlgorithmIdentifier(this.getSigAlgOID()));
        if (string == null) {
            string = this.getSigAlgOID().toStringCompact();
        }
        return string;
    }

    public boolean verifySignature(byte[] byArray, byte[] byArray2, AlgorithmIdentifier algorithmIdentifier) throws AuthenticationException {
        if (!this.isDecoded) {
            this.decode();
        }
        try {
            Signature signature = JCEUtil.getSignatureInstance(CryptoUtils.getSignatureAlg(algorithmIdentifier));
            signature.initVerify(this.key);
            signature.update(byArray);
            return signature.verify(byArray2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AuthenticationException(noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new AuthenticationException(invalidKeyException);
        }
        catch (java.security.SignatureException signatureException) {
            throw new AuthenticationException(signatureException);
        }
    }

    public boolean equals(Object object) {
        if (!this.isDecoded) {
            this.decode();
        }
        if (object == null) {
            return false;
        }
        if (object instanceof X509) {
            return Utils.areEqual(Utils.toBytes(this), Utils.toBytes((X509)object));
        }
        if (object instanceof X509Certificate) {
            try {
                return Utils.areEqual(Utils.toBytes(this), ((X509Certificate)object).getEncoded());
            }
            catch (CertificateEncodingException certificateEncodingException) {
                return false;
            }
        }
        return false;
    }

    public int hashCode() {
        if (!this.isDecoded) {
            this.decode();
        }
        return Arrays.hashCode(Utils.toBytes(this));
    }

    public String toString() {
        if (!this.isDecoded) {
            this.decode();
        }
        String string = "";
        string = string + "{ fingerprint = " + Utils.toHexString(this.getFingerprint());
        string = string + ", notBefore = " + this.notBeforeDate;
        string = string + ", notAfter = " + this.notAfterDate;
        string = string + ", holder = " + this.holder;
        string = string + ", issuer = " + this.issuer;
        string = string + ", serialNo = " + this.serialNo;
        string = string + ", sigAlgOID = " + this.getSigAlgString();
        string = string + ", key = " + this.key;
        if (this.extensions != null && this.extensions.size() > 0) {
            string = string + ", extensions = {";
            boolean bl2 = false;
            Iterator<X509Extension> iterator = this.extensions.getExtensionsAsList().iterator();
            while (iterator.hasNext()) {
                if (bl2) {
                    string = string + ", ";
                }
                string = string + iterator.next();
                bl2 = true;
            }
            string = string + " }";
        }
        string = string + " }";
        return string;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }

    public X509Certificate toX509Certificate() {
        return this.certImpl;
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (date.before(this.notBeforeDate)) {
            throw new CertificateNotYetValidException("Certificate not yet valid");
        }
        if (date.after(this.notAfterDate)) {
            throw new CertificateExpiredException("Certificate expired");
        }
    }

    public int getBasicConstraints() {
        BasicConstraintsExtension basicConstraintsExtension = (BasicConstraintsExtension)this.extensions.getExtension(PKIX.id_ce_basicConstraints);
        if (basicConstraintsExtension == null) {
            return -1;
        }
        if (!basicConstraintsExtension.getCA()) {
            return 0;
        }
        if (basicConstraintsExtension.getPathLen() == null) {
            return Integer.MAX_VALUE;
        }
        return basicConstraintsExtension.getPathLen().intValue();
    }

    public Principal getIssuerDN() {
        return this.getIssuer().toX500Principal();
    }

    public X500Principal getIssuerX500Principal() {
        return this.getIssuer().toX500Principal();
    }

    public X500Principal getSubjectX500Principal() {
        return this.getSubject().toX500Principal();
    }

    public boolean[] getIssuerUniqueID() {
        return this.issuerID;
    }

    public boolean[] getKeyUsage() {
        KeyUsageExtension keyUsageExtension = (KeyUsageExtension)this.extensions.getExtension(PKIX.id_ce_keyUsage);
        return keyUsageExtension.getKeyUsage();
    }

    public Date getNotAfter() {
        return this.getNotAfterDate();
    }

    public Date getNotBefore() {
        return this.getNotBeforeDate();
    }

    public BigInteger getSerialNumber() {
        return this.getSerialNo();
    }

    public String getSigAlgName() {
        return CryptoUtils.getSignatureAlg(this.sigAlgID);
    }

    public byte[] getSigAlgParams() {
        return Utils.toBytes(this.sigAlgID.getParameters());
    }

    public byte[] getSignature() {
        try {
            return this.getSigBytes();
        }
        catch (SignatureException signatureException) {
            throw new RuntimeException(signatureException);
        }
    }

    public Principal getSubjectDN() {
        return this.getSubjectX500Principal();
    }

    public boolean[] getSubjectUniqueID() {
        return this.subjectID;
    }

    public byte[] getTBSCertificate() throws CertificateEncodingException {
        try {
            return Utils.toBytes(this.getTBSCert());
        }
        catch (SignatureException signatureException) {
            throw new RuntimeException(signatureException);
        }
    }

    public int getVersion() {
        return this.version;
    }

    public void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, java.security.SignatureException {
        Signature signature = string != null && !TransitionMode.isFIPS140ModeEnabled() ? Signature.getInstance(this.getSigAlgName(), string) : JCEUtil.getSignatureInstance(this.getSigAlgName());
        signature.initVerify(publicKey);
        signature.update(this.getTBSCertificate());
        boolean bl2 = signature.verify(this.getSignature());
        if (!bl2) {
            throw new java.security.SignatureException("Public key does not match");
        }
    }

    public void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, java.security.SignatureException {
        this.verify(publicKey, null);
    }

    public Set<String> getCriticalExtensionOIDs() {
        return this.extensions.getCriticalExtensionOIDs();
    }

    public byte[] getExtensionValue(String string) {
        return this.extensions.getExtensionValue(string);
    }

    public Set<String> getNonCriticalExtensionOIDs() {
        return this.extensions.getNonCriticalExtensionOIDs();
    }

    public boolean hasUnsupportedCriticalExtension() {
        return this.extensions.hasUnsupportedCriticalExtension();
    }

    public List<String> getExtendedKeyUsage() throws CertificateParsingException {
        ExtKeyUsageExtension extKeyUsageExtension = (ExtKeyUsageExtension)this.extensions.getExtension(PKIX.id_ce_extKeyUsage);
        if (extKeyUsageExtension == null) {
            return null;
        }
        ArrayList<ASN1ObjectID> arrayList = extKeyUsageExtension.getKeyPurposesAsList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (ASN1ObjectID aSN1ObjectID : arrayList) {
            arrayList2.add(aSN1ObjectID.toStringCompact());
        }
        return arrayList2;
    }

    public Collection<List<?>> getIssuerAlternativeNames() throws CertificateParsingException {
        IssuerAltNameExtension issuerAltNameExtension = (IssuerAltNameExtension)this.extensions.getExtension(PKIX.id_ce_issuerAltName);
        if (issuerAltNameExtension == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        for (GeneralName generalName : issuerAltNameExtension.getIssuerAltName()) {
            arrayList.add(generalName.getTypeAndValue());
        }
        return arrayList;
    }

    public Collection<List<?>> getSubjectAlternativeNames() throws CertificateParsingException {
        SubjectAltNameExtension subjectAltNameExtension = (SubjectAltNameExtension)this.extensions.getExtension(PKIX.id_ce_subjectAltName);
        if (subjectAltNameExtension == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        for (GeneralName generalName : subjectAltNameExtension.getSubjectAltName()) {
            arrayList.add(generalName.getTypeAndValue());
        }
        return arrayList;
    }

    class X509CertificateImpl
    extends X509Certificate {
        X509CertificateImpl() {
        }

        @Override
        public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
            X509.this.checkValidity();
        }

        @Override
        public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
            X509.this.checkValidity(date);
        }

        @Override
        public int getBasicConstraints() {
            return X509.this.getBasicConstraints();
        }

        @Override
        public Principal getIssuerDN() {
            return X509.this.getIssuerDN();
        }

        @Override
        public X500Principal getIssuerX500Principal() {
            return X509.this.getIssuerX500Principal();
        }

        @Override
        public X500Principal getSubjectX500Principal() {
            return X509.this.getSubjectX500Principal();
        }

        @Override
        public boolean[] getIssuerUniqueID() {
            return X509.this.getIssuerUniqueID();
        }

        @Override
        public boolean[] getKeyUsage() {
            return X509.this.getKeyUsage();
        }

        @Override
        public Date getNotAfter() {
            return X509.this.getNotAfter();
        }

        @Override
        public Date getNotBefore() {
            return X509.this.getNotBefore();
        }

        @Override
        public BigInteger getSerialNumber() {
            return X509.this.getSerialNumber();
        }

        @Override
        public String getSigAlgName() {
            return X509.this.getSigAlgName();
        }

        @Override
        public String getSigAlgOID() {
            return X509.this.getSigAlgOID().toStringCompact();
        }

        @Override
        public byte[] getSigAlgParams() {
            return X509.this.getSigAlgParams();
        }

        @Override
        public byte[] getSignature() {
            return X509.this.getSignature();
        }

        @Override
        public Principal getSubjectDN() {
            return X509.this.getSubjectDN();
        }

        @Override
        public boolean[] getSubjectUniqueID() {
            return X509.this.getSubjectUniqueID();
        }

        @Override
        public byte[] getTBSCertificate() throws CertificateEncodingException {
            return X509.this.getTBSCertificate();
        }

        @Override
        public int getVersion() {
            return X509.this.getVersion();
        }

        @Override
        public byte[] getEncoded() throws CertificateEncodingException {
            return X509.this.getEncoded();
        }

        @Override
        public PublicKey getPublicKey() {
            return X509.this.getPublicKey();
        }

        @Override
        public String toString() {
            return X509.this.toString();
        }

        @Override
        public void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, java.security.SignatureException {
            X509.this.verify(publicKey, string);
        }

        @Override
        public void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, java.security.SignatureException {
            X509.this.verify(publicKey);
        }

        @Override
        public Set<String> getCriticalExtensionOIDs() {
            return X509.this.getCriticalExtensionOIDs();
        }

        @Override
        public byte[] getExtensionValue(String string) {
            return X509.this.getExtensionValue(string);
        }

        @Override
        public Set<String> getNonCriticalExtensionOIDs() {
            return X509.this.getNonCriticalExtensionOIDs();
        }

        @Override
        public boolean hasUnsupportedCriticalExtension() {
            return X509.this.hasUnsupportedCriticalExtension();
        }

        @Override
        public List<String> getExtendedKeyUsage() throws CertificateParsingException {
            return X509.this.getExtendedKeyUsage();
        }

        @Override
        public Collection<List<?>> getIssuerAlternativeNames() throws CertificateParsingException {
            return X509.this.getIssuerAlternativeNames();
        }

        @Override
        public Collection<List<?>> getSubjectAlternativeNames() throws CertificateParsingException {
            return X509.this.getSubjectAlternativeNames();
        }

        @Override
        public boolean equals(Object object) {
            return X509.this.equals(object);
        }

        @Override
        public int hashCode() {
            return X509.this.hashCode();
        }

        public X509 toX509() {
            return X509.this;
        }
    }
}

