/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import oracle.security.crypto.asn1.ASN1Boolean;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.OIDRegistrar;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.OIDManager;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class X509Extension
implements Externalizable,
ASN1Object {
    public static final ASN1ObjectID id_netscape_ce = PKIX.id_netscape_ce;
    public static final ASN1ObjectID id_netscape_ce_type = PKIX.id_netscape_ce_type;
    public static final ASN1ObjectID id_set_ce = PKIX.id_set_ce;
    public static final ASN1ObjectID id_set_ce_type = PKIX.id_set_ce_type;
    protected boolean isDecoded = false;
    private ASN1ObjectID type;
    private boolean critical;
    private byte[] value;
    private ASN1Sequence contents = null;

    public X509Extension() {
    }

    protected X509Extension(ASN1ObjectID aSN1ObjectID) {
        this(aSN1ObjectID, false);
    }

    protected X509Extension(ASN1ObjectID aSN1ObjectID, boolean bl2) {
        this.type = aSN1ObjectID;
        this.critical = bl2;
    }

    public X509Extension(ASN1ObjectID aSN1ObjectID, byte[] byArray) {
        this(aSN1ObjectID, false, byArray);
    }

    public X509Extension(ASN1ObjectID aSN1ObjectID, ASN1Object aSN1Object) {
        this(aSN1ObjectID, false, Utils.toBytes(aSN1Object));
    }

    public X509Extension(ASN1ObjectID aSN1ObjectID, boolean bl2, byte[] byArray) {
        this.type = aSN1ObjectID;
        this.critical = bl2;
        this.value = byArray;
    }

    public X509Extension(ASN1ObjectID aSN1ObjectID, boolean bl2, ASN1Object aSN1Object) {
        this(aSN1ObjectID, bl2, Utils.toBytes(aSN1Object));
    }

    public X509Extension(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public static X509Extension inputInstance(InputStream inputStream) throws IOException {
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        ASN1ObjectID aSN1ObjectID = new ASN1ObjectID(aSN1SequenceInputStream);
        boolean bl2 = aSN1SequenceInputStream.getCurrentTag() == 1 ? ASN1Boolean.inputValue(aSN1SequenceInputStream) : false;
        byte[] byArray = ASN1OctetString.inputValue(aSN1SequenceInputStream);
        aSN1SequenceInputStream.terminate();
        Class<?> clazz = OIDManager.getOIDManager().getMapping(aSN1ObjectID, "extension");
        if (clazz == null) {
            return new X509Extension(aSN1ObjectID, bl2, byArray);
        }
        X509Extension x509Extension = null;
        try {
            x509Extension = (X509Extension)clazz.newInstance();
            x509Extension.setCritical(bl2);
            x509Extension.setValue(byArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException(illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new IOException(instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new IOException(classCastException.toString());
        }
        return x509Extension;
    }

    public boolean isRecognized() {
        return OIDManager.getOIDManager().getMapping(this.getType(), "extension") != null;
    }

    public ASN1ObjectID getType() {
        return this.type;
    }

    public boolean getCritical() {
        return this.critical;
    }

    protected void setCritical(boolean bl2) {
        this.critical = bl2;
        this.reset();
    }

    public byte[] getValue() {
        return this.value;
    }

    protected void setValue(byte[] byArray) {
        this.value = byArray;
        this.reset();
        this.isDecoded = false;
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.outputASN1().output(outputStream);
    }

    private ASN1Sequence outputASN1() {
        if (this.contents != null) {
            return this.contents;
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(this.type);
        if (this.critical) {
            aSN1Sequence.addElement(new ASN1Boolean(this.critical));
        }
        aSN1Sequence.addElement(new ASN1OctetString(this.value));
        this.contents = aSN1Sequence;
        return this.contents;
    }

    private void reset() {
        this.contents = null;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.reset();
        this.isDecoded = false;
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.type = new ASN1ObjectID(aSN1SequenceInputStream);
        this.critical = aSN1SequenceInputStream.getCurrentTag() == 1 ? ASN1Boolean.inputValue(aSN1SequenceInputStream) : false;
        this.value = ASN1OctetString.inputValue(aSN1SequenceInputStream);
        aSN1SequenceInputStream.terminate();
    }

    @Override
    public int length() {
        return this.outputASN1().length();
    }

    public String toString() {
        return "oid = " + this.type + ", critical = " + this.critical + ", value = " + Utils.toHexString(this.value);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }

    static {
        OIDRegistrar.mapExtensions();
    }
}

