/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class X509ExtensionSet
implements Externalizable,
java.security.cert.X509Extension,
ASN1Object {
    private LinkedHashMap<ASN1ObjectID, X509Extension> extTable = new LinkedHashMap();
    private ASN1Sequence seq = null;

    public X509ExtensionSet() {
    }

    public X509ExtensionSet(Vector<X509Extension> vector) {
        this((List<X509Extension>)vector);
    }

    public X509ExtensionSet(List<X509Extension> list) {
        for (X509Extension x509Extension : list) {
            this.addExtension(x509Extension);
        }
    }

    public X509ExtensionSet(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public X509Extension addExtension(X509Extension x509Extension) {
        this.reset();
        return this.extTable.put(x509Extension.getType(), x509Extension);
    }

    public X509Extension getExtension(ASN1ObjectID aSN1ObjectID) {
        return this.extTable.get(aSN1ObjectID);
    }

    public Enumeration<ASN1ObjectID> types() {
        return this.extTable == null ? null : new Vector<ASN1ObjectID>(this.extTable.keySet()).elements();
    }

    public Map<ASN1ObjectID, X509Extension> getExtensionsAsMap() {
        return this.extTable;
    }

    public Vector<X509Extension> getExtensions() {
        return this.extTable == null ? null : new Vector<X509Extension>(this.extTable.values());
    }

    public ArrayList<X509Extension> getExtensionsAsList() {
        return this.extTable == null ? null : new ArrayList<X509Extension>(this.extTable.values());
    }

    public int size() {
        return this.extTable.size();
    }

    public boolean hasExtension(ASN1ObjectID aSN1ObjectID) {
        return this.extTable.containsKey(aSN1ObjectID);
    }

    public boolean hasUnrecognizedCriticalExtension() {
        for (X509Extension x509Extension : this.extTable.values()) {
            if (!x509Extension.getCritical() || x509Extension.isRecognized()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        Iterator<X509Extension> iterator = this.extTable.values().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (X509Extension x509Extension : this.extTable.values()) {
            if (!x509Extension.getCritical()) continue;
            linkedHashSet.add(x509Extension.getType().toStringCompact());
        }
        return linkedHashSet;
    }

    @Override
    public byte[] getExtensionValue(String string) {
        ASN1ObjectID aSN1ObjectID = new ASN1ObjectID(string);
        return this.extTable.get(aSN1ObjectID).getValue();
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (X509Extension x509Extension : this.extTable.values()) {
            if (x509Extension.getCritical()) continue;
            linkedHashSet.add(x509Extension.getType().toStringCompact());
        }
        return linkedHashSet;
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        return this.hasUnrecognizedCriticalExtension();
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.extTable.clear();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        while (aSN1SequenceInputStream.hasMoreData()) {
            this.addExtension(X509Extension.inputInstance(aSN1SequenceInputStream));
        }
        aSN1SequenceInputStream.terminate();
        this.reset();
        if (this.size() == 0) {
            throw new ASN1FormatException("Extension set must contain at least 1 extension");
        }
    }

    private void reset() {
        this.seq = null;
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.seq == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            for (X509Extension x509Extension : this.extTable.values()) {
                aSN1Sequence.addElement(x509Extension);
            }
            this.seq = aSN1Sequence;
        }
        return this.seq;
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.toASN1Sequence().output(outputStream);
    }

    @Override
    public int length() {
        return this.toASN1Sequence().length();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }
}

