/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1String;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class X509PolicyInformation
implements Externalizable,
ASN1Object {
    private ASN1ObjectID id;
    private ArrayList<ASN1Object> policyQualifiers;
    private ASN1Sequence contents;

    public X509PolicyInformation() {
    }

    public X509PolicyInformation(ASN1ObjectID aSN1ObjectID) {
        this.id = aSN1ObjectID;
    }

    public X509PolicyInformation(ASN1ObjectID aSN1ObjectID, Vector<ASN1Object> vector) {
        this(aSN1ObjectID, (List<ASN1Object>)vector);
    }

    public X509PolicyInformation(ASN1ObjectID aSN1ObjectID, List<ASN1Object> list) {
        this.id = aSN1ObjectID;
        this.policyQualifiers = list == null ? null : (list instanceof ArrayList ? (ArrayList<Object>)list : new ArrayList<ASN1Object>(list));
    }

    public X509PolicyInformation(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public void addPolicyQualifier(ASN1ObjectID aSN1ObjectID, ASN1Object aSN1Object) {
        if (this.id.equals(PKIX.anyPolicy) && !aSN1ObjectID.equals(PKIX.id_qt_cps) && !aSN1ObjectID.equals(PKIX.id_qt_unotice)) {
            throw new IllegalArgumentException("Illegal qualifier type for anyPolicy policy");
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(aSN1ObjectID);
        aSN1Sequence.addElement(aSN1Object);
        if (this.policyQualifiers == null) {
            this.policyQualifiers = new ArrayList();
        }
        this.policyQualifiers.add(aSN1Sequence);
        this.reset();
    }

    public void addCPSPointer(String string) {
        this.addPolicyQualifier(PKIX.id_qt_cps, new ASN1String(string, 22));
    }

    public void addUserNotice(String string, int[] nArray, String string2) {
        if (string == null ^ nArray == null) {
            throw new IllegalArgumentException("Both or neither of organization and noticeNumbers must be present");
        }
        if (string == null && string2 == null) {
            throw new IllegalArgumentException("No user notice content given");
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        if (string != null) {
            ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
            aSN1Sequence2.addElement(new ASN1String(string));
            ASN1Sequence aSN1Sequence3 = new ASN1Sequence();
            int n2 = nArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                aSN1Sequence3.addElement(new ASN1Integer(nArray[i2]));
            }
            aSN1Sequence2.addElement(aSN1Sequence3);
            aSN1Sequence.addElement(aSN1Sequence2);
        }
        if (string2 != null) {
            aSN1Sequence.addElement(new ASN1String(string2));
        }
        this.addPolicyQualifier(PKIX.id_qt_unotice, aSN1Sequence);
    }

    public ASN1ObjectID getID() {
        return this.id;
    }

    @Deprecated
    public Vector<ASN1Object> getPolicyQualifiers() {
        return this.policyQualifiers == null ? null : new Vector<ASN1Object>(this.policyQualifiers);
    }

    public ArrayList<ASN1Object> getPolicyQualifiersAsList() {
        return this.policyQualifiers;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.id = new ASN1ObjectID(aSN1SequenceInputStream);
        this.policyQualifiers = aSN1SequenceInputStream.hasMoreData() ? new ASN1Sequence(aSN1SequenceInputStream).elementsAsList() : null;
        aSN1SequenceInputStream.terminate();
        this.reset();
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.outputASN1().output(outputStream);
    }

    private ASN1Sequence outputASN1() {
        if (this.contents == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(this.id);
            if (this.policyQualifiers != null) {
                aSN1Sequence.addElement(new ASN1Sequence((List<? extends ASN1Object>)this.policyQualifiers));
            }
            this.contents = aSN1Sequence;
        }
        return this.contents;
    }

    @Override
    public int length() {
        return this.outputASN1().length();
    }

    private void reset() {
        this.contents = null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("id = " + this.id);
        if (this.policyQualifiers != null) {
            stringBuffer.append(", policyQualifiers = " + Utils.toHexString(Utils.toBytes(new ASN1Sequence((List<? extends ASN1Object>)this.policyQualifiers))));
        }
        return stringBuffer.toString();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }
}

