/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.cert.AuthorityInfoAccess;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class AuthorityInfoAccessExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_pe_authorityInfoAccess;
    private AuthorityInfoAccess access;

    public AuthorityInfoAccessExtension() {
        super(TYPE);
    }

    public AuthorityInfoAccessExtension(AuthorityInfoAccess authorityInfoAccess) {
        this(authorityInfoAccess, false);
    }

    public AuthorityInfoAccessExtension(AuthorityInfoAccess authorityInfoAccess, boolean bl2) {
        super(TYPE, bl2);
        this.setAuthorityInfoAccess(authorityInfoAccess);
    }

    public AuthorityInfoAccessExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public void setAuthorityInfoAccess(AuthorityInfoAccess authorityInfoAccess) {
        this.access = authorityInfoAccess;
        this.setValue(this.toByteArray());
    }

    public AuthorityInfoAccess getAuthorityInfoAccess() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.access;
    }

    private byte[] toByteArray() {
        byte[] byArray = Utils.toBytes(this.access);
        this.isDecoded = true;
        return byArray;
    }

    private void decodeValue() {
        try {
            this.access = new AuthorityInfoAccess(new UnsyncByteArrayInputStream(this.getValue()));
            if (this.access.methodCount() == 0) {
                throw new ASN1FormatException("Malformed extension contents");
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return "authorityInfoAccessExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = " + this.getAuthorityInfoAccess() + "}";
    }
}

