/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1GenericPrimitive;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class AuthorityKeyIDExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_authorityKeyIdentifier;
    private byte[] keyID = null;
    private ArrayList<GeneralName> issuer = null;
    private BigInteger serialNo = null;

    public AuthorityKeyIDExtension() {
        super(TYPE);
    }

    public AuthorityKeyIDExtension(byte[] byArray) {
        this(byArray, false);
    }

    public AuthorityKeyIDExtension(byte[] byArray, boolean bl2) {
        super(TYPE, bl2);
        this.keyID = byArray;
        this.setValue(this.toByteArray());
    }

    public AuthorityKeyIDExtension(GeneralName generalName, BigInteger bigInteger) {
        this(generalName, bigInteger, false);
    }

    public AuthorityKeyIDExtension(GeneralName generalName, BigInteger bigInteger, boolean bl2) {
        super(TYPE, bl2);
        this.issuer = new ArrayList();
        this.issuer.add(generalName);
        this.serialNo = bigInteger;
        this.setValue(this.toByteArray());
    }

    public AuthorityKeyIDExtension(Vector<GeneralName> vector, BigInteger bigInteger) {
        this((List<GeneralName>)vector, bigInteger);
    }

    public AuthorityKeyIDExtension(List<GeneralName> list, BigInteger bigInteger) {
        this(list, bigInteger, false);
    }

    public AuthorityKeyIDExtension(Vector<GeneralName> vector, BigInteger bigInteger, boolean bl2) {
        this((List<GeneralName>)vector, bigInteger, bl2);
    }

    public AuthorityKeyIDExtension(List<GeneralName> list, BigInteger bigInteger, boolean bl2) {
        super(TYPE, bl2);
        this.issuer = list == null ? null : (list instanceof ArrayList ? (ArrayList<Object>)list : new ArrayList<GeneralName>(list));
        this.serialNo = bigInteger;
        this.setValue(this.toByteArray());
    }

    public AuthorityKeyIDExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public byte[] getAuthorityKeyID() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.keyID;
    }

    public Enumeration<GeneralName> authorityCertIssuer() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.issuer != null ? new VectorOverArrayList<GeneralName>(this.issuer).elements() : null;
    }

    public ArrayList<GeneralName> getAuthorityCertIssuer() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.issuer;
    }

    public BigInteger getAuthorityCertSerialNo() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.serialNo;
    }

    private byte[] toByteArray() {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        if (this.keyID != null) {
            aSN1Sequence.addElement(new ASN1GenericPrimitive(this.keyID, 0));
        }
        if (this.issuer != null && this.serialNo != null) {
            aSN1Sequence.addElement(new ASN1GenericConstructed(this.issuer, 1));
            aSN1Sequence.addElement(new ASN1GenericPrimitive(new ASN1Integer(this.serialNo), 2));
        }
        byte[] byArray = Utils.toBytes(aSN1Sequence);
        this.isDecoded = true;
        return byArray;
    }

    private void decodeValue() {
        try {
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(unsyncByteArrayInputStream);
            if (aSN1SequenceInputStream.getCurrentTag() == 0) {
                aSN1SequenceInputStream.setCurrentTag(4);
                this.keyID = ASN1OctetString.inputValue(aSN1SequenceInputStream);
            } else {
                this.keyID = null;
            }
            if (this.keyID == null || aSN1SequenceInputStream.hasMoreData()) {
                if (aSN1SequenceInputStream.getCurrentTag() == 1) {
                    aSN1SequenceInputStream.setCurrentTag(16);
                    ASN1SequenceInputStream aSN1SequenceInputStream2 = new ASN1SequenceInputStream(aSN1SequenceInputStream);
                    this.issuer = new ArrayList();
                    while (aSN1SequenceInputStream2.hasMoreData()) {
                        this.issuer.add(new GeneralName(aSN1SequenceInputStream2));
                    }
                    aSN1SequenceInputStream2.terminate();
                } else {
                    this.issuer = null;
                }
                if (aSN1SequenceInputStream.getCurrentTag() == 2) {
                    aSN1SequenceInputStream.setCurrentTag(2);
                    this.serialNo = ASN1Integer.inputValue(aSN1SequenceInputStream);
                } else {
                    this.serialNo = null;
                }
            } else {
                this.issuer = null;
                this.serialNo = null;
            }
            aSN1SequenceInputStream.terminate();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer stringBuffer = new StringBuffer("authorityKeyIDExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        boolean bl2 = false;
        if (this.getAuthorityKeyID() != null) {
            stringBuffer.append("keyID = " + Utils.toHexString(this.getAuthorityKeyID()));
            bl2 = true;
        }
        if (this.getAuthorityCertSerialNo() != null) {
            if (bl2) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("serialNo = " + this.getAuthorityCertSerialNo());
            bl2 = true;
        }
        if (this.issuer != null) {
            if (bl2) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("issuer = {");
            boolean bl3 = false;
            int n2 = this.issuer.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (bl3) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.issuer.get(i2).toString());
                bl3 = true;
            }
            stringBuffer.append("}");
        }
        stringBuffer.append("]}");
        return stringBuffer.toString();
    }
}

