/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import oracle.security.crypto.asn1.ASN1Boolean;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class BasicConstraintsExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_basicConstraints;
    private boolean ca = false;
    private BigInteger pathLen = null;

    public BasicConstraintsExtension() {
        super(TYPE);
    }

    public BasicConstraintsExtension(boolean bl2) {
        this(bl2, true);
    }

    public BasicConstraintsExtension(boolean bl2, boolean bl3) {
        super(TYPE, bl3);
        this.ca = bl2;
        this.setValue(this.toByteArray());
    }

    public BasicConstraintsExtension(BigInteger bigInteger) {
        this(bigInteger, true);
    }

    public BasicConstraintsExtension(BigInteger bigInteger, boolean bl2) {
        super(TYPE, bl2);
        this.ca = true;
        this.pathLen = bigInteger;
        this.setValue(this.toByteArray());
    }

    public BasicConstraintsExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public boolean getCA() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.ca;
    }

    public BigInteger getPathLen() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.pathLen;
    }

    private byte[] toByteArray() {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        if (this.ca) {
            aSN1Sequence.addElement(new ASN1Boolean(true));
        }
        if (this.pathLen != null) {
            aSN1Sequence.addElement(new ASN1Integer(this.pathLen));
        }
        byte[] byArray = Utils.toBytes(aSN1Sequence);
        this.isDecoded = true;
        return byArray;
    }

    private void decodeValue() {
        try {
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(unsyncByteArrayInputStream);
            if (aSN1SequenceInputStream.hasMoreData() && aSN1SequenceInputStream.getCurrentTag() == 1) {
                this.ca = ASN1Boolean.inputValue(aSN1SequenceInputStream);
            }
            if (aSN1SequenceInputStream.hasMoreData()) {
                this.pathLen = ASN1Integer.inputValue(aSN1SequenceInputStream);
            }
            aSN1SequenceInputStream.terminate();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return "basicConstraintsExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [ CA = " + this.getCA() + (this.getPathLen() != null ? ", pathLen = " + this.getPathLen() : "") + "]}";
    }
}

