/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class CRLCertificateIssuerExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_certificateIssuer;
    private ArrayList<GeneralName> certificateIssuer = new ArrayList();

    public CRLCertificateIssuerExtension() {
        super(TYPE);
    }

    public CRLCertificateIssuerExtension(GeneralName generalName) {
        this(generalName, true);
    }

    public CRLCertificateIssuerExtension(GeneralName generalName, boolean bl2) {
        super(TYPE, bl2);
        this.certificateIssuer.add(generalName);
        this.setValue(this.toByteArray());
    }

    public CRLCertificateIssuerExtension(Vector<GeneralName> vector) {
        this((List<GeneralName>)vector);
    }

    public CRLCertificateIssuerExtension(List<GeneralName> list) {
        this(list, true);
    }

    public CRLCertificateIssuerExtension(Vector<GeneralName> vector, boolean bl2) {
        this((List<GeneralName>)vector, bl2);
    }

    public CRLCertificateIssuerExtension(List<GeneralName> list, boolean bl2) {
        super(TYPE, bl2);
        this.certificateIssuer = list == null ? null : (list instanceof ArrayList ? (ArrayList<Object>)list : new ArrayList<GeneralName>(list));
        this.setValue(this.toByteArray());
    }

    public CRLCertificateIssuerExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public Enumeration<GeneralName> certificateIssuer() {
        ArrayList<GeneralName> arrayList = this.getCertificateIssuer();
        return arrayList == null ? null : new VectorOverArrayList<GeneralName>(arrayList).elements();
    }

    public ArrayList<GeneralName> getCertificateIssuer() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.certificateIssuer;
    }

    public void addIssuerName(GeneralName generalName) {
        this.certificateIssuer.add(generalName);
        this.setValue(this.toByteArray());
    }

    private byte[] toByteArray() {
        byte[] byArray = Utils.toBytes(new ASN1Sequence((List<? extends ASN1Object>)this.certificateIssuer));
        this.isDecoded = true;
        return byArray;
    }

    private void decodeValue() {
        try {
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(unsyncByteArrayInputStream);
            this.certificateIssuer = new ArrayList();
            while (aSN1SequenceInputStream.hasMoreData()) {
                this.certificateIssuer.add(new GeneralName(aSN1SequenceInputStream));
            }
            aSN1SequenceInputStream.terminate();
            if (this.certificateIssuer.size() == 0) {
                throw new ASN1FormatException("No GeneralName defined for extension");
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer stringBuffer = new StringBuffer("CRLCertificateIssuerExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        if (this.certificateIssuer != null) {
            stringBuffer.append("certificateIssuers = {");
            boolean bl2 = false;
            int n2 = this.certificateIssuer.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (bl2) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.certificateIssuer.get(i2).toString());
                bl2 = true;
            }
            stringBuffer.append("}");
        }
        stringBuffer.append("]}");
        return stringBuffer.toString();
    }
}

