/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.CRLDistPoint;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class CRLDistPointExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_cRLDistributionPoints;
    private ArrayList<CRLDistPoint> distPoint = new ArrayList();

    public CRLDistPointExtension() {
        super(TYPE);
    }

    public CRLDistPointExtension(CRLDistPoint cRLDistPoint) {
        this(cRLDistPoint, false);
    }

    public CRLDistPointExtension(CRLDistPoint cRLDistPoint, boolean bl2) {
        super(TYPE, bl2);
        this.addCRLDistPoint(cRLDistPoint);
    }

    public CRLDistPointExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public void addCRLDistPoint(CRLDistPoint cRLDistPoint) {
        this.distPoint.add(cRLDistPoint);
        this.setValue(this.toByteArray());
    }

    public Vector<CRLDistPoint> getCRLDistPoints() {
        ArrayList<CRLDistPoint> arrayList = this.getCRLDistPointsAsList();
        return arrayList == null ? null : new VectorOverArrayList<CRLDistPoint>(arrayList);
    }

    public ArrayList<CRLDistPoint> getCRLDistPointsAsList() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.distPoint;
    }

    private byte[] toByteArray() {
        byte[] byArray = Utils.toBytes(new ASN1Sequence((List<? extends ASN1Object>)this.distPoint));
        this.isDecoded = true;
        return byArray;
    }

    private void decodeValue() {
        try {
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(unsyncByteArrayInputStream);
            if (this.distPoint == null) {
                this.distPoint = new ArrayList();
            } else {
                this.distPoint.clear();
            }
            while (aSN1SequenceInputStream.hasMoreData()) {
                this.distPoint.add(new CRLDistPoint(aSN1SequenceInputStream));
            }
            aSN1SequenceInputStream.terminate();
            if (this.distPoint.size() == 0) {
                throw new ASN1FormatException("Malformed extension contents");
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer stringBuffer = new StringBuffer("crlDistPointExtension { oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        if (this.getCRLDistPointsAsList() != null) {
            stringBuffer.append("CRLDistributionPoints = { ");
            boolean bl2 = false;
            int n2 = this.getCRLDistPointsAsList().size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (bl2) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.getCRLDistPointsAsList().get(i2).toString());
                bl2 = true;
            }
            stringBuffer.append(" }");
        }
        stringBuffer.append("] }");
        return stringBuffer.toString();
    }
}

