/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.cert.CRLReason;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class CRLReasonExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_cRLReason;
    private CRLReason reason = null;

    public CRLReasonExtension() {
        super(TYPE);
    }

    public CRLReasonExtension(CRLReason cRLReason) {
        this(cRLReason, false);
    }

    public CRLReasonExtension(CRLReason cRLReason, boolean bl2) {
        super(TYPE, bl2);
        this.reason = cRLReason;
        this.setValue(this.toByteArray());
    }

    public CRLReasonExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public CRLReason getReason() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.reason;
    }

    private byte[] toByteArray() {
        byte[] byArray = Utils.toBytes(this.reason);
        this.isDecoded = true;
        return byArray;
    }

    private void decodeValue() {
        try {
            this.reason = new CRLReason(new UnsyncByteArrayInputStream(this.getValue()));
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return "CRLReasonExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", reason = " + this.getReason() + "}";
    }
}

