/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.cert.X509PolicyInformation;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class CertificatePoliciesExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_certificatePolicies;
    private ArrayList<X509PolicyInformation> certPolicies;

    public CertificatePoliciesExtension() {
        super(TYPE);
    }

    public CertificatePoliciesExtension(X509PolicyInformation x509PolicyInformation) {
        this(x509PolicyInformation, false);
    }

    public CertificatePoliciesExtension(X509PolicyInformation x509PolicyInformation, boolean bl2) {
        super(TYPE, bl2);
        this.certPolicies = new ArrayList();
        this.certPolicies.add(x509PolicyInformation);
        this.setValue(this.toByteArray());
    }

    public CertificatePoliciesExtension(Vector<X509PolicyInformation> vector) {
        this((List<X509PolicyInformation>)vector);
    }

    public CertificatePoliciesExtension(List<X509PolicyInformation> list) {
        this(list, false);
    }

    public CertificatePoliciesExtension(Vector<X509PolicyInformation> vector, boolean bl2) {
        this((List<X509PolicyInformation>)vector, bl2);
    }

    public CertificatePoliciesExtension(List<X509PolicyInformation> list, boolean bl2) {
        super(TYPE, bl2);
        this.certPolicies = list == null ? null : (list instanceof ArrayList ? (ArrayList<Object>)list : new ArrayList<X509PolicyInformation>(list));
        this.setValue(this.toByteArray());
    }

    public CertificatePoliciesExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public void addCertificatePolicy(X509PolicyInformation x509PolicyInformation) {
        if (this.certPolicies == null) {
            this.certPolicies = new ArrayList();
        }
        this.certPolicies.add(x509PolicyInformation);
        this.setValue(this.toByteArray());
    }

    public Vector<X509PolicyInformation> getCertificatePolicies() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.certPolicies == null ? null : new VectorOverArrayList<X509PolicyInformation>(this.certPolicies);
    }

    public ArrayList<X509PolicyInformation> getCertificatePoliciesAsList() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.certPolicies;
    }

    private byte[] toByteArray() {
        byte[] byArray = Utils.toBytes(new ASN1Sequence((List<? extends ASN1Object>)this.certPolicies));
        this.isDecoded = true;
        return byArray;
    }

    private void decodeValue() {
        try {
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(unsyncByteArrayInputStream);
            this.certPolicies = new ArrayList();
            while (aSN1SequenceInputStream.hasMoreData()) {
                this.certPolicies.add(new X509PolicyInformation(aSN1SequenceInputStream));
            }
            aSN1SequenceInputStream.terminate();
            if (this.certPolicies.size() == 0) {
                throw new ASN1FormatException("Malformed extension contents");
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer stringBuffer = new StringBuffer("certificatePoliciesExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        if (this.getCertificatePoliciesAsList() != null) {
            stringBuffer.append("certificatePolicies = {");
            boolean bl2 = false;
            int n2 = this.getCertificatePoliciesAsList().size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (bl2) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.getCertificatePoliciesAsList().get(i2).toString());
                bl2 = true;
            }
            stringBuffer.append("}");
        }
        stringBuffer.append("]}");
        return stringBuffer.toString();
    }
}

