/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class ExtKeyUsageExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_extKeyUsage;
    private ArrayList<ASN1ObjectID> keyPurposes = new ArrayList();

    public ExtKeyUsageExtension() {
        super(TYPE);
    }

    public ExtKeyUsageExtension(ASN1ObjectID aSN1ObjectID) {
        this(aSN1ObjectID, false);
    }

    public ExtKeyUsageExtension(ASN1ObjectID aSN1ObjectID, boolean bl2) {
        super(TYPE, bl2);
        this.keyPurposes.add(aSN1ObjectID);
        this.setValue(this.toByteArray());
    }

    public ExtKeyUsageExtension(Vector<ASN1ObjectID> vector, boolean bl2) {
        this((List<ASN1ObjectID>)vector, bl2);
    }

    public ExtKeyUsageExtension(List<ASN1ObjectID> list, boolean bl2) {
        super(TYPE, bl2);
        this.keyPurposes = list == null ? null : (list instanceof ArrayList ? (ArrayList<Object>)list : new ArrayList<ASN1ObjectID>(list));
        this.setValue(this.toByteArray());
    }

    public ExtKeyUsageExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public void addKeyPurpose(ASN1ObjectID aSN1ObjectID) {
        this.keyPurposes.add(aSN1ObjectID);
        this.setValue(this.toByteArray());
    }

    public Enumeration<ASN1ObjectID> getKeyPurposes() {
        ArrayList<ASN1ObjectID> arrayList = this.getKeyPurposesAsList();
        return arrayList == null ? null : new VectorOverArrayList<ASN1ObjectID>(arrayList).elements();
    }

    public ArrayList<ASN1ObjectID> getKeyPurposesAsList() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.keyPurposes;
    }

    public boolean hasKeyPurpose(ASN1ObjectID aSN1ObjectID) {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.keyPurposes.contains(aSN1ObjectID);
    }

    private byte[] toByteArray() {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        int n2 = this.keyPurposes.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            aSN1Sequence.addElement(this.keyPurposes.get(i2));
        }
        byte[] byArray = Utils.toBytes(aSN1Sequence);
        this.isDecoded = true;
        return byArray;
    }

    private void decodeValue() {
        try {
            this.keyPurposes = new ArrayList();
            ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(new UnsyncByteArrayInputStream(this.getValue()));
            while (aSN1SequenceInputStream.hasMoreData()) {
                this.keyPurposes.add(new ASN1ObjectID(aSN1SequenceInputStream));
            }
            aSN1SequenceInputStream.terminate();
            if (this.keyPurposes.size() == 0) {
                throw new ASN1FormatException("Malformed extension contents");
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer stringBuffer = new StringBuffer("extKeyUsageExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        if (this.keyPurposes != null) {
            stringBuffer.append("OIDs of key usage = {");
            boolean bl2 = false;
            int n2 = this.keyPurposes.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (bl2) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.keyPurposes.get(i2).toString());
                bl2 = true;
            }
            stringBuffer.append("}");
        }
        stringBuffer.append("]}");
        return stringBuffer.toString();
    }
}

